/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.util;

import java.util.LinkedList;
import java.util.List;

public final class StringUtils {
    public static String noNull(String string) {
        return string == null ? "" : string;
    }

    public static String padRight(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("padCount must be >= 0");
        }
        StringBuffer stringBuffer = new StringBuffer(StringUtils.noNull(string));
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String padRightToWidth(String string, int n) {
        String string2 = StringUtils.noNull(string);
        if (string2.length() < n) {
            string2 = StringUtils.padRight(string2, n - string2.length());
        }
        return string2;
    }

    public static List wrapToList(String string, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = -1;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    linkedList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    n2 = -1;
                    continue;
                }
                if (c == ' ') {
                    if (stringBuffer.length() >= n - 1) {
                        linkedList.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        n2 = -1;
                    }
                    if (stringBuffer.length() <= 0) continue;
                    n2 = stringBuffer.length();
                    stringBuffer.append(c);
                    continue;
                }
                if (stringBuffer.length() >= n && n2 != -1) {
                    linkedList.add(stringBuffer.substring(0, n2));
                    stringBuffer.delete(0, n2 + 1);
                    n2 = -1;
                }
                stringBuffer.append(c);
            }
            if (stringBuffer.length() > 0) {
                linkedList.add(stringBuffer.toString());
            }
        }
        return linkedList;
    }

    public static void main(String[] stringArray) {
        String string = "This is\n a test that I would like to word wrap at 15 characters.";
        System.out.println("123456789012345");
        List list = StringUtils.wrapToList(string, 15);
        for (String string2 : list) {
            System.out.println(string2 + "|");
        }
    }
}

