/*
 * Decompiled with CFR 0.152.
 */
package io.github.waterfallmc.waterfall;

import io.github.waterfallmc.waterfall.conf.WaterfallConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Property;

public final class VelocityForwardingUtils {
    public static final String VELOCITY_IP_FORWARDING_CHANNEL = "velocity:player_info";
    public static final String MODERN_IP_FORWARDING_FAILURE = "Your server did not send a forwarding request to the proxy. Is it set up correctly?";
    private static final int MODERN_DEFAULT = 1;
    private static final String ENCRYPT_ALGORITHM = "HmacSHA256";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] writeForwardingData(String address, String name, UUID playerUUID, Property[] properties) {
        byte[] byArray;
        ByteBuf buf = Unpooled.buffer(2048);
        DefinedPacket.writeVarInt(1, buf);
        DefinedPacket.writeString(address, buf);
        DefinedPacket.writeUUID(playerUUID, buf);
        DefinedPacket.writeString(name, buf);
        DefinedPacket.writeProperties(properties, buf);
        byte[] forwardingSecret = ((WaterfallConfiguration)BungeeCord.getInstance().config).getForwardingSecret();
        SecretKeySpec key = new SecretKeySpec(forwardingSecret, ENCRYPT_ALGORITHM);
        Mac mac = Mac.getInstance(ENCRYPT_ALGORITHM);
        mac.init(key);
        mac.update(buf.array(), buf.arrayOffset(), buf.readableBytes());
        byte[] sig = mac.doFinal();
        ByteBuf finished = Unpooled.wrappedBuffer(Unpooled.wrappedBuffer(sig), buf);
        try {
            byArray = ByteBufUtil.getBytes(finished);
        }
        catch (Throwable throwable) {
            try {
                finished.release();
                throw throwable;
            }
            catch (InvalidKeyException e) {
                buf.release();
                throw new RuntimeException("Unable to authenticate data", e);
            }
            catch (NoSuchAlgorithmException e) {
                buf.release();
                throw new AssertionError((Object)e);
            }
        }
        finished.release();
        return byArray;
    }

    private VelocityForwardingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

