/*
 * Decompiled with CFR 0.152.
 */
package io.github.waterfallmc.waterfall.conf;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.Util;
import net.md_5.bungee.conf.Configuration;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.api.forwarding.ForwardingMode;
import net.shieldcommunity.nullcordx.config.bungee.WaterfallSettings;

public class WaterfallConfiguration
extends Configuration {
    private int pluginChannelLimit = 128;
    private int pluginChannelNameLimit = 128;
    private boolean logInitialHandlerConnections = false;
    private String gameVersion;
    private boolean useNettyDnsResolver = true;
    private int tabThrottle = 500;
    private boolean disableModernTabLimiter = true;
    private boolean disableEntityMetadataRewrite = false;
    private boolean disableTabListRewrite = true;
    private ForwardingMode forwardingMode = ForwardingMode.BUNGEECORD_LEGACY;
    private byte[] forwardingSecret = Util.randomAlphanumericSequence(12);

    @Override
    public void load() {
        String forwardSecret;
        ForwardingMode fm;
        super.load();
        Logger logger = BungeeCord.getInstance().getLogger();
        WaterfallSettings.IMP.reload();
        boolean shouldSave = false;
        this.logInitialHandlerConnections = WaterfallSettings.IMP.LOG_INITIAL_HANDLER_CONNECTIONS;
        String gameVersion = WaterfallSettings.IMP.GAME_VERSION;
        if (gameVersion == null || gameVersion.equals("null")) {
            shouldSave = true;
            WaterfallSettings.IMP.GAME_VERSION = gameVersion = WaterfallConfiguration.createSupportedVersionText();
        }
        this.gameVersion = gameVersion;
        this.useNettyDnsResolver = WaterfallSettings.IMP.USE_NETTY_DNS_RESOLVER;
        this.tabThrottle = WaterfallSettings.IMP.THROTTLING.TAB_COMPLETE;
        this.disableModernTabLimiter = WaterfallSettings.IMP.DISABLE_MODERN_TAB_LIMITER;
        this.disableEntityMetadataRewrite = WaterfallSettings.IMP.DISABLE_ENTITY_METADATA_REWRITE;
        this.pluginChannelLimit = WaterfallSettings.IMP.REGISTERED_PLUGIN_CHANNELS_LIMIT;
        this.pluginChannelNameLimit = WaterfallSettings.IMP.PLUGIN_CHANNEL_NAME_LIMIT;
        this.disableTabListRewrite = WaterfallSettings.IMP.DISABLE_TAB_LIST_REWRITE;
        try {
            fm = ForwardingMode.valueOf(WaterfallSettings.IMP.FORWARDING_MODE.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            fm = ForwardingMode.BUNGEECORD_LEGACY;
            logger.severe("Wrong forwarding mode type! Using " + fm.name() + "...");
        }
        this.forwardingMode = fm;
        if (super.isIpForward()) {
            if (this.forwardingMode == ForwardingMode.BUNGEECORD_LEGACY) {
                logger.log(Level.WARNING, "Forwarding mode is on BungeeCord legacy **PLEASE READ waterfall.yml**If you are not using a local firewall is recommended to switch to another mode");
            }
        } else {
            logger.log(Level.WARNING, "Information forwarding (ip-forwarding) is disabled. Player UUIDs may not be consistent across the servers. For the optimal experience please enable ip_forward in the config.yml and configure forwarding and on your servers.");
        }
        if ((forwardSecret = WaterfallSettings.IMP.FORWARDING_SECRET) == null || forwardSecret.equals("null")) {
            shouldSave = true;
            WaterfallSettings.IMP.FORWARDING_SECRET = forwardSecret = new String(Util.randomAlphanumericSequence(12), StandardCharsets.UTF_8);
            logger.warning("A new forwarding secret has been generated. If this was the first start of the proxy please configure forwarding for your network in waterfall.yml");
        }
        this.forwardingSecret = forwardSecret.getBytes(StandardCharsets.UTF_8);
        if (shouldSave) {
            WaterfallSettings.IMP.save();
        }
    }

    @Override
    public boolean isLogInitialHandlerConnections() {
        return this.logInitialHandlerConnections;
    }

    @Override
    public String getGameVersion() {
        return this.gameVersion;
    }

    @Override
    public boolean isUseNettyDnsResolver() {
        return this.useNettyDnsResolver;
    }

    @Override
    public int getTabThrottle() {
        return this.tabThrottle;
    }

    @Override
    public boolean isDisableModernTabLimiter() {
        return this.disableModernTabLimiter;
    }

    @Override
    public boolean isDisableEntityMetadataRewrite() {
        return this.disableEntityMetadataRewrite;
    }

    @Override
    public boolean isDisableTabListRewrite() {
        return this.disableTabListRewrite;
    }

    @Override
    public int getPluginChannelLimit() {
        return this.pluginChannelLimit;
    }

    @Override
    public int getPluginChannelNameLimit() {
        return this.pluginChannelNameLimit;
    }

    @Override
    public ForwardingMode getForwardingMode() {
        return this.forwardingMode;
    }

    public byte[] getForwardingSecret() {
        return this.forwardingSecret;
    }

    private static String createSupportedVersionText() {
        List<String> versions = ProtocolConstants.SUPPORTED_VERSIONS;
        return versions.get(0) + "-" + versions.get(versions.size() - 1);
    }
}

