/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.compress;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import net.md_5.bungee.protocol.DefinedPacket;
import net.shieldcommunity.nullcordx.natives.ByteBufAllocationUtils;
import net.shieldcommunity.nullcordx.natives.compression.Decompressor;

public class PacketDecompressor
extends MessageToMessageDecoder<ByteBuf> {
    private static final int VANILLA_MAXIMUM_UNCOMPRESSED_SIZE = 0x800000;
    private static final int MAXIMUM_UNCOMPRESSED_SIZE_WHILE_CHECKING = 33177;
    private boolean checking = false;
    private final Decompressor decompressor;
    private final int threshold;

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.decompressor.close();
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int size = DefinedPacket.readVarInt(in);
        if (size == 0) {
            out.add(in.retain());
            return;
        }
        if (this.threshold != -1 && size < this.threshold) {
            throw DefinedPacket.createFastBadPacketException("Uncompressed size " + size + " is less than threshold " + this.threshold);
        }
        if (size > 0x800000) {
            throw DefinedPacket.createFastBadPacketException("Uncompressed size " + size + " exceeds threshold of 8388608");
        }
        if (this.checking && size > 33177) {
            throw DefinedPacket.createFastBadPacketException("Uncompressed size " + size + " exceeds threshold of 33177 while checking");
        }
        ByteBuf uncompressed = this.checking ? ctx.alloc().directBuffer(size, size) : ctx.alloc().directBuffer(size);
        ByteBuf compatibleIn = ByteBufAllocationUtils.makeCorrect(ctx.alloc(), this.decompressor, in);
        try {
            this.decompressor.inflate(compatibleIn, uncompressed, size);
            out.add(uncompressed);
        }
        catch (Exception e) {
            uncompressed.release();
            throw e;
        }
        finally {
            compatibleIn.release();
        }
    }

    public PacketDecompressor(Decompressor decompressor, int threshold) {
        this.decompressor = decompressor;
        this.threshold = threshold;
    }

    public void setChecking(boolean checking) {
        this.checking = checking;
    }
}

