/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import es.xism4.software.ExploitExceptionHandler;
import io.github.waterfallmc.waterfall.utils.UUIDUtils;
import io.netty.channel.ChannelPipeline;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerHandshakeEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.compress.PacketDecompressor;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.http.HttpClient;
import net.md_5.bungee.jni.cipher.BungeeCipher;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.cipher.CipherDecoder;
import net.md_5.bungee.netty.cipher.CipherEncoder;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.PlayerPublicKey;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.CookieRequest;
import net.md_5.bungee.protocol.packet.CookieResponse;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.util.AllowedCharacters;
import net.md_5.bungee.util.CaseInsensitiveSet;
import net.md_5.bungee.util.QuietException;
import net.shieldcommunity.nullcordx.LanguageManagerImpl;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.AntiBotManagerImpl;
import net.shieldcommunity.nullcordx.antibot.virtual.VirtualConnector;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.checking.AntiBotCheckResult;
import net.shieldcommunity.nullcordx.api.checking.AntiBotCheckResultType;
import net.shieldcommunity.nullcordx.api.geyser.FloodgateDetector;
import net.shieldcommunity.nullcordx.api.geyser.GeyserHookManager;
import net.shieldcommunity.nullcordx.blacklist.BlacklistManager;
import net.shieldcommunity.nullcordx.cache.CachedChangeableMotd;
import net.shieldcommunity.nullcordx.cache.CachedMotdByAddress;
import net.shieldcommunity.nullcordx.cache.CachedMotdManager;
import net.shieldcommunity.nullcordx.cache.MotdCacheType;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.config.MotdSettings;
import net.shieldcommunity.nullcordx.netty.ChannelStatisticsAndPacketLimiterUpstreamHandler;
import net.shieldcommunity.nullcordx.netty.PacketLimit;
import net.shieldcommunity.nullcordx.statistics.CountedAttackStatistics;
import net.shieldcommunity.nullcordx.utils.InetSocketUtil;

public class InitialHandler
extends PacketHandler
implements PendingConnection {
    private static final String MOJANG_AUTH_URL = System.getProperty("waterfall.auth.url", "https://sessionserver.mojang.com/session/minecraft/hasJoined?username=%s&serverId=%s%s");
    private final BungeeCord bungee;
    private ChannelWrapper ch;
    private final ListenerInfo listener;
    private Handshake handshake;
    private LoginRequest loginRequest;
    private EncryptionRequest request;
    private PluginMessage brandMessage;
    private final Set<String> registeredChannels = new HashSet<String>();
    private State thisState = State.HANDSHAKE;
    private final Queue<CookieFuture> requestedCookies = new LinkedList<CookieFuture>();
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        @Override
        public void sendPacket(DefinedPacket packet) {
            InitialHandler.this.ch.write(packet);
        }
    };
    private boolean onlineMode;
    private InetSocketAddress virtualHost;
    private String name;
    private UUID uniqueId;
    private UUID offlineId;
    private UUID rewriteId;
    private LoginResult loginProfile;
    private boolean legacy;
    private String extraDataInHandshake;
    private boolean transferred;
    private UserConnection userCon;
    private final Collection<String> groups;
    private boolean geyser;
    private Runnable antibotEncryptionLoginTask;
    private static final boolean ACCEPT_INVALID_PACKETS = Boolean.parseBoolean(System.getProperty("waterfall.acceptInvalidPackets", "false"));

    @Override
    public boolean shouldHandle(PacketWrapper packet) throws Exception {
        return !this.ch.isClosing();
    }

    private boolean canSendKickMessage() {
        return this.thisState == State.USERNAME || this.thisState == State.ENCRYPT || this.thisState == State.FINISHING;
    }

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
    }

    @Override
    public void exception(Throwable t2) throws Exception {
        this.checkException(t2);
        if (this.canSendKickMessage()) {
            this.disconnect(ConfigSettings.IMP.HIDE_EXCEPTION_ON_CONNECTION_ERROR ? this.bungee.getTranslationComponent("error_occurred_connection") : TextComponent.fromLegacy(ChatColor.RED + Util.exception(t2)));
        }
    }

    public void checkException(Throwable cause) {
        Class<?> clazz;
        BlacklistManager blacklistManager = this.bungee.getNullCordX().getBlacklistManager();
        if (blacklistManager.isBlacklistedException(clazz = cause.getClass())) {
            blacklistManager.blackList(this.getAddress().getAddress(), "blacklisted exception '" + clazz.getName() + "'");
            this.bungee.getNullCordX().getStatisticsManager().addBlockedConnectionPerSecond();
        }
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        if (packet.packet == null && !this.ch.isClosed()) {
            this.bungee.getNullCordX().getStatisticsManager().addBlockedConnectionPerSecond();
            ExploitExceptionHandler.throwUnexpectedLoginPacketException(packet.buf);
        }
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        try {
            this.relayMessage(pluginMessage);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
                throw ex;
            }
            throw new QuietException(ex.getMessage());
        }
    }

    private static String getFirstLine(String str) {
        int pos = str.indexOf(10);
        return pos == -1 ? str : str.substring(0, pos);
    }

    private ServerPing getPingInfo(String motd, int protocol) {
        CountedAttackStatistics countedAttackStatistics = this.bungee.getNullCordX().getStatisticsManager().getPingStatistics();
        countedAttackStatistics.addCounterAndCheckAttack();
        return new ServerPing(new ServerPing.Protocol(this.bungee.getNameWithVersion(), protocol), new ServerPing.Players(this.listener.getMaxPlayers(), this.bungee.fakeOnlineCount(true), null), motd, (Favicon)(MotdSettings.IMP.MOTD.HIDE_FAVICON_ON_ATTACK && this.bungee.getNullCordX().isUnderPingAttack() ? null : BungeeCord.getInstance().config.getFaviconObject()));
    }

    @Override
    public void handle(StatusRequest statusRequest) throws Exception {
        String motd;
        InitialHandler.checkState(this.thisState == State.STATUS, "Not expecting STATUS");
        int protocol = ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED.contains(this.handshake.getProtocolVersion()) ? this.handshake.getProtocolVersion() : this.bungee.getProtocolVersion();
        CachedMotdManager cachedMotdManager = this.bungee.getNullCordX().getCachedMotdManager();
        CountedAttackStatistics countedAttackStatistics = this.bungee.getNullCordX().getStatisticsManager().getPingStatistics();
        if (cachedMotdManager.getType() == MotdCacheType.FULL_CUSTOM || cachedMotdManager.getType() == MotdCacheType.CACHE_PLUGINS_GLOBAL) {
            countedAttackStatistics.addCounterAndCheckAttack();
            CachedChangeableMotd cachedChangeableMotd = cachedMotdManager.getMotdByProtocol(protocol);
            if (cachedChangeableMotd == null) {
                this.ch.close();
                return;
            }
            ByteBufPacket cachedMotd = MotdSettings.IMP.MOTD.HIDE_FAVICON_ON_ATTACK && this.bungee.getNullCordX().isUnderPingAttack() ? cachedChangeableMotd.getMotdWithoutFavicon() : cachedChangeableMotd.getMotd();
            if (cachedMotd == null) {
                this.ch.close();
                return;
            }
            if (MotdSettings.IMP.MOTD.CLOSE_IF_TRY_CALCULATE_PING_ON_ATTACK && this.bungee.getNullCordX().isUnderPingAttack()) {
                cachedMotd.writeAndClose(this.ch, protocol);
            } else {
                cachedMotd.writeAndFlushPacket(this.ch, protocol);
                this.thisState = State.PING;
            }
            return;
        }
        Callback<ServerPing> pingBack = (result, error) -> {
            CachedMotdByAddress cachedMotd;
            if (error != null) {
                result = this.getPingInfo(this.bungee.getTranslationComponent("ping_cannot_connect").toLegacyText(), protocol);
                this.bungee.getLogger().log(Level.WARNING, "Error pinging remote server", error);
            }
            InetAddress inetAddress = this.getAddress().getAddress();
            if (cachedMotdManager.getType() == MotdCacheType.CACHE_PLUGINS && (cachedMotd = cachedMotdManager.getCachedMotdByIp(inetAddress)) != null) {
                cachedMotd.writeAndFlushPacket(this.ch, protocol);
                return;
            }
            Callback<ProxyPingEvent> callback = (pingResult, error1) -> {
                if (this.ch.isClosed()) {
                    return;
                }
                ServerPing serverPing = pingResult.getResponse();
                if (serverPing == null) {
                    this.ch.close();
                    return;
                }
                if (MotdSettings.IMP.MOTD.HIDE_FAVICON_ON_ATTACK && this.bungee.getNullCordX().isUnderPingAttack()) {
                    serverPing.setFavicon((Favicon)null);
                }
                if (cachedMotdManager.getType() == MotdCacheType.CACHE_PLUGINS) {
                    CachedMotdByAddress newCachedMotd = cachedMotdManager.addAndGetCachedMotdByIp(inetAddress, serverPing);
                    if (newCachedMotd != null) {
                        newCachedMotd.writeAndFlushPacket(this.ch, protocol);
                    }
                } else {
                    Gson gson = this.bungee.gson;
                    this.unsafe.sendPacket(new StatusResponse(gson.toJson(serverPing)));
                }
                if (this.bungee.getConnectionThrottle() != null) {
                    this.bungee.getConnectionThrottle().unthrottle(this.getSocketAddress());
                }
            };
            this.bungee.getPluginManager().callEvent(new ProxyPingEvent(this, (ServerPing)result, callback));
        };
        ServerInfo forced = AbstractReconnectHandler.getForcedHost(this);
        String string = motd = forced != null ? forced.getMotd() : this.listener.getMotd();
        if (forced != null && this.listener.isPingPassthrough()) {
            ((BungeeServerInfo)forced).ping(pingBack, this.handshake.getProtocolVersion());
        } else {
            pingBack.done(this.getPingInfo(motd, protocol), null);
        }
        if (MotdSettings.IMP.MOTD.CLOSE_IF_TRY_CALCULATE_PING_ON_ATTACK && this.bungee.getNullCordX().isUnderPingAttack()) {
            this.ch.close();
            return;
        }
        this.thisState = State.PING;
    }

    @Override
    public void handle(PingPacket ping) throws Exception {
        if (!ACCEPT_INVALID_PACKETS) {
            InitialHandler.checkState(this.thisState == State.PING, "Not expecting PING");
        }
        this.unsafe.sendPacket(ping);
        this.ch.close();
    }

    @Override
    public void handle(Handshake handshake) throws Exception {
        InitialHandler.checkState(this.thisState == State.HANDSHAKE, "Not expecting HANDSHAKE");
        this.handshake = handshake;
        this.ch.setVersion(handshake.getProtocolVersion());
        if (handshake.getHost().contains("\u0000")) {
            String[] split = handshake.getHost().split("\u0000", 2);
            handshake.setHost(split[0]);
            this.extraDataInHandshake = "\u0000" + split[1];
        }
        if (handshake.getHost().endsWith(".")) {
            handshake.setHost(handshake.getHost().substring(0, handshake.getHost().length() - 1));
        }
        this.virtualHost = InetSocketAddress.createUnresolved(handshake.getHost(), handshake.getPort());
        if (!ConfigSettings.IMP.PERFORMANCE.DISABLE_PLAYER_HANDSHAKE_EVENT) {
            this.bungee.getPluginManager().callEvent(new PlayerHandshakeEvent(this, handshake));
        }
        if (this.ch.isClosing()) {
            return;
        }
        switch (handshake.getRequestedProtocol()) {
            case 1: {
                if (this.bungee.getConfig().isLogPings()) {
                    this.bungee.getLogger().log(Level.INFO, "{0} has pinged", this.toString());
                }
                this.thisState = State.STATUS;
                this.ch.setProtocol(Protocol.STATUS);
                this.bungee.getNullCordX().getAntiBotDirectConnection().add(this.getAddress().getAddress());
                this.bungee.getNullCordX().getStatisticsManager().addPingPerSecond();
                break;
            }
            case 2: 
            case 3: {
                boolean bl = this.transferred = handshake.getRequestedProtocol() == 3;
                if (this.bungee.getConfig().isLogInitialHandlerConnections()) {
                    this.bungee.getLogger().log(Level.INFO, "{0} has connected", this.toString());
                }
                this.thisState = State.USERNAME;
                this.ch.setProtocol(Protocol.LOGIN);
                if (!ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED.contains(handshake.getProtocolVersion())) {
                    NullCordXImpl nullCordX = BungeeCord.getInstance().getNullCordX();
                    LanguageManagerImpl languageManager = nullCordX.getLanguageManager();
                    if (handshake.getProtocolVersion() > this.bungee.getProtocolVersion()) {
                        nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(languageManager.getDefaultLanguage()).sendKickPacket(KickType.OUTDATED_SERVER, this.ch, Protocol.LOGIN, this.getVersion());
                    } else {
                        nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(languageManager.getDefaultLanguage()).sendKickPacket(KickType.OUTDATED_CLIENT, this.ch, Protocol.LOGIN, this.getVersion());
                    }
                    return;
                }
                if (!this.transferred || !this.bungee.config.isRejectTransfers()) break;
                this.disconnect((BaseComponent)this.bungee.getTranslationComponent("reject_transfer"));
                return;
            }
            default: {
                ExploitExceptionHandler.throwInvalidProtocolException(handshake.getRequestedProtocol());
            }
        }
    }

    @Override
    public void handle(LoginRequest loginRequest) throws Exception {
        FloodgateDetector floodgateDetector;
        InitialHandler.checkState(this.thisState == State.USERNAME, "Not expecting USERNAME");
        NullCordXImpl nullCordX = this.bungee.getNullCordX();
        if (loginRequest.getData().length() > 16) {
            nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(nullCordX.getLanguageManager().getDefaultLanguage()).sendKickPacket(KickType.NAME_TOO_LONG, this.ch, Protocol.LOGIN, this.getVersion());
            return;
        }
        if (!AllowedCharacters.isValidName(loginRequest.getData(), this.onlineMode)) {
            nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(nullCordX.getLanguageManager().getDefaultLanguage()).sendKickPacket(KickType.NAME_INVALID, this.ch, Protocol.LOGIN, this.getVersion());
            return;
        }
        this.loginRequest = loginRequest;
        if (nullCordX.getGeyserIpAddresses().contains(this.getTrueAddress().getAddress())) {
            this.geyser = true;
        }
        if ((floodgateDetector = GeyserHookManager.getFloodgateDetector()) != null && floodgateDetector.isFloodgate(this.ch.getHandle())) {
            this.geyser = true;
        }
        nullCordX.getAntiBotManager().handleLoginRequest(this);
    }

    public void delayedHandleLoginRequest(NullCordXImpl nullCordX, AntiBotManagerImpl antiBotManager) throws Exception {
        int limit;
        AntiBotCheckResult antiBotCheckResult = antiBotManager.isNeedCheck(this);
        String name = this.loginRequest.getData();
        if (nullCordX.canSendDebugLog()) {
            nullCordX.sendDebugLog("For player " + name + " returned check state: '" + antiBotCheckResult);
        }
        if (antiBotCheckResult.isNeedCheck()) {
            antiBotManager.startConfiguredAntiBot(name, this, antiBotCheckResult);
            return;
        }
        if (antiBotCheckResult == AntiBotCheckResultType.ALLOWED_DUE_TO_MODE) {
            nullCordX.getStatisticsManager().getBotStatistics().addCounterAndCheckAttack();
            if (AntibotSettings.IMP.ANTIBOT.CONNECT_TO_FILTER_ONLY_ON_ATTACK.ALWAYS_CACHE) {
                nullCordX.getUserManager().saveCachedUser(this.getName().toLowerCase(), InetSocketUtil.getAddress(this.ch.getRemoteAddress()), false);
            }
        } else {
            nullCordX.getUserManager().saveCachedUser(this.getName().toLowerCase(), InetSocketUtil.getAddress(this.ch.getRemoteAddress()), false);
        }
        if (BungeeCord.getInstance().config.isEnforceSecureProfile() && this.getVersion() < 761) {
            PlayerPublicKey publicKey;
            if (this.handshake.getProtocolVersion() < 759) {
                this.disconnect((BaseComponent)this.bungee.getTranslationComponent("secure_profile_unsupported"));
            }
            if ((publicKey = this.loginRequest.getPublicKey()) == null) {
                this.disconnect((BaseComponent)this.bungee.getTranslationComponent("secure_profile_required"));
                return;
            }
            if (Instant.ofEpochMilli(publicKey.getExpiry()).isBefore(Instant.now())) {
                this.disconnect((BaseComponent)this.bungee.getTranslationComponent("secure_profile_expired"));
                return;
            }
            if (this.getVersion() < 760 && this.getVersion() < 761 && !EncryptionUtil.check(publicKey, null)) {
                this.disconnect((BaseComponent)this.bungee.getTranslationComponent("secure_profile_invalid"));
                return;
            }
        }
        if ((limit = BungeeCord.getInstance().config.getPlayerLimit()) > 0 && this.bungee.fakeOnlineCount(false) >= limit) {
            this.disconnect((BaseComponent)this.bungee.getTranslationComponent("proxy_full"));
            return;
        }
        if (!this.isOnlineMode() && this.bungee.getPlayer(this.getUniqueId()) != null) {
            this.disconnect((BaseComponent)this.bungee.getTranslationComponent("already_connected_proxy"));
            return;
        }
        Callback<PreLoginEvent> callback = (result, error) -> {
            if (result.isCancelled()) {
                BaseComponent reason = result.getReason();
                this.disconnect(reason != null ? reason : this.bungee.getTranslationComponent("kick_message"));
                return;
            }
            if (this.ch.isClosing()) {
                return;
            }
            if (this.onlineMode) {
                this.thisState = State.ENCRYPT;
                this.request = EncryptionUtil.encryptRequest();
                this.unsafe().sendPacket(this.request);
            } else {
                this.thisState = State.FINISHING;
                this.finish();
            }
        };
        this.bungee.getPluginManager().callEvent(new PreLoginEvent(this, callback));
    }

    @Override
    public void handle(EncryptionResponse encryptResponse) throws Exception {
        InitialHandler.checkState(this.thisState == State.ENCRYPT, "Not expecting ENCRYPT");
        InitialHandler.checkState(EncryptionUtil.check(this.loginRequest.getPublicKey(), encryptResponse, this.request), "Invalid verification");
        this.thisState = State.FINISHING;
        SecretKey sharedKey = EncryptionUtil.getSecret(encryptResponse, this.request);
        if (sharedKey instanceof SecretKeySpec && sharedKey.getEncoded().length != 16) {
            this.ch.close();
            return;
        }
        BungeeCipher decrypt = EncryptionUtil.getCipher(false, sharedKey);
        this.ch.addBefore("frame-decoder", "decrypt", new CipherDecoder(decrypt));
        BungeeCipher encrypt = EncryptionUtil.getCipher(true, sharedKey);
        this.ch.addBefore("ready-bytebuf-encoder", "encrypt", new CipherEncoder(encrypt));
        String encName = URLEncoder.encode(this.getName(), "UTF-8");
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        sha.update(this.request.getServerId().getBytes(StandardCharsets.ISO_8859_1));
        sha.update(sharedKey.getEncoded());
        sha.update(EncryptionUtil.keys.getPublic().getEncoded());
        String encodedHash = URLEncoder.encode(new BigInteger(sha.digest()).toString(16), "UTF-8");
        String preventProxy = BungeeCord.getInstance().config.isPreventProxyConnections() && this.getSocketAddress() instanceof InetSocketAddress ? "&ip=" + URLEncoder.encode(this.getAddress().getAddress().getHostAddress(), "UTF-8") : "";
        String authURL = String.format(MOJANG_AUTH_URL, encName, encodedHash, preventProxy);
        Callback<String> handler = (result, error) -> {
            if (error == null) {
                LoginResult obj = BungeeCord.getInstance().gson.fromJson((String)result, LoginResult.class);
                if (obj != null && obj.getId() != null) {
                    this.loginProfile = obj;
                    this.name = obj.getName();
                    this.uniqueId = Util.getUUID(obj.getId());
                    if (this.antibotEncryptionLoginTask != null) {
                        this.antibotEncryptionLoginTask.run();
                        this.antibotEncryptionLoginTask = null;
                        return;
                    }
                    this.finish();
                    return;
                }
                this.disconnect((BaseComponent)this.bungee.getTranslationComponent("offline_mode_player"));
            } else {
                this.disconnect((BaseComponent)this.bungee.getTranslationComponent("mojang_fail"));
                this.bungee.getLogger().log(Level.SEVERE, "Error authenticating " + this.getName() + " with minecraft.net", error);
            }
        };
        HttpClient.get(authURL, this.ch.getHandle().eventLoop(), handler);
    }

    private void finish() {
        this.offlineId = UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.getName()).getBytes(StandardCharsets.UTF_8));
        if (!ConfigSettings.IMP.ALWAYS_APPLY_OFFLINE_UUID) {
            if (this.uniqueId == null) {
                this.uniqueId = this.offlineId;
            }
        } else {
            this.uniqueId = this.offlineId;
        }
        UUID uUID = this.rewriteId = this.bungee.config.isIpForward() ? this.uniqueId : this.offlineId;
        if (BungeeCord.getInstance().config.isEnforceSecureProfile() && this.getVersion() >= 760) {
            boolean secure = false;
            try {
                secure = EncryptionUtil.check(this.loginRequest.getPublicKey(), this.uniqueId);
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            if (!secure) {
                this.disconnect((BaseComponent)this.bungee.getTranslationComponent("secure_profile_invalid"));
                return;
            }
        }
        ProxiedPlayer oldName = this.bungee.getPlayer(this.getName());
        if (this.isOnlineMode()) {
            ProxiedPlayer oldID;
            if (oldName != null) {
                this.disconnect((BaseComponent)this.bungee.getTranslationComponent("already_connected_proxy"));
            }
            if ((oldID = this.bungee.getPlayer(this.getUniqueId())) != null) {
                this.disconnect((BaseComponent)this.bungee.getTranslationComponent("already_connected_proxy"));
            }
        } else if (oldName != null) {
            this.disconnect((BaseComponent)this.bungee.getTranslationComponent("already_connected_proxy"));
            return;
        }
        Callback<LoginEvent> complete = (result, error) -> {
            if (result.isCancelled()) {
                BaseComponent reason = result.getReason();
                this.disconnect(reason != null ? reason : this.bungee.getTranslationComponent("kick_message"));
                return;
            }
            if (this.ch.isClosing()) {
                return;
            }
            this.ch.getHandle().eventLoop().execute(() -> {
                if (!this.ch.isClosing()) {
                    this.userCon = new UserConnection(this.bungee, this.ch, this.getName(), this);
                    this.userCon.setCompressionThreshold(BungeeCord.getInstance().config.getCompressionThreshold());
                    ChannelStatisticsAndPacketLimiterUpstreamHandler csapluh = this.ch.getHandle().pipeline().get(ChannelStatisticsAndPacketLimiterUpstreamHandler.class);
                    if (csapluh != null) {
                        csapluh.setPacketLimit(new PacketLimit(ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_BYTES, ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_PACKET_BYTES_PER_SECOND, ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_PACKETS_PER_SECOND));
                        csapluh.setConnection(this.userCon);
                    }
                    if (this.getVersion() < 764) {
                        this.unsafe.sendPacket(new LoginSuccess(this.getRewriteId(), this.getName(), this.loginProfile == null ? null : this.loginProfile.getProperties()));
                        this.ch.setProtocol(Protocol.GAME);
                    }
                    this.finish2();
                }
            });
        };
        this.bungee.getPluginManager().callEvent(new LoginEvent(this, complete, this.getLoginProfile()));
    }

    private void finish2() {
        if (!this.userCon.init()) {
            this.disconnect((BaseComponent)this.bungee.getTranslationComponent("already_connected_proxy"));
            return;
        }
        this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new UpstreamBridge(this.bungee, this.userCon));
        ServerInfo initialServer = this.bungee.getReconnectHandler() != null ? this.bungee.getReconnectHandler().getServer(this.userCon) : AbstractReconnectHandler.getForcedHost(this);
        if (initialServer == null) {
            initialServer = this.bungee.getServerInfo(this.listener.getDefaultServer());
        }
        Callback<PostLoginEvent> complete = (result, error) -> {
            if (this.ch.isClosing()) {
                return;
            }
            this.userCon.connect(result.getTarget(), null, true, ServerConnectEvent.Reason.JOIN_PROXY);
        };
        this.bungee.getPluginManager().callEvent(new PostLoginEvent(this.userCon, initialServer, complete));
    }

    @Override
    public void handle(LoginPayloadResponse response) throws Exception {
        this.ch.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(CookieResponse cookieResponse) {
        CookieFuture future;
        Queue<CookieFuture> queue = this.requestedCookies;
        synchronized (queue) {
            future = this.requestedCookies.peek();
            if (future != null) {
                if (future.cookie.equals(cookieResponse.getCookie())) {
                    Preconditions.checkState(future == this.requestedCookies.poll(), "requestedCookies queue mismatch");
                } else {
                    future = null;
                }
            }
        }
        if (future != null) {
            future.getFuture().complete(cookieResponse.getData());
            throw CancelSendSignal.INSTANCE;
        }
    }

    @Override
    public void disconnect(String reason) {
        if (this.canSendKickMessage()) {
            this.disconnect(TextComponent.fromLegacy(reason));
        } else {
            this.ch.close();
        }
    }

    @Override
    public void disconnect(BaseComponent ... reason) {
        this.disconnect(TextComponent.fromArray(reason));
    }

    @Override
    public void disconnect(BaseComponent reason) {
        if (this.canSendKickMessage()) {
            this.ch.close(new Kick(reason));
        } else {
            this.ch.close();
        }
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : (this.loginRequest == null ? null : this.loginRequest.getData());
    }

    @Override
    public int getVersion() {
        return this.handshake == null ? -1 : this.handshake.getProtocolVersion();
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.getSocketAddress();
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.ch.getRemoteAddress();
    }

    @Override
    public InetSocketAddress getTrueAddress() {
        return (InetSocketAddress)this.ch.getTrueRemoteAddress();
    }

    @Override
    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    public void setOnlineMode(boolean onlineMode) {
        Preconditions.checkState(this.thisState == State.USERNAME, "Can only set online mode status whilst state is username");
        this.onlineMode = onlineMode;
    }

    @Override
    public void setUniqueId(UUID uuid) {
        Preconditions.checkState(this.thisState == State.USERNAME, "Can only set uuid while state is username");
        Preconditions.checkState(!this.onlineMode, "Can only set uuid when online mode is false");
        this.uniqueId = uuid;
    }

    @Override
    public String getUUID() {
        return UUIDUtils.undash(this.uniqueId.toString());
    }

    @Override
    public String toString() {
        return "[" + this.getSocketAddress() + (String)(this.getName() != null ? "|" + this.getName() : "") + "] <-> InitialHandler";
    }

    @Override
    public boolean isConnected() {
        return !this.ch.isClosed();
    }

    public static void checkState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new QuietException(errorMessage);
        }
    }

    public void relayMessage(PluginMessage input) throws Exception {
        this.relayMessageAndCheck(input);
    }

    public boolean relayMessageAndCheck(PluginMessage input) throws Exception {
        switch (input.getTag()) {
            case "REGISTER": 
            case "minecraft:register": {
                String content = new String(input.getData(), StandardCharsets.UTF_8);
                for (String id : content.split("\u0000")) {
                    Preconditions.checkState(this.registeredChannels.size() <= this.bungee.getConfig().getPluginChannelLimit(), "Too many registered channels. This limit can be configured in the waterfall.yml");
                    Preconditions.checkArgument(id.length() <= this.bungee.getConfig().getPluginChannelNameLimit(), "Channel name too long. This limit can be configured in the waterfall.yml");
                    this.registeredChannels.add(id);
                }
                return true;
            }
            case "UNREGISTER": 
            case "minecraft:unregister": {
                String content = new String(input.getData(), StandardCharsets.UTF_8);
                for (String id : content.split("\u0000")) {
                    this.registeredChannels.remove(id);
                }
                return true;
            }
            case "MC|Brand": 
            case "minecraft:brand": {
                this.brandMessage = input;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<byte[]> retrieveCookie(String cookie) {
        Preconditions.checkState(this.getVersion() >= 0x400000BB, "Cookies are only supported in 1.20.5 and above");
        Preconditions.checkState(this.loginRequest != null, "Cannot retrieve cookies for status or legacy connections");
        if (((String)cookie).indexOf(58) == -1) {
            cookie = "minecraft:" + (String)cookie;
        }
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        Queue<CookieFuture> queue = this.requestedCookies;
        synchronized (queue) {
            this.requestedCookies.add(new CookieFuture((String)cookie, future));
        }
        this.unsafe.sendPacket(new CookieRequest((String)cookie));
        return future;
    }

    @Override
    public boolean isGeyser() {
        return this.geyser;
    }

    public void startLoginProcessForAntiBot(String name, AntiBotCheckResult antiBotCheckResult) {
        int limit = BungeeCord.getInstance().config.getPlayerLimit();
        NullCordXImpl nullCordX = BungeeCord.getInstance().getNullCordX();
        if (limit > 0 && this.bungee.fakeOnlineCount(false) >= limit) {
            nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(nullCordX.getLanguageManager().getDefaultLanguage()).sendKickPacket(KickType.PROXY_FULL, this.ch, Protocol.LOGIN, this.getVersion());
            return;
        }
        if (!this.isOnlineMode() && this.bungee.getPlayer(this.getUniqueId()) != null) {
            nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(nullCordX.getLanguageManager().getDefaultLanguage()).sendKickPacket(KickType.ALREADY_CONNECTED, this.ch, Protocol.LOGIN, this.getVersion());
            return;
        }
        Callback<PreLoginEvent> callback = (result, error) -> {
            if (result.isCancelled()) {
                BaseComponent reason = result.getReason();
                this.disconnect(reason != null ? reason : this.bungee.getTranslationComponent("kick_message"));
                return;
            }
            if (this.ch.isClosing()) {
                return;
            }
            if (this.onlineMode) {
                this.thisState = State.ENCRYPT;
                this.antibotEncryptionLoginTask = () -> {
                    if (this.isInEventLoop()) {
                        this.connectToAntiBotFilter(name, antiBotCheckResult, false);
                        return;
                    }
                    this.ch.getHandle().eventLoop().execute(() -> {
                        if (!this.ch.isClosing()) {
                            this.connectToAntiBotFilter(name, antiBotCheckResult, false);
                        }
                    });
                };
                this.request = EncryptionUtil.encryptRequest();
                this.unsafe().sendPacket(this.request);
                return;
            }
            this.thisState = State.FINISHING;
            if (this.isInEventLoop()) {
                this.connectToAntiBotFilter(name, antiBotCheckResult, false);
                return;
            }
            this.ch.getHandle().eventLoop().execute(() -> {
                if (!this.ch.isClosing()) {
                    this.connectToAntiBotFilter(name, antiBotCheckResult, false);
                }
            });
        };
        this.bungee.getPluginManager().callEvent(new PreLoginEvent(this, callback));
    }

    public void connectToAntiBotFilter(String name, AntiBotCheckResult antiBotCheckResult, boolean kickAfterComplete) {
        this.offlineId = UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.getName()).getBytes(StandardCharsets.UTF_8));
        if (!ConfigSettings.IMP.ALWAYS_APPLY_OFFLINE_UUID) {
            if (this.uniqueId == null) {
                this.uniqueId = this.offlineId;
            }
        } else {
            this.uniqueId = this.offlineId;
        }
        this.rewriteId = this.bungee.config.isIpForward() ? this.uniqueId : this.offlineId;
        NullCordXImpl nullCordX = BungeeCord.getInstance().getNullCordX();
        int compressionThreshold = BungeeCord.getInstance().config.getCompressionThreshold();
        if (compressionThreshold >= 0) {
            nullCordX.getCachedPacketManager().getCachedSetCompression().writeAndFlushPacket(this.ch, this.getVersion());
            this.ch.setCompressionThreshold(compressionThreshold);
        }
        this.ch.write(new LoginSuccess(this.getRewriteId(), this.getName(), this.loginProfile == null ? null : this.loginProfile.getProperties()));
        if (this.getVersion() >= 764) {
            this.ch.setEncodeProtocol(Protocol.CONFIGURATION_FILTER);
        } else {
            this.ch.setEncodeProtocol(Protocol.GAME);
            this.ch.setDecodeProtocol(Protocol.FILTER);
        }
        VirtualConnector connector = new VirtualConnector(name, this, antiBotCheckResult, kickAfterComplete, nullCordX);
        if (nullCordX.getUserManager().addConnection(connector)) {
            nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(nullCordX.getLanguageManager().getDefaultLanguage()).sendKickPacket(KickType.ALREADY_CONNECTED, this.ch, this.ch.getEncodeProtocol(), this.getVersion());
            return;
        }
        ChannelPipeline pipeline = this.ch.getHandle().pipeline();
        ChannelStatisticsAndPacketLimiterUpstreamHandler csapluh = pipeline.get(ChannelStatisticsAndPacketLimiterUpstreamHandler.class);
        if (csapluh != null) {
            csapluh.setConnection(connector);
        }
        pipeline.get(HandlerBoss.class).setHandler(connector);
        PacketDecompressor packetDecompressor = pipeline.get(PacketDecompressor.class);
        if (packetDecompressor != null) {
            packetDecompressor.setChecking(true);
        }
        connector.spawn();
    }

    public void endLoginProcessForAntibot(VirtualConnector virtualConnector) {
        if (BungeeCord.getInstance().config.isEnforceSecureProfile() && this.getVersion() >= 760) {
            boolean secure = false;
            try {
                secure = EncryptionUtil.check(this.loginRequest.getPublicKey(), this.uniqueId);
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            if (!secure) {
                virtualConnector.disconnect((BaseComponent)this.bungee.getTranslationComponent("secure_profile_invalid"));
                return;
            }
        }
        UserConnection oldName = this.bungee.getUserConnection(this.getName());
        if (this.isOnlineMode()) {
            UserConnection oldID;
            if (oldName != null) {
                virtualConnector.disconnect((BaseComponent)this.bungee.getTranslationComponent("already_connected_proxy"));
            }
            if ((oldID = this.bungee.getUserConnection(this.getUniqueId())) != null) {
                virtualConnector.disconnect((BaseComponent)this.bungee.getTranslationComponent("already_connected_proxy"));
            }
        } else if (oldName != null) {
            virtualConnector.disconnect((BaseComponent)this.bungee.getTranslationComponent("already_connected_proxy"));
            return;
        }
        Callback<LoginEvent> complete = (result, error) -> {
            if (result.isCancelled()) {
                BaseComponent reason = result.getReason();
                virtualConnector.disconnect(reason != null ? reason : this.bungee.getTranslationComponent("kick_message"));
                return;
            }
            if (this.ch.isClosing()) {
                return;
            }
            if (this.isInEventLoop()) {
                this.connectToDefaultServerFromFilter(virtualConnector);
                return;
            }
            this.ch.getHandle().eventLoop().execute(() -> {
                if (!this.ch.isClosing()) {
                    this.connectToDefaultServerFromFilter(virtualConnector);
                }
            });
        };
        this.bungee.getPluginManager().callEvent(new LoginEvent(this, complete, this.getLoginProfile()));
    }

    private void connectToDefaultServerFromFilter(VirtualConnector virtualConnector) {
        this.userCon = new UserConnection(this.bungee, this.ch, this.getName(), this);
        ChannelStatisticsAndPacketLimiterUpstreamHandler csapluh = this.ch.getHandle().pipeline().get(ChannelStatisticsAndPacketLimiterUpstreamHandler.class);
        if (csapluh != null) {
            csapluh.setConnection(this.userCon);
            csapluh.setPacketLimit(new PacketLimit(ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_BYTES, ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_PACKET_BYTES_PER_SECOND, ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_PACKETS_PER_SECOND));
        }
        this.userCon.setCompressionThresholdValue(BungeeCord.getInstance().config.getCompressionThreshold());
        this.userCon.setFromVirtualConnector(true);
        this.userCon.setTabListFilterUserNameUUID(virtualConnector.getTabListUserNameUUID());
        if (!this.userCon.init()) {
            this.disconnect((BaseComponent)this.bungee.getTranslationComponent("already_connected_proxy"));
            return;
        }
        ClientSettings clientSettings = virtualConnector.getClientSettings();
        if (clientSettings != null) {
            this.userCon.setSettings(clientSettings);
            this.userCon.setCallSettingsEvent(true);
        }
        for (PluginMessage pm : virtualConnector.getPluginMessage()) {
            this.userCon.addDelayedPluginMessage(pm);
        }
        this.ch.setProtocol(Protocol.GAME);
        this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new UpstreamBridge(this.bungee, this.userCon));
        ServerInfo initialServer = this.bungee.getReconnectHandler() != null ? this.bungee.getReconnectHandler().getServer(this.userCon) : AbstractReconnectHandler.getForcedHost(this);
        if (initialServer == null) {
            initialServer = this.bungee.getServerInfo(this.listener.getDefaultServer());
        }
        Callback<PostLoginEvent> complete = (result, error) -> {
            if (this.ch.isClosing()) {
                return;
            }
            this.userCon.connect(result.getTarget(), null, true, ServerConnectEvent.Reason.JOIN_PROXY);
        };
        this.bungee.getPluginManager().callEvent(new PostLoginEvent(this.userCon, initialServer, complete));
    }

    private boolean isInEventLoop() {
        return this.ch.getHandle().eventLoop().inEventLoop();
    }

    public InitialHandler(BungeeCord bungee, ListenerInfo listener) {
        this.onlineMode = BungeeCord.getInstance().config.isOnlineMode();
        this.extraDataInHandshake = "";
        this.groups = new CaseInsensitiveSet();
        this.geyser = false;
        this.antibotEncryptionLoginTask = null;
        this.bungee = bungee;
        this.listener = listener;
    }

    public ChannelWrapper getCh() {
        return this.ch;
    }

    @Override
    public ListenerInfo getListener() {
        return this.listener;
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    public LoginRequest getLoginRequest() {
        return this.loginRequest;
    }

    public PluginMessage getBrandMessage() {
        return this.brandMessage;
    }

    public Set<String> getRegisteredChannels() {
        return this.registeredChannels;
    }

    @Override
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Override
    public InetSocketAddress getVirtualHost() {
        return this.virtualHost;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public UUID getOfflineId() {
        return this.offlineId;
    }

    public UUID getRewriteId() {
        return this.rewriteId;
    }

    public LoginResult getLoginProfile() {
        return this.loginProfile;
    }

    @Override
    public boolean isLegacy() {
        return this.legacy;
    }

    public String getExtraDataInHandshake() {
        return this.extraDataInHandshake;
    }

    @Override
    public boolean isTransferred() {
        return this.transferred;
    }

    public Collection<String> getGroups() {
        return this.groups;
    }

    private static enum State {
        HANDSHAKE,
        STATUS,
        PING,
        USERNAME,
        ENCRYPT,
        FINISHING;

    }

    public static class CookieFuture {
        private String cookie;
        private CompletableFuture<byte[]> future;

        public String getCookie() {
            return this.cookie;
        }

        public CompletableFuture<byte[]> getFuture() {
            return this.future;
        }

        public void setCookie(String cookie) {
            this.cookie = cookie;
        }

        public void setFuture(CompletableFuture<byte[]> future) {
            this.future = future;
        }

        public String toString() {
            return "InitialHandler.CookieFuture(cookie=" + this.getCookie() + ", future=" + this.getFuture() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CookieFuture)) {
                return false;
            }
            CookieFuture other = (CookieFuture)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cookie = this.getCookie();
            String other$cookie = other.getCookie();
            if (this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie)) {
                return false;
            }
            CompletableFuture<byte[]> this$future = this.getFuture();
            CompletableFuture<byte[]> other$future = other.getFuture();
            return !(this$future == null ? other$future != null : !this$future.equals(other$future));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CookieFuture;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cookie = this.getCookie();
            result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
            CompletableFuture<byte[]> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            return result;
        }

        public CookieFuture(String cookie, CompletableFuture<byte[]> future) {
            this.cookie = cookie;
            this.future = future;
        }
    }
}

