/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty.flush;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import net.md_5.bungee.netty.flush.BungeeFlushConsolidationHandler;

public final class FlushSignalingHandler
extends ChannelDuplexHandler {
    private BungeeFlushConsolidationHandler target;

    public FlushSignalingHandler(BungeeFlushConsolidationHandler target) {
        this.target = target;
    }

    public void setTarget(BungeeFlushConsolidationHandler target) {
        this.target.resetReadAndFlushIfNeeded(this.target.ctx);
        this.target = target;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.target.resetReadAndFlushIfNeeded(this.target.ctx);
        ctx.fireChannelReadComplete();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.target.readInProgress = true;
        ctx.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.target.resetReadAndFlushIfNeeded(this.target.ctx);
        ctx.fireExceptionCaught(cause);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.target.resetReadAndFlushIfNeeded(this.target.ctx);
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.target.resetReadAndFlushIfNeeded(this.target.ctx);
        ctx.close(promise);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.target.flushIfNeeded(this.target.ctx);
    }
}

