/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.github.waterfallmc.waterfall.log4j.WaterfallLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.util.ConnectionPendingHandler;
import net.md_5.bungee.util.Result;
import net.md_5.bungee.util.ResultData;
import net.shieldcommunity.nullcordx.LanguageManagerImpl;
import net.shieldcommunity.nullcordx.LocalScheduler;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXException;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.UserManagerImpl;
import net.shieldcommunity.nullcordx.antibot.AntiBotDirectConnection;
import net.shieldcommunity.nullcordx.antibot.AntiBotManagerImpl;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.antiproxy.AntiProxyManagerImpl;
import net.shieldcommunity.nullcordx.antibot.attributeslimiter.AntiBotAttributesLimiter;
import net.shieldcommunity.nullcordx.antibot.captcha.CaptchaGenerator;
import net.shieldcommunity.nullcordx.antibot.checklimiter.AntiBotCheckLimiter;
import net.shieldcommunity.nullcordx.antibot.maxmind.AntiASNManagerImpl;
import net.shieldcommunity.nullcordx.antibot.maxmind.AntiCountryManagerImpl;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.blacklist.BlacklistManager;
import net.shieldcommunity.nullcordx.cache.CachedCaptchaManagerImpl;
import net.shieldcommunity.nullcordx.cache.CachedMotdManager;
import net.shieldcommunity.nullcordx.cache.CachedPacketManagerImpl;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.config.MotdSettings;
import net.shieldcommunity.nullcordx.config.SQLSettings;
import net.shieldcommunity.nullcordx.config.bungee.BungeeCordSettings;
import net.shieldcommunity.nullcordx.config.bungee.WaterfallSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedPuzzleSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedHandCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.FramedCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.FramedPuzzleSettings;
import net.shieldcommunity.nullcordx.config.captcha.HandCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.PickCaptchaSettings;
import net.shieldcommunity.nullcordx.config.migration.ConfigMigration;
import net.shieldcommunity.nullcordx.database.DatabaseRepository;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Scheduler;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.modules.alert.PluginAlert;
import net.shieldcommunity.nullcordx.modules.find.PluginFind;
import net.shieldcommunity.nullcordx.modules.kick.PluginKick;
import net.shieldcommunity.nullcordx.modules.list.PluginList;
import net.shieldcommunity.nullcordx.modules.reconnect.JsonReconnectHandler;
import net.shieldcommunity.nullcordx.modules.reconnect.PluginReconnect;
import net.shieldcommunity.nullcordx.modules.reconnect.YamlReconnectHandler;
import net.shieldcommunity.nullcordx.modules.send.PluginSend;
import net.shieldcommunity.nullcordx.modules.server.PluginServer;
import net.shieldcommunity.nullcordx.natives.CompressionType;
import net.shieldcommunity.nullcordx.natives.Natives;
import net.shieldcommunity.nullcordx.protocol.ProtocolDimensionType;
import net.shieldcommunity.nullcordx.statistics.PlayerStatisticsUpdaterManager;
import net.shieldcommunity.nullcordx.statistics.StatisticsManagerImpl;
import net.shieldcommunity.nullcordx.tasks.ScheduledCounter;
import net.shieldcommunity.nullcordx.utils.CustomFJPThreadFactory;
import net.shieldcommunity.nullcordx.utils.DynamicDNS;
import net.shieldcommunity.nullcordx.utils.IOUtils;
import net.shieldcommunity.nullcordx.utils.InetAddressSet;
import net.shieldcommunity.nullcordx.utils.PlayerCountBoosterUtil;
import net.shieldcommunity.nullcordx.utils.SimpleUpdateChecker;

@Singleton
public class NullCordXImpl
implements NullCordX {
    public static final String PREFIX_SEP = "\u00a79\u00a7lNull\u00a7b\u00a7lCord\u00a7f\u00a7lX \u00a77\u00bb ";
    public static final Scheduler GLOBAL_CACHE_SCHEDULER = Scheduler.forScheduledExecutorService(Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setNameFormat("NullCordX-Cache-Scheduler-%d").build()));
    public static final Executor GLOBAL_CACHE_EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setNameFormat("NullCordX-Cache-Executor-%d").build());
    private static final ConnectionPendingHandler BUF_UTIL = new ConnectionPendingHandler();
    @Inject
    private NullCordXLogger logger;
    @Inject
    private LocalScheduler localScheduler;
    @Inject
    private LanguageManagerImpl languageManager;
    @Inject
    private DatabaseRepository databaseRepository;
    @Inject
    private UserManagerImpl userManager;
    @Inject
    private StatisticsManagerImpl statisticsManager;
    @Inject
    private PlayerStatisticsUpdaterManager playerStatisticsUpdaterManager;
    @Inject
    private CheckingFactoriesImpl checkingFactories;
    @Inject
    private BlacklistManager blacklistManager;
    @Inject
    private AntiBotCheckLimiter antiBotCheckLimiter;
    @Inject
    private AntiBotDirectConnection antiBotDirectConnection;
    @Inject
    private CachedPacketManagerImpl cachedPacketManager;
    @Inject
    private CachedMotdManager cachedMotdManager;
    @Inject
    private CachedCaptchaManagerImpl cachedCaptchaManager;
    @Inject
    private PlayerCountBoosterUtil playerCountBoosterUtil;
    @Inject
    private DynamicDNS dynamicDNS;
    @Inject
    private AntiBotManagerImpl antiBotManager;
    @Inject
    private AntiCountryManagerImpl antiCountryManager;
    @Inject
    private AntiASNManagerImpl antiASNManager;
    @Inject
    private AntiProxyManagerImpl antiProxyManager;
    @Inject
    private AntiBotAttributesLimiter antiBotAttributesLimiter;
    @Inject
    private CaptchaGenerator captchaGenerator;
    private ForkJoinPool loadingExecutor = null;
    private ProtocolDimensionType usedDimensionType = ProtocolDimensionType.OVERWORLD;
    private InetAddressSet geyserIpAddresses = new InetAddressSet();
    private volatile boolean forceBotAttack = false;
    private volatile boolean forceSpamAttack = false;
    private volatile boolean forcePingAttack = false;
    private volatile boolean customProtection = false;
    private boolean disabled = false;
    private boolean enabled = false;
    private final Map<String, Plugin> registeredModules = new HashMap<String, Plugin>();
    private final List<ManagerComponent> components = new ArrayList<ManagerComponent>();

    public void load(boolean startup) {
        if (this.disabled) {
            throw new NullCordXException("This NullCordX instance cannot be enabled after disable!");
        }
        if (this.enabled) {
            throw new NullCordXException("This NullCordX instance already is loaded!");
        }
        ConfigMigration.checkAndMigrate(this.logger, ConfigSettings.IMP);
        ConfigSettings.IMP.setLogger(this.logger);
        ConfigSettings.IMP.reload();
        ResultData resultData = BUF_UTIL.check();
        Result result = resultData.getResult();
        this.otherLogger();
        SimpleUpdateChecker.startCheckForUpdate(this.logger);
        CompressionType v4 = this.parseCompressionType(ConfigSettings.IMP.PERFORMANCE.COMPRESSION.NETWORK.TYPE.toUpperCase(Locale.ROOT));
        Natives.setupNetworkCompression(v4, this.logger);
        CompressionType cachedPacketCompressionType = this.parseCompressionType(ConfigSettings.IMP.PERFORMANCE.COMPRESSION.CACHED_PACKET.TYPE.toUpperCase(Locale.ROOT));
        Natives.setupCachedPacketCompression(cachedPacketCompressionType, this.logger);
        BungeeCordSettings.IMP.setLogger(this.logger);
        BungeeCordSettings.IMP.reload();
        WaterfallSettings.IMP.setLogger(this.logger);
        WaterfallSettings.IMP.reload();
        if (ConfigSettings.IMP.LOGS.SET_DEBUG_LEVEL) {
            WaterfallLogger.enableAllLevels();
        } else {
            WaterfallLogger.disableAllLevels();
        }
        ConfigMigration.checkAndMigrate(this.logger, AntibotSettings.IMP);
        AntibotSettings.IMP.setLogger(this.logger);
        AntibotSettings.IMP.reload();
        ConfigMigration.checkAndMigrate(this.logger, CaptchaSettings.IMP);
        CaptchaSettings.IMP.setLogger(this.logger);
        CaptchaSettings.IMP.reload();
        HandCaptchaSettings.IMP.setLogger(this.logger);
        HandCaptchaSettings.IMP.reload();
        AnimatedHandCaptchaSettings.IMP.setLogger(this.logger);
        AnimatedHandCaptchaSettings.IMP.reload();
        FramedCaptchaSettings.IMP.setLogger(this.logger);
        FramedCaptchaSettings.IMP.reload();
        AnimatedFramedCaptchaSettings.IMP.setLogger(this.logger);
        AnimatedFramedCaptchaSettings.IMP.reload();
        FramedPuzzleSettings.IMP.setLogger(this.logger);
        FramedPuzzleSettings.IMP.reload();
        AnimatedFramedPuzzleSettings.IMP.setLogger(this.logger);
        AnimatedFramedPuzzleSettings.IMP.reload();
        PickCaptchaSettings.IMP.setLogger(this.logger);
        PickCaptchaSettings.IMP.reload();
        SQLSettings.IMP.setLogger(this.logger);
        SQLSettings.IMP.reload();
        MotdSettings.IMP.setLogger(this.logger);
        MotdSettings.IMP.reload();
        this.registerModules(startup);
        ProtocolDimensionType dimension = ProtocolDimensionType.OVERWORLD;
        int dimensionType = AntibotSettings.IMP.ANTIBOT.DIMENSION.TYPE;
        if (dimensionType == 1) {
            dimension = ProtocolDimensionType.THE_NETHER;
        } else if (dimensionType == 2) {
            dimension = ProtocolDimensionType.THE_END;
        }
        this.usedDimensionType = dimension;
    }

    public void asyncLoad() {
        if (this.disabled) {
            throw new NullCordXException("This NullCordX instance cannot be enabled after disable!");
        }
        if (this.enabled) {
            throw new NullCordXException("This NullCordX instance already is loaded!");
        }
        long start = System.currentTimeMillis();
        this.geyserIpAddresses = ConfigSettings.IMP.GEYSER_DETECTION.GEYSER_STANDALONE_IPS.calculateAddresses(this.logger, "geyser standalone addresses");
        this.loadingExecutor = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new CustomFJPThreadFactory("NullCordX-Loading", 1), null, false);
        IOUtils.setNewCompressorThreadLocal(ConfigSettings.IMP.PERFORMANCE.COMPRESSION.CACHED_PACKET.LEVEL);
        this.disableConfiguredProtocols();
        ScheduledCounter.load(this.logger);
        this.components.add(this.localScheduler);
        this.components.add(this.languageManager);
        this.components.add(this.databaseRepository);
        this.components.add(this.userManager);
        this.components.add(this.statisticsManager);
        this.components.add(this.playerStatisticsUpdaterManager);
        this.components.add(this.checkingFactories);
        this.components.add(this.blacklistManager);
        this.components.add(this.antiBotCheckLimiter);
        this.components.add(this.antiBotDirectConnection);
        this.components.add(this.cachedPacketManager);
        this.components.add(this.cachedMotdManager);
        this.components.add(this.cachedCaptchaManager);
        this.components.add(this.playerCountBoosterUtil);
        this.components.add(this.dynamicDNS);
        this.components.add(this.antiBotManager);
        this.components.add(this.antiCountryManager);
        this.components.add(this.antiASNManager);
        this.components.add(this.antiProxyManager);
        this.components.add(this.antiBotAttributesLimiter);
        this.components.add(this.captchaGenerator);
        for (ManagerComponent component : this.components) {
            component.load(this.loadingExecutor);
        }
        long end = System.currentTimeMillis();
        this.logger.log(Level.INFO, "NullCordX successfully loaded in " + (end - start) + "ms!");
        this.enabled = true;
    }

    public void unload() {
        if (this.disabled) {
            return;
        }
        if (!this.enabled) {
            throw new NullCordXException("This NullCordX instance is not enabled!");
        }
        Collections.reverse(this.components);
        for (ManagerComponent component : this.components) {
            component.unload();
        }
        try {
            this.loadingExecutor.shutdown();
            this.loadingExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during shutdown loading executor", e);
        }
        this.loadingExecutor = null;
        for (Plugin plugin : this.registeredModules.values()) {
            BungeeCord.getInstance().getPluginManager().disablePlugin(plugin);
        }
        this.disabled = true;
    }

    private void registerModules(boolean startup) {
        if (ConfigSettings.IMP.MODULES.ENABLE_ALERT) {
            this.registerModule(new PluginAlert(BungeeCord.getInstance()));
        }
        if (ConfigSettings.IMP.MODULES.ENABLE_FIND) {
            this.registerModule(new PluginFind(BungeeCord.getInstance()));
        }
        if (ConfigSettings.IMP.MODULES.ENABLE_KICK) {
            this.registerModule(new PluginKick(BungeeCord.getInstance()));
        }
        if (ConfigSettings.IMP.MODULES.ENABLE_LIST) {
            this.registerModule(new PluginList(BungeeCord.getInstance()));
        }
        if (ConfigSettings.IMP.MODULES.RECONNECT.ENABLE) {
            AbstractReconnectHandler reconnectHandler = ConfigSettings.IMP.MODULES.RECONNECT.TYPE.equalsIgnoreCase("json") ? new JsonReconnectHandler() : new YamlReconnectHandler();
            this.registerModule(new PluginReconnect((ProxyServer)BungeeCord.getInstance(), reconnectHandler));
        }
        if (ConfigSettings.IMP.MODULES.ENABLE_SEND) {
            this.registerModule(new PluginSend(BungeeCord.getInstance()));
        }
        if (ConfigSettings.IMP.MODULES.ENABLE_SERVER) {
            this.registerModule(new PluginServer(BungeeCord.getInstance()));
        }
        for (Plugin plugin : this.registeredModules.values()) {
            BungeeCord.getInstance().getPluginManager().addAndEnablePlugin(plugin, !startup);
        }
    }

    private void registerModule(Plugin plugin) {
        this.registeredModules.put(plugin.getDescription().getName(), plugin);
    }

    @Override
    public Plugin getRegisteredModule(String name) {
        return this.registeredModules.get(name);
    }

    @Override
    public boolean isUnderBotAttack() {
        if (this.isForceBotAttack()) {
            return true;
        }
        return this.statisticsManager.getBotStatistics().isUnderAttack();
    }

    @Override
    public boolean isUnderPingAttack() {
        if (this.isForcePingAttack()) {
            return true;
        }
        return this.statisticsManager.getPingStatistics().isUnderAttack();
    }

    @Override
    public boolean isUnderSpamAttack() {
        if (this.isForceSpamAttack()) {
            return true;
        }
        return this.statisticsManager.getSpamStatistics().isUnderAttack();
    }

    @Override
    public boolean canSendDebugLog() {
        return ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG;
    }

    @Override
    public void sendDebugLog(String message) {
        this.logger.log(Level.INFO, "(Debug): " + message);
    }

    @Override
    public void sendDebugLogIfEnabled(String message) {
        if (this.canSendDebugLog()) {
            this.sendDebugLog(message);
        }
    }

    public boolean canSendAntibotLog() {
        if (!ConfigSettings.IMP.LOGS.ANTIBOT.ENABLED) {
            return false;
        }
        if (this.isUnderBotAttack() && ConfigSettings.IMP.LOGS.ANTIBOT.HIDE_ON_BOT_ATTACK) {
            return false;
        }
        return !this.isUnderSpamAttack() || !ConfigSettings.IMP.LOGS.ANTIBOT.HIDE_ON_SPAM_ATTACK;
    }

    public void sendAntibotLog(String message) {
        this.logger.log(Level.INFO, "(AntiBot): " + message);
    }

    public void sendAntibotLogIfEnabled(String message) {
        if (this.canSendAntibotLog()) {
            this.sendAntibotLog(message);
        }
    }

    public int computeTimeoutForInitConnection() {
        if (this.canChangeTimeoutForInitConnection()) {
            return ConfigSettings.IMP.PROTECTION.TIMEOUT_INIT_CONNECTION.TIMEOUT;
        }
        return BungeeCord.getInstance().config.getTimeout();
    }

    public boolean canChangeTimeoutForInitConnection() {
        int mode = ConfigSettings.IMP.PROTECTION.TIMEOUT_INIT_CONNECTION.MODE;
        return mode == 0 || mode == 1 && this.isUnderSpamAttack();
    }

    private void disableConfiguredProtocols() {
        List<Integer> original = ProtocolConstants.SUPPORTED_VERSION_IDS;
        ArrayList<Integer> current = new ArrayList<Integer>();
        HashSet<Integer> disabled = new HashSet<Integer>();
        for (String protocol : ConfigSettings.IMP.DISABLED_PROTOCOLS) {
            if (protocol == null || protocol.isEmpty()) continue;
            String[] splitRange = protocol.split("-");
            if (splitRange.length == 2) {
                int firstValue = Integer.parseInt(splitRange[0]);
                int secondValue = Integer.parseInt(splitRange[1]);
                for (int i = firstValue; i <= secondValue; ++i) {
                    disabled.add(i);
                }
                continue;
            }
            disabled.add(Integer.parseInt(protocol));
        }
        Iterator<Object> iterator = original.iterator();
        while (iterator.hasNext()) {
            int protocol = (Integer)iterator.next();
            if (disabled.contains(protocol)) continue;
            current.add(protocol);
        }
        ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED = Collections.unmodifiableList(current);
    }

    private void sendLogger(List<String> reason, Exception exception) {
        this.logger.log(Level.SEVERE, ChatColor.RED + "############## WARNING ##############");
        this.logger.log(Level.SEVERE, " ");
        this.logger.log(Level.SEVERE, ChatColor.RED + "Failed to validate license:");
        for (String r : reason) {
            this.logger.log(Level.SEVERE, ChatColor.RED + r);
        }
        if (exception != null) {
            this.logger.log(Level.SEVERE, ChatColor.RED + "Error message: " + exception.getClass().getSimpleName() + ": " + exception.getMessage());
            if (this.canSendDebugLog()) {
                this.logger.log(Level.SEVERE, "Error", exception);
            }
        }
        this.logger.log(Level.SEVERE, " ");
        this.logger.log(Level.SEVERE, ChatColor.RED + "-> Our discord:");
        this.logger.log(Level.SEVERE, ChatColor.RED + "https://discord.shieldcommunity.net");
        if (exception == null) {
            this.logger.log(Level.SEVERE, " ");
            this.logger.log(Level.SEVERE, ChatColor.RED + "The proxy won't start until you fix it.");
        }
        this.logger.log(Level.SEVERE, " ");
        this.logger.log(Level.SEVERE, ChatColor.RED + "############## WARNING ##############");
        this.logger.log(Level.SEVERE, " ");
    }

    private void otherLogger() {
        this.logger.log(Level.WARNING, ChatColor.GREEN + "Your license is valid. Fully enabling NullCordX now...");
        this.logger.log(Level.WARNING, " ");
    }

    private CompressionType parseCompressionType(String type) {
        try {
            return CompressionType.valueOf(type);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to parse compression type. Using libdeflate by default.");
            return CompressionType.LIBDEFLATE;
        }
    }

    @Override
    public NullCordXLogger getLogger() {
        return this.logger;
    }

    public LocalScheduler getLocalScheduler() {
        return this.localScheduler;
    }

    @Override
    public LanguageManagerImpl getLanguageManager() {
        return this.languageManager;
    }

    public DatabaseRepository getDatabaseRepository() {
        return this.databaseRepository;
    }

    @Override
    public UserManagerImpl getUserManager() {
        return this.userManager;
    }

    @Override
    public StatisticsManagerImpl getStatisticsManager() {
        return this.statisticsManager;
    }

    public PlayerStatisticsUpdaterManager getPlayerStatisticsUpdaterManager() {
        return this.playerStatisticsUpdaterManager;
    }

    @Override
    public CheckingFactoriesImpl getCheckingFactories() {
        return this.checkingFactories;
    }

    public BlacklistManager getBlacklistManager() {
        return this.blacklistManager;
    }

    public AntiBotCheckLimiter getAntiBotCheckLimiter() {
        return this.antiBotCheckLimiter;
    }

    public AntiBotDirectConnection getAntiBotDirectConnection() {
        return this.antiBotDirectConnection;
    }

    @Override
    public CachedPacketManagerImpl getCachedPacketManager() {
        return this.cachedPacketManager;
    }

    public CachedMotdManager getCachedMotdManager() {
        return this.cachedMotdManager;
    }

    @Override
    public CachedCaptchaManagerImpl getCachedCaptchaManager() {
        return this.cachedCaptchaManager;
    }

    public PlayerCountBoosterUtil getPlayerCountBoosterUtil() {
        return this.playerCountBoosterUtil;
    }

    public DynamicDNS getDynamicDNS() {
        return this.dynamicDNS;
    }

    @Override
    public AntiBotManagerImpl getAntiBotManager() {
        return this.antiBotManager;
    }

    @Override
    public AntiCountryManagerImpl getAntiCountryManager() {
        return this.antiCountryManager;
    }

    @Override
    public AntiASNManagerImpl getAntiASNManager() {
        return this.antiASNManager;
    }

    @Override
    public AntiProxyManagerImpl getAntiProxyManager() {
        return this.antiProxyManager;
    }

    public AntiBotAttributesLimiter getAntiBotAttributesLimiter() {
        return this.antiBotAttributesLimiter;
    }

    public CaptchaGenerator getCaptchaGenerator() {
        return this.captchaGenerator;
    }

    public ForkJoinPool getLoadingExecutor() {
        return this.loadingExecutor;
    }

    public ProtocolDimensionType getUsedDimensionType() {
        return this.usedDimensionType;
    }

    @Override
    public boolean isForceBotAttack() {
        return this.forceBotAttack;
    }

    @Override
    public boolean isForceSpamAttack() {
        return this.forceSpamAttack;
    }

    @Override
    public boolean isForcePingAttack() {
        return this.forcePingAttack;
    }

    @Override
    public boolean isCustomProtection() {
        return this.customProtection;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public static ConnectionPendingHandler getBUF_UTIL() {
        return BUF_UTIL;
    }

    public InetAddressSet getGeyserIpAddresses() {
        return this.geyserIpAddresses;
    }

    public void setForceBotAttack(boolean forceBotAttack) {
        this.forceBotAttack = forceBotAttack;
    }

    public void setForceSpamAttack(boolean forceSpamAttack) {
        this.forceSpamAttack = forceSpamAttack;
    }

    public void setForcePingAttack(boolean forcePingAttack) {
        this.forcePingAttack = forcePingAttack;
    }

    public void setCustomProtection(boolean customProtection) {
        this.customProtection = customProtection;
    }
}

