/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.antiproxy.services;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.antiproxy.services.AbstractLicenseAntiProxyService;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.ProxyResult;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.services.ProxyServiceCheckFailedException;
import net.shieldcommunity.nullcordx.utils.HttpUtils;
import org.apache.http.client.methods.HttpGet;

public class ProxyCheckProxyService
extends AbstractLicenseAntiProxyService {
    private static final String ENTRY_POINT = "https://proxycheck.io/v2/";
    private final int vpnType;
    private final int risk;

    public ProxyCheckProxyService(NullCordXImpl nullCordX, int timeout, String license, int vpnType, int risk) {
        super("ProxyCheck.io", nullCordX, timeout, license);
        this.vpnType = vpnType;
        this.risk = risk;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProxyResult checkProxy(InetAddress address) throws ProxyServiceCheckFailedException {
        String apiUrl = ENTRY_POINT + address.getHostAddress() + "?key=" + this.license + "&vpn=" + this.vpnType + "&risk=1";
        try {
            URI uri = URI.create(apiUrl);
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Accept-Encoding", "UTF-8");
            httpGet.setHeader("Content-Type", "application/json");
            try (HttpUtils.HttpByteArrayInputStream inputStream = HttpUtils.makeRequest(httpGet, this.timeout);){
                ProxyResult proxyResult;
                block26: {
                    JsonReader reader;
                    block24: {
                        ProxyResult proxyResult2;
                        block25: {
                            int riskResult;
                            JsonObject ipJson;
                            block22: {
                                ProxyResult proxyResult3;
                                block23: {
                                    int code = inputStream.getCode();
                                    if (code != 200) {
                                        throw new ProxyServiceCheckFailedException("Expected response code 200 (HTTP_OK) but received: " + code + ": '" + inputStream.getTextResponse() + "'");
                                    }
                                    reader = GSON.newJsonReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                                    try {
                                        JsonElement element = JsonParser.parseReader(reader);
                                        ipJson = ProxyCheckProxyService.getIpJson(address, element);
                                        JsonElement riskElement = ipJson.get("risk");
                                        riskResult = 0;
                                        if (riskElement != null) {
                                            riskResult = riskElement.getAsInt();
                                        }
                                        if (riskResult < this.risk) break block22;
                                        proxyResult3 = ProxyResult.DETECTED;
                                        if (reader == null) break block23;
                                    }
                                    catch (Throwable throwable) {
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    reader.close();
                                }
                                return proxyResult3;
                            }
                            String proxyResult4 = "no";
                            JsonElement proxyJsonElement = ipJson.get("proxy");
                            if (proxyJsonElement != null) {
                                proxyResult4 = proxyJsonElement.getAsString();
                            }
                            String vpnResult = "no";
                            JsonElement vpnJsonElement = ipJson.get("vpn");
                            if (vpnJsonElement != null) {
                                vpnResult = vpnJsonElement.getAsString();
                            }
                            if (!proxyResult4.equalsIgnoreCase("yes") && !vpnResult.equalsIgnoreCase("yes") || riskResult != 0) break block24;
                            proxyResult2 = ProxyResult.DETECTED;
                            if (reader == null) break block25;
                            reader.close();
                        }
                        return proxyResult2;
                    }
                    proxyResult = ProxyResult.ALLOWED;
                    if (reader == null) break block26;
                    reader.close();
                }
                return proxyResult;
            }
        }
        catch (Exception e) {
            throw new ProxyServiceCheckFailedException(e);
        }
    }

    private static JsonObject getIpJson(InetAddress address, JsonElement element) throws ProxyServiceCheckFailedException {
        JsonObject jsonObject = element.getAsJsonObject();
        JsonElement statusJson = jsonObject.get("status");
        String status = statusJson.getAsString();
        JsonElement messageElement = jsonObject.get("message");
        String message = null;
        if (messageElement != null) {
            message = messageElement.getAsString();
        }
        if (status.equalsIgnoreCase("denied")) {
            throw new ProxyServiceCheckFailedException("Rate limited: " + message);
        }
        if (status.equalsIgnoreCase("error")) {
            throw new ProxyServiceCheckFailedException("Error: " + message);
        }
        return jsonObject.get(address.getHostAddress()).getAsJsonObject();
    }

    @Override
    public void onLoad() {
    }

    @Override
    public void onUnload() {
    }
}

