/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.gifgenerator;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.BufferedGif;
import net.shieldcommunity.nullcordx.antibot.captcha.gifgenerator.GifGenerator;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedGif;
import net.shieldcommunity.nullcordx.config.captcha.GlowingCircle;
import net.shieldcommunity.nullcordx.config.captcha.ImageOffset;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class GlowingCircleGifGenerator
implements GifGenerator {
    private final List<ResizedGif> resizedGifs;
    private final GlowingCircle glowingCircle;
    private final ImageOffset imageOffset;
    private final List<RenderLayer> shadowBackgroundLayers;
    private final int framesCount;

    @Override
    public BufferedGif generate(BufferedImage sourceImage, int color, Random random, RenderSession renderSession) {
        int[] shadowRawImage;
        int animationYDirection;
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        BufferedGif gif = null;
        if (this.resizedGifs != null && !this.resizedGifs.isEmpty()) {
            ResizedGif randomResizedGif = this.resizedGifs.get(random.nextInt(this.resizedGifs.size()));
            gif = randomResizedGif.getStorage().getDataByRaCWithPixels(width, height);
        }
        int framesCount = gif != null ? gif.getFrames().size() : this.framesCount;
        double heightCenter = (double)height / 2.0;
        ArrayList<Circle> circles = new ArrayList<Circle>();
        if (this.glowingCircle.isMAIN_CIRCLE()) {
            double mainCircleStep = (double)width / (double)framesCount;
            double mainCircleOffsetX = 0.0;
            Location2D[] mainCirclePaths = new Location2D[framesCount];
            for (int i = 0; i < framesCount; ++i) {
                mainCirclePaths[i] = new Location2D(mainCircleOffsetX, heightCenter);
                mainCircleOffsetX += mainCircleStep;
            }
            circles.add(new Circle(heightCenter, mainCirclePaths));
        }
        for (int i = 0; i < this.glowingCircle.getSMALL_CIRCLES_COUNT(); ++i) {
            CubicCurve2D cubicCurve = GlowingCircleGifGenerator.createCubicCurve(random, width, height);
            double[] positions = new double[6];
            PathIterator pathIterator = cubicCurve.getPathIterator(null, 0.1);
            pathIterator.currentSegment(positions);
            Point2D.Double prev = new Point2D.Double(positions[0], positions[1]);
            pathIterator.next();
            Location2D[] paths = new Location2D[framesCount];
            for (int j = 0; j < framesCount; ++j) {
                if (pathIterator.isDone()) {
                    paths[j] = new Location2D((int)prev.x, (int)prev.y);
                    continue;
                }
                Point2D.Double point = new Point2D.Double(positions[0], positions[1]);
                int currentSegment = pathIterator.currentSegment(positions);
                if (currentSegment != 0 && currentSegment != 1) {
                    paths[j] = new Location2D((int)prev.x, (int)prev.y);
                    continue;
                }
                paths[j] = new Location2D((int)point.x, (int)point.y);
                prev = point;
                pathIterator.next();
            }
            double randomSize = heightCenter / (random.nextBoolean() ? 2.0 : 3.0);
            circles.add(new Circle(randomSize, paths));
        }
        boolean reverse = random.nextBoolean();
        ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
        int animationXOffset = 0;
        int animationYOffset = 0;
        int animationIter = 1;
        int animationXDirection = random.nextBoolean() ? this.imageOffset.getANIMATION_X_MULTIPLICATION() : -this.imageOffset.getANIMATION_X_MULTIPLICATION();
        int n = animationYDirection = random.nextBoolean() ? this.imageOffset.getANIMATION_Y_MULTIPLICATION() : -this.imageOffset.getANIMATION_Y_MULTIPLICATION();
        if (this.shadowBackgroundLayers != null) {
            BufferedImage captchaBufferedImage = RenderLayer.renderCurrentLayers(new BufferedImage(width, height, sourceImage.getType()), this.shadowBackgroundLayers, new Color(color), random, renderSession);
            shadowRawImage = ((DataBufferInt)captchaBufferedImage.getRaster().getDataBuffer()).getData();
        } else {
            int[] solidColor = new int[width * height];
            Arrays.fill(solidColor, color);
            shadowRawImage = solidColor;
        }
        int degrees2 = 0;
        for (int i = 0; i < framesCount; ++i) {
            BufferedImage newFrame;
            if (gif != null) {
                BufferedImage background = ImageUtils.copyImage(gif.getFrames().get(i));
                Graphics2D g2d = background.createGraphics();
                g2d.drawImage((Image)sourceImage, 0, 0, null);
                g2d.dispose();
                newFrame = background;
            } else {
                newFrame = ImageUtils.copyImage(sourceImage);
            }
            int degreesChange = this.glowingCircle.getRANDOM_ROTATION_DEGREES();
            if (degreesChange != 0) {
                newFrame = ImageUtils.rotateImageByDegrees(newFrame, degrees2);
                degrees2 = random.nextBoolean() ? degrees2 + degreesChange : degrees2 - degreesChange;
            }
            int[] destArray = ((DataBufferInt)newFrame.getRaster().getDataBuffer()).getData();
            if (this.imageOffset.isENABLED()) {
                int[] copy = Arrays.copyOf(destArray, destArray.length);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        int yOffset;
                        int xOffset = animationXOffset + x;
                        if (xOffset < 0) {
                            int value = Math.abs(xOffset);
                            xOffset = value < width ? width - value : value - width;
                        }
                        if ((yOffset = animationYOffset + y) < 0) {
                            int value = Math.abs(yOffset);
                            yOffset = value < height ? height - value : value - height;
                        }
                        int localX = xOffset % width;
                        int localY = yOffset % height;
                        destArray[localY * width + localX] = copy[y * width + x];
                    }
                }
                if (animationIter >= this.imageOffset.getANIMATION_ITERATION_CHANGE()) {
                    animationIter = 1;
                    animationXDirection = random.nextBoolean() ? this.imageOffset.getANIMATION_X_MULTIPLICATION() : -this.imageOffset.getANIMATION_X_MULTIPLICATION();
                    animationYDirection = random.nextBoolean() ? this.imageOffset.getANIMATION_Y_MULTIPLICATION() : -this.imageOffset.getANIMATION_Y_MULTIPLICATION();
                } else {
                    ++animationIter;
                }
                animationXOffset += animationXDirection;
                animationYOffset += animationYDirection;
            }
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    boolean canSetPixel = true;
                    for (Circle circle : circles) {
                        Location2D[] location2DArray = circle.getPaths();
                        int n2 = reverse ? framesCount - 1 - i : i;
                        if (!(location2DArray[n2].getDistanceBetweenLocation(x, y) <= circle.getRadius())) continue;
                        canSetPixel = false;
                        break;
                    }
                    if (!canSetPixel) continue;
                    destArray[y * width + x] = shadowRawImage[y * width + x];
                }
            }
            frames.add(newFrame);
        }
        return new BufferedGif(frames);
    }

    private static CubicCurve2D createCubicCurve(Random random, int width, int height) {
        CubicCurve2D.Double cubicCurve = random.nextBoolean() ? new CubicCurve2D.Double(random.nextDouble() * (double)width, random.nextDouble() * 0.1 * (double)height, random.nextDouble() * (double)width, random.nextDouble() * (double)height, random.nextDouble() * (double)width, random.nextDouble() * (double)height, random.nextDouble() * (double)width, (0.8 + 0.1 * random.nextDouble()) * (double)height) : new CubicCurve2D.Double(random.nextDouble() * 0.1 * (double)width, random.nextDouble() * (double)height, random.nextDouble() * (double)width, random.nextDouble() * (double)height, random.nextDouble() * (double)width, random.nextDouble() * (double)height, (0.8 + 0.1 * random.nextDouble()) * (double)width, random.nextDouble() * (double)height);
        return cubicCurve;
    }

    public GlowingCircleGifGenerator(List<ResizedGif> resizedGifs, GlowingCircle glowingCircle, ImageOffset imageOffset, List<RenderLayer> shadowBackgroundLayers, int framesCount) {
        this.resizedGifs = resizedGifs;
        this.glowingCircle = glowingCircle;
        this.imageOffset = imageOffset;
        this.shadowBackgroundLayers = shadowBackgroundLayers;
        this.framesCount = framesCount;
    }

    private static class Location2D {
        private double x;
        private double y;

        public double getDistanceBetweenLocation(double x, double y) {
            double aVec = Math.pow(this.x - x, 2.0);
            double bVec = Math.pow(this.y - y, 2.0);
            return Math.sqrt(aVec + bVec);
        }

        public double getDistanceBetweenLocation(Location2D location2D) {
            return this.getDistanceBetweenLocation(location2D.getX(), location2D.getY());
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setX(double x) {
            this.x = x;
        }

        public void setY(double y) {
            this.y = y;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Location2D)) {
                return false;
            }
            Location2D other = (Location2D)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getX(), other.getX()) != 0) {
                return false;
            }
            return Double.compare(this.getY(), other.getY()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Location2D;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $x = Double.doubleToLongBits(this.getX());
            result = result * 59 + (int)($x >>> 32 ^ $x);
            long $y = Double.doubleToLongBits(this.getY());
            result = result * 59 + (int)($y >>> 32 ^ $y);
            return result;
        }

        public String toString() {
            return "GlowingCircleGifGenerator.Location2D(x=" + this.getX() + ", y=" + this.getY() + ")";
        }

        public Location2D(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class Circle {
        private final double radius;
        private final Location2D[] paths;

        public Circle(double radius, Location2D[] paths) {
            this.radius = radius;
            this.paths = paths;
        }

        public double getRadius() {
            return this.radius;
        }

        public Location2D[] getPaths() {
            return this.paths;
        }
    }
}

