/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class RenderLayerChance
extends AbstractRenderLayer {
    private final RenderLayer renderLayer;
    private final double chance;
    private boolean lazyLoaded = false;

    public RenderLayerChance(String name, RenderLayer renderLayer, double chance) {
        super(name);
        this.renderLayer = renderLayer;
        this.chance = chance;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        if (RenderLayerChance.canDraw(this.chance, random)) {
            int width = image.getWidth();
            int height = image.getHeight();
            BufferedImage renderedImage = this.renderLayer.drawLayer(new BufferedImage(width, height, image.getType()), color, random, renderSession);
            int[] destArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            int[] srcArray = ((DataBufferInt)renderedImage.getRaster().getDataBuffer()).getData();
            ImageUtils.drawRawNewImageToOld(width, height, destArray, srcArray, false);
        }
        return image;
    }

    @Override
    public void lazyLoad(ForkJoinPool executor) {
        if (this.lazyLoaded) {
            return;
        }
        if (this.renderLayer == null) {
            return;
        }
        this.renderLayer.lazyLoad(executor);
        this.lazyLoaded = true;
    }

    private static boolean canDraw(double chance, Random random) {
        if (chance >= 1.0) {
            return true;
        }
        return chance > random.nextDouble();
    }

    public String toString() {
        return "RenderLayerChance(chance=" + this.chance + ")";
    }
}

