/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.ImageCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ImageResizeTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedImage;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.config.FilePaths;
import net.shieldcommunity.nullcordx.libs.imgscalr.Scalr;
import net.shieldcommunity.nullcordx.utils.CustomFJPThreadFactory;
import net.shieldcommunity.nullcordx.utils.ImageUtils;
import net.shieldcommunity.nullcordx.utils.TasksUtils;

public class RenderLayerImage
extends AbstractRenderLayer {
    private final Logger logger;
    private final boolean ignoreTransparent;
    private final FilePaths imagePaths;
    private final Set<String> globalImageHashes;
    private final ImageCacheType imageCacheType;
    private final Scalr.Method resizeMethod;
    private final File cacheDirectory;
    private final CheckingFactoriesImpl checkingFactories;
    private List<ResizedImage> images;
    private boolean lazyLoaded = false;

    public RenderLayerImage(String name, Logger logger, boolean ignoreTransparent, FilePaths imagePaths, Set<String> globalImageHashes, ImageCacheType imageCacheType, Scalr.Method resizeMethod, File cacheDirectory, CheckingFactoriesImpl checkingFactories) {
        super(name);
        this.logger = logger;
        this.ignoreTransparent = ignoreTransparent;
        this.imagePaths = imagePaths;
        this.globalImageHashes = globalImageHashes;
        this.imageCacheType = imageCacheType;
        this.resizeMethod = resizeMethod;
        this.cacheDirectory = cacheDirectory;
        this.checkingFactories = checkingFactories;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        if (this.images == null) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        ResizedImage randomResizedImage = this.images.get(random.nextInt(this.images.size()));
        BufferedImage randomImage = randomResizedImage.getStorage().getDataByRaCWithPixels(width, height);
        int[] destArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] srcArray = ((DataBufferInt)randomImage.getRaster().getDataBuffer()).getData();
        ImageUtils.drawRawNewImageToOld(width, height, destArray, srcArray, this.ignoreTransparent);
        return image;
    }

    @Override
    public void lazyLoad(ForkJoinPool executor) {
        if (this.lazyLoaded) {
            return;
        }
        List<ResizedImage> images = this.loadImages();
        if (images != null && !images.isEmpty()) {
            for (ResizedImage image : images) {
                this.globalImageHashes.add(image.getChecksum());
            }
            this.images = images;
        }
        this.lazyLoaded = true;
    }

    private List<ResizedImage> loadImages() {
        List<Object> files = new ArrayList();
        if (this.imagePaths != null) {
            files = this.imagePaths.calculateExistsFiles(this.logger, "images");
        }
        if (files.isEmpty()) {
            return null;
        }
        int threads = CaptchaSettings.IMP.CAPTCHA.THREADS_FOR_GENERATION;
        if (threads < 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        ForkJoinPool executor = new ForkJoinPool(threads, new CustomFJPThreadFactory("RenderLayerImageLoader", 1), null, false);
        ArrayList<ImageResizeTask> tasks = new ArrayList<ImageResizeTask>();
        for (File file : files) {
            tasks.add(new ImageResizeTask(this.logger, executor, null, this.cacheDirectory, this.checkingFactories.getMinFrameRow(), this.checkingFactories.getMaxFrameRow(), this.checkingFactories.getMinFrameColumn(), this.checkingFactories.getMaxFrameColumn(), this.imageCacheType, this.resizeMethod, file));
        }
        return TasksUtils.executeSimpleTasks(executor, this.logger, tasks, (logger, dataToGenerate, perSec) -> logger.log(Level.INFO, "Loading images for image layer [" + dataToGenerate + "/+" + perSec + " ips]"));
    }

    public String toString() {
        return "RenderLayerImage(ignoreTransparent=" + this.ignoreTransparent + ", imagePaths=" + this.imagePaths + ", globalImageHashes=" + this.globalImageHashes + ", imageCacheType=" + this.imageCacheType + ", resizeMethod=" + this.resizeMethod + ", cacheDirectory=" + this.cacheDirectory + ")";
    }
}

