/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.settings;

import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.GenerationStateWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.imagesource.ApiNinjasImageSource;
import net.shieldcommunity.nullcordx.antibot.captcha.imagesource.ImageDataSource;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapPalette;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.GroupedLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerAnswer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerChance;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerColorize;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerCopy;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerCurve;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerDithering;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerGradient;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerGroups;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerImage;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerMirror;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerNoise;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerPaste;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerRandom;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerRipple;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerRotation;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerSplitter;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayerTransparent;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.ArithmeticAnswerFactory;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.CodeAnswerFactory;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.FontCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.GifCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.ImageCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.NumberSpellingFactory;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.data.AnimatedFramedCaptchaData;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.data.AnimatedFramedPuzzleData;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.data.AnimatedHandCaptchaData;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.data.FramedCaptchaData;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.data.FramedPuzzleData;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.data.HandCaptchaData;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.data.PickCaptchaData;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.CacheCleanupUtils;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CombinedCaptchaFileCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.GifResizeTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.GroupedImage;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.GroupedImageResizeTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedGif;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedImage;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.config.FilePaths;
import net.shieldcommunity.nullcordx.config.captcha.PickCaptchaSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.libs.imgscalr.Scalr;
import net.shieldcommunity.nullcordx.utils.CustomFJPThreadFactory;
import net.shieldcommunity.nullcordx.utils.TasksUtils;

@Singleton
public class CaptchaDataSettings
extends ManagerComponent {
    public static final File IMAGES_CACHE_DIRECTORY = new File("NullCordX", "cache" + File.separator + "images");
    public static final File GIFS_CACHE_DIRECTORY = new File("NullCordX", "cache" + File.separator + "gifs");
    public static final File FONTS_CACHE_DIRECTORY = new File("NullCordX", "cache" + File.separator + "fonts");
    public static final File PICK_CAPTCHA_IMAGES_CACHE_DIRECTORY = new File(IMAGES_CACHE_DIRECTORY, "pick_captcha");
    public static final File GLOBAL_IMAGES_CACHE_DIRECTORY = new File(IMAGES_CACHE_DIRECTORY, "global");
    public static final File GLOBAL_GIFS_CACHE_DIRECTORY = new File(GIFS_CACHE_DIRECTORY, "global");
    public static final File GLOBAL_CAPTCHA_CACHE_DIRECTORY = new File("NullCordX", "cache" + File.separator + "captcha");
    private final CheckingFactoriesImpl checkingFactories;
    private final List<Color> colors = new ArrayList<Color>();
    private final HandCaptchaData handCaptchaData = new HandCaptchaData();
    private final AnimatedHandCaptchaData animatedHandCaptchaData = new AnimatedHandCaptchaData();
    private final FramedCaptchaData framedCaptchaData = new FramedCaptchaData();
    private final AnimatedFramedCaptchaData animatedFramedCaptchaData = new AnimatedFramedCaptchaData();
    private final FramedPuzzleData framedPuzzleData = new FramedPuzzleData();
    private final AnimatedFramedPuzzleData animatedFramedPuzzleData = new AnimatedFramedPuzzleData();
    private final PickCaptchaData pickCaptchaData = new PickCaptchaData();
    private CombinedCaptchaFileCacheType captchaFileCacheType = CombinedCaptchaFileCacheType.BINZ;
    private ImageCacheType imageCacheType = ImageCacheType.BIN;
    private GifCacheType gifCacheType = GifCacheType.BIN;
    private FontCacheType fontCacheType = FontCacheType.BINZ;
    private Scalr.Method resizeMethod = Scalr.Method.QUALITY;
    private final List<ImageDataSource> imageDataSources = new ArrayList<ImageDataSource>();
    private Map<String, GroupedImage> forPickCaptchaGroupedImages = null;

    @Inject
    public CaptchaDataSettings(NullCordXLogger logger, NullCordXImpl nullCordX, CheckingFactoriesImpl checkingFactories) {
        super(logger, nullCordX, "CaptchaDataSettings");
        this.checkingFactories = checkingFactories;
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        block20: {
            Scalr.Method resizeMethod;
            FontCacheType fontCacheType;
            GifCacheType gifCacheType;
            ImageCacheType imageCacheType;
            CombinedCaptchaFileCacheType captchaFileCacheType;
            try {
                captchaFileCacheType = CombinedCaptchaFileCacheType.valueOf(CaptchaSettings.IMP.CAPTCHA.CAPTCHA_CACHE_TYPE.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to load captcha cache type. Using default binz format.");
                captchaFileCacheType = CombinedCaptchaFileCacheType.BINZ;
            }
            this.captchaFileCacheType = captchaFileCacheType;
            try {
                imageCacheType = ImageCacheType.valueOf(CaptchaSettings.IMP.CAPTCHA.IMAGES_CACHE_TYPE.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to load image cache type. Using default bin format.");
                imageCacheType = ImageCacheType.BIN;
            }
            this.imageCacheType = imageCacheType;
            try {
                gifCacheType = GifCacheType.valueOf(CaptchaSettings.IMP.CAPTCHA.GIFS_CACHE_TYPE.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to load gif cache type. Using default binz format.");
                gifCacheType = GifCacheType.BINZ;
            }
            this.gifCacheType = gifCacheType;
            try {
                fontCacheType = FontCacheType.valueOf(CaptchaSettings.IMP.CAPTCHA.FONTS_CACHE_TYPE.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to load font cache type. Using default binz format.");
                fontCacheType = FontCacheType.BINZ;
            }
            this.fontCacheType = fontCacheType;
            try {
                resizeMethod = Scalr.Method.valueOf(CaptchaSettings.IMP.CAPTCHA.IMAGE_RESIZE_MODE.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to load image resize mode. Using default quality mode.");
                resizeMethod = Scalr.Method.QUALITY;
            }
            this.resizeMethod = resizeMethod;
            PickCaptchaSettings.PICK_CAPTCHA.IMAGE_SOURCES.SERVICES.API_NINJAS apiNinjas = PickCaptchaSettings.IMP.PICK_CAPTCHA.IMAGE_SOURCES.SERVICES.API_NINJAS;
            if (apiNinjas.ENABLED) {
                this.imageDataSources.add(new ApiNinjasImageSource(apiNinjas.LICENSE, apiNinjas.TIMEOUT, PickCaptchaSettings.IMP.PICK_CAPTCHA.IMAGE_SOURCES.MAX_CACHE_TIME, apiNinjas.GROUPS, apiNinjas.IMAGES_PER_GROUP));
            }
            for (String hexColor : CaptchaSettings.IMP.CAPTCHA.COLORS) {
                Color color = Color.decode(hexColor);
                this.colors.add(color);
            }
            this.nullCordX.sendDebugLogIfEnabled("Using " + this.colors.size() + " colors for captcha");
            try {
                File file = new File("NullCordX", "captcha_background.jpg");
                if (file.exists()) break block20;
                try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("captcha_background.jpg");){
                    Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to load default captcha_background image", e);
            }
        }
        HashSet<String> globalImagesHashes = new HashSet<String>();
        Map<String, RenderLayer> renderLayerTemplates = Collections.unmodifiableMap(this.createRenderLayersTemplates(globalImagesHashes, executor));
        this.handCaptchaData.load(this.checkingFactories, this, renderLayerTemplates, executor, this.nullCordX);
        this.animatedHandCaptchaData.load(this.checkingFactories, this, renderLayerTemplates, executor, this.nullCordX);
        this.framedCaptchaData.load(this.checkingFactories, this, renderLayerTemplates, executor, this.nullCordX);
        this.animatedFramedCaptchaData.load(this.checkingFactories, this, renderLayerTemplates, executor, this.nullCordX);
        this.framedPuzzleData.load(this.checkingFactories, this, renderLayerTemplates, executor, this.nullCordX);
        this.animatedFramedPuzzleData.load(this.checkingFactories, this, renderLayerTemplates, executor, this.nullCordX);
        this.pickCaptchaData.load(this.checkingFactories, this, renderLayerTemplates, executor, this.nullCordX);
        CacheCleanupUtils.doCleanup(this.logger, GLOBAL_IMAGES_CACHE_DIRECTORY, globalImagesHashes, (logger, count) -> logger.log(Level.INFO, "Deleted " + count + " outdated cached image files."));
        Set<String> globalFontsHashes = CaptchaDataSettings.getGlobalFontsHashes(renderLayerTemplates);
        CacheCleanupUtils.doCleanup(this.logger, FONTS_CACHE_DIRECTORY, globalFontsHashes, (logger, count) -> logger.log(Level.INFO, "Deleted " + count + " outdated cached font files."));
    }

    private static Set<String> getGlobalFontsHashes(Map<String, RenderLayer> renderLayerTemplates) {
        HashSet<String> globalFontsHashes = new HashSet<String>();
        for (RenderLayer renderLayer : renderLayerTemplates.values()) {
            PerRaCStorage<FontListData> perRaCStorage;
            RenderLayerAnswer renderLayerAnswer;
            AbstractCaptchaAnswerGenerator answerGenerator;
            if (!(renderLayer instanceof RenderLayerAnswer) || (answerGenerator = (renderLayerAnswer = (RenderLayerAnswer)renderLayer).getAnswerGenerator()) == null || (perRaCStorage = answerGenerator.getFonts()) == null) continue;
            for (FontListData fontListData : perRaCStorage.getAllData()) {
                globalFontsHashes.add(fontListData.getFileName());
            }
        }
        return globalFontsHashes;
    }

    @Override
    protected void onUnload() {
    }

    public void loadGroupedImages(GenerationStateWrapper generationStateWrapper) {
        int threads;
        File pickCaptchaGroupsPath = new File("NullCordX", PickCaptchaSettings.IMP.PICK_CAPTCHA.IMAGES_GROUPS_PATH);
        if (!pickCaptchaGroupsPath.exists() || !pickCaptchaGroupsPath.isDirectory()) {
            this.logger.log(Level.SEVERE, "Could not find directory '" + pickCaptchaGroupsPath.toPath() + "'");
            return;
        }
        this.downloadImageSources(pickCaptchaGroupsPath);
        this.logger.log(Level.INFO, "Start scanning images for all groups...");
        int minRows = 1;
        int maxRows = PickCaptchaSettings.IMP.PICK_CAPTCHA.MAX_IMAGE_ROW;
        int minColumns = 1;
        int maxColumns = PickCaptchaSettings.IMP.PICK_CAPTCHA.MAX_IMAGE_COLUMN;
        long startGlobal = System.currentTimeMillis();
        ArrayList<GroupedImageResizeTask> tasks = new ArrayList<GroupedImageResizeTask>();
        if (!PICK_CAPTCHA_IMAGES_CACHE_DIRECTORY.exists()) {
            PICK_CAPTCHA_IMAGES_CACHE_DIRECTORY.mkdirs();
        }
        if ((threads = CaptchaSettings.IMP.CAPTCHA.THREADS_FOR_GENERATION) < 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        ForkJoinPool executor = new ForkJoinPool(threads, new CustomFJPThreadFactory("ImageLoaderAndResizer", 1), null, false);
        File[] groupPaths = pickCaptchaGroupsPath.listFiles();
        if (groupPaths != null && groupPaths.length > 0) {
            this.logger.log(Level.INFO, "Found " + groupPaths.length + " potential groups.");
            for (File groupPath : groupPaths) {
                if (!groupPath.isDirectory()) continue;
                tasks.add(new GroupedImageResizeTask(this.logger, executor, generationStateWrapper, groupPath, PICK_CAPTCHA_IMAGES_CACHE_DIRECTORY, minRows, maxRows, minColumns, maxColumns, this.imageCacheType, this.resizeMethod));
            }
        }
        List<Object> result = TasksUtils.executeSimpleTasks(executor, this.logger, tasks, (logger, dataToGenerate, perSec) -> logger.log(Level.INFO, "Async image loader and resizer [" + dataToGenerate + "/+" + perSec + " ips]"));
        HashMap<String, GroupedImage> groupedImages = new HashMap<String, GroupedImage>();
        for (Object groupedImage : result) {
            groupedImages.put(((GroupedImage)groupedImage).getName(), (GroupedImage)groupedImage);
        }
        HashSet<String> currentHashes = new HashSet<String>();
        for (GroupedImage groupedImage : groupedImages.values()) {
            Set<ResizedImage> resizedImages = groupedImage.getImages();
            for (ResizedImage resizedImage : resizedImages) {
                currentHashes.add(resizedImage.getChecksum());
            }
        }
        CacheCleanupUtils.doCleanup(this.logger, PICK_CAPTCHA_IMAGES_CACHE_DIRECTORY, currentHashes, (logger, count) -> logger.log(Level.INFO, "Deleted " + count + " outdated cached pick captcha image files."));
        this.forPickCaptchaGroupedImages = Collections.unmodifiableMap(groupedImages);
        long endGlobal = System.currentTimeMillis();
        this.logger.log(Level.INFO, "Images groups successfully loaded in " + (endGlobal - startGlobal) + "ms");
    }

    public void unloadGroupedImages() {
        this.forPickCaptchaGroupedImages = null;
    }

    private void downloadImageSources(File pickCaptchaGroupsPath) {
        if (this.imageDataSources.isEmpty()) {
            return;
        }
        int imageWidth = 128 * PickCaptchaSettings.IMP.PICK_CAPTCHA.MAX_IMAGE_ROW;
        int imageHeight = 128 * PickCaptchaSettings.IMP.PICK_CAPTCHA.MAX_IMAGE_COLUMN;
        this.logger.log(Level.INFO, "Starting downloading image sources...");
        long start = System.currentTimeMillis();
        for (ImageDataSource imageDataSource : this.imageDataSources) {
            int maxImages = imageDataSource.getImagesCount();
            for (String groupName : imageDataSource.getGroups()) {
                ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(PickCaptchaSettings.IMP.PICK_CAPTCHA.IMAGE_SOURCES.THREAD_POOL);
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                int imagesToGenerateCount = imageDataSource.getImagesCount();
                File groupFile = new File(pickCaptchaGroupsPath, groupName);
                if (!groupFile.exists()) {
                    groupFile.mkdirs();
                }
                int i = 1;
                while (i <= maxImages) {
                    int finalI = i++;
                    tasks.add(() -> {
                        try {
                            imageDataSource.downloadAndSaveImage(groupFile, groupName, String.valueOf(finalI), imageWidth, imageHeight);
                        }
                        catch (IllegalStateException e) {
                            executor.shutdownNow();
                            this.logger.log(Level.SEVERE, "Failed to download image", e);
                        }
                        catch (Exception e) {
                            this.logger.log(Level.SEVERE, "Failed to download image", e);
                        }
                    });
                }
                ArrayList future = new ArrayList();
                for (Runnable task : tasks) {
                    future.add(executor.submit(task));
                }
                long time = System.currentTimeMillis();
                long oldImagesCount = 0L;
                while (executor.getActiveCount() != 0) {
                    if (System.currentTimeMillis() - time >= 1000L) {
                        time = System.currentTimeMillis();
                        long waitTasksCount = TasksUtils.findWaitTasksCount(future);
                        long currentCount = (long)imagesToGenerateCount - waitTasksCount;
                        long perSec = currentCount - oldImagesCount;
                        oldImagesCount = currentCount;
                        if (!CaptchaSettings.IMP.CAPTCHA.AUTO_REGENERATE_HIDE_MESSAGES) {
                            this.logger.log(Level.INFO, "Async downloading images from '" + imageDataSource.getName() + "' for group '" + groupName + "' [" + ((long)imagesToGenerateCount - waitTasksCount) + "/" + imagesToGenerateCount + "/+" + perSec + " ips]");
                        }
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.logger.log(Level.WARNING, "Failed to download images", e);
                        return;
                    }
                }
                try {
                    executor.shutdown();
                    executor.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Error during executor shutdown", e);
                }
            }
        }
        long end = System.currentTimeMillis();
        this.logger.log(Level.INFO, "Image sources downloaded in " + (end - start) + "ms");
    }

    private Map<String, RenderLayer> createRenderLayersTemplates(Set<String> globalImagesHashes, ForkJoinPool executor) {
        List<RenderLayer> renderLayers;
        Object renderLayer;
        RenderLayer layer;
        AbstractRenderLayer renderLayer2;
        Object data;
        HashMap<String, RenderLayer> renderLayerTemplates = new HashMap<String, RenderLayer>();
        Color[] colors = MapPalette.createColorsWithoutTransparentFor_1_17();
        int[] rgbColors = new int[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            rgbColors[i] = colors[i].getRGB();
        }
        RenderLayerDithering renderLayerDithering = new RenderLayerDithering("dithering", rgbColors);
        renderLayerTemplates.put("dithering", renderLayerDithering);
        for (Map.Entry<String, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.IMAGE_LAYER_TEMPLATE> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.IMAGE_LAYER_TEMPLATES.entrySet()) {
            data = entry.getValue();
            RenderLayerImage renderLayer22 = new RenderLayerImage(entry.getKey(), this.logger, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.IMAGE_LAYER_TEMPLATE)data).IGNORE_TRANSPARENT, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.IMAGE_LAYER_TEMPLATE)data).IMAGES, globalImagesHashes, this.imageCacheType, this.resizeMethod, GLOBAL_IMAGES_CACHE_DIRECTORY, this.checkingFactories);
            this.checkAndAddTemplate(renderLayerTemplates, entry.getKey(), renderLayer22);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.CURVE_LAYER_TEMPLATES.entrySet()) {
            RenderLayerCurve.JoinType joinType;
            RenderLayerCurve.CapType capType;
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CURVE_LAYER_TEMPLATE)entry.getValue();
            try {
                capType = RenderLayerCurve.CapType.valueOf(((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CURVE_LAYER_TEMPLATE)data).CAP_TYPE.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to parse cap type '" + ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CURVE_LAYER_TEMPLATE)data).CAP_TYPE + "' for curve render layer '" + entry.getKey() + "'");
                capType = RenderLayerCurve.CapType.ROUND;
            }
            try {
                joinType = RenderLayerCurve.JoinType.valueOf(((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CURVE_LAYER_TEMPLATE)data).JOIN_TYPE.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to parse join type '" + ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CURVE_LAYER_TEMPLATE)data).JOIN_TYPE + "' for curve render layer '" + entry.getKey() + "'");
                joinType = RenderLayerCurve.JoinType.ROUND;
            }
            RenderLayerCurve renderLayer3 = new RenderLayerCurve(entry.getKey(), ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CURVE_LAYER_TEMPLATE)data).COUNT, (float)((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CURVE_LAYER_TEMPLATE)data).SIZE, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CURVE_LAYER_TEMPLATE)data).FIRST_OFFSET, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CURVE_LAYER_TEMPLATE)data).SECOND_OFFSET, capType, joinType);
            this.checkAndAddTemplate(renderLayerTemplates, entry.getKey(), renderLayer3);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.GRADIENT_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.GRADIENT_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerGradient(entry.getKey(), ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.GRADIENT_LAYER_TEMPLATE)data).IGNORE_TRANSPARENT, this.colors, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.GRADIENT_LAYER_TEMPLATE)data).MIN_COLORS, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.GRADIENT_LAYER_TEMPLATE)data).MAX_COLORS);
            this.checkAndAddTemplate(renderLayerTemplates, entry.getKey(), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.RIPPLE_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.RIPPLE_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerRipple(entry.getKey(), ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.RIPPLE_LAYER_TEMPLATE)data).WIDTH, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.RIPPLE_LAYER_TEMPLATE)data).HEIGHT);
            this.checkAndAddTemplate(renderLayerTemplates, entry.getKey(), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.NOISE_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NOISE_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerNoise(entry.getKey(), ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NOISE_LAYER_TEMPLATE)data).PERCENT);
            this.checkAndAddTemplate(renderLayerTemplates, entry.getKey(), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.SPLITTER_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.SPLITTER_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerSplitter(entry.getKey(), ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.SPLITTER_LAYER_TEMPLATE)data).CHUNK_COUNT);
            this.checkAndAddTemplate(renderLayerTemplates, entry.getKey(), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.ROTATION_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.ROTATION_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerRotation(entry.getKey(), ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.ROTATION_LAYER_TEMPLATE)data).FRAMED, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.ROTATION_LAYER_TEMPLATE)data).FRAMED_COUNT, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.ROTATION_LAYER_TEMPLATE)data).EXACT);
            this.checkAndAddTemplate(renderLayerTemplates, entry.getKey(), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.TRANSPARENT_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.TRANSPARENT_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerTransparent(entry.getKey(), ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.TRANSPARENT_LAYER_TEMPLATE)data).ALPHA_LEVEL);
            this.checkAndAddTemplate(renderLayerTemplates, entry.getKey(), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.MIRROR_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.MIRROR_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerMirror(entry.getKey(), ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.MIRROR_LAYER_TEMPLATE)data).HORIZONTAL);
            renderLayerTemplates.put(entry.getKey().toLowerCase(Locale.ROOT), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.CODE_ANSWER_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CODE_ANSWER_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerAnswer(entry.getKey(), new CodeAnswerFactory(entry.getKey(), this.logger, this.checkingFactories, (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CODE_ANSWER_LAYER_TEMPLATE)data, this.fontCacheType, FONTS_CACHE_DIRECTORY));
            renderLayerTemplates.put(entry.getKey().toLowerCase(Locale.ROOT), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.ARITHMETIC_ANSWER_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.ARITHMETIC_ANSWER_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerAnswer(entry.getKey(), new ArithmeticAnswerFactory(entry.getKey(), this.logger, this.checkingFactories, (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.ARITHMETIC_ANSWER_LAYER_TEMPLATE)data, this.fontCacheType, FONTS_CACHE_DIRECTORY));
            renderLayerTemplates.put(entry.getKey().toLowerCase(Locale.ROOT), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerAnswer(entry.getKey(), new NumberSpellingFactory(entry.getKey(), this.logger, this.checkingFactories, (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE)data, this.fontCacheType, FONTS_CACHE_DIRECTORY));
            renderLayerTemplates.put(entry.getKey().toLowerCase(Locale.ROOT), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.COPY_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.COPY_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerCopy(entry.getKey(), ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.COPY_LAYER_TEMPLATE)data).ID);
            renderLayerTemplates.put(entry.getKey().toLowerCase(Locale.ROOT), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.PASTE_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.PASTE_LAYER_TEMPLATE)entry.getValue();
            renderLayer2 = new RenderLayerPaste(entry.getKey(), ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.PASTE_LAYER_TEMPLATE)data).ID, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.PASTE_LAYER_TEMPLATE)data).IGNORE_TRANSPARENT);
            renderLayerTemplates.put(entry.getKey().toLowerCase(Locale.ROOT), renderLayer2);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.COLORIZE_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.COLORIZE_LAYER_TEMPLATE)entry.getValue();
            layer = (RenderLayer)renderLayerTemplates.get(((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.COLORIZE_LAYER_TEMPLATE)data).RENDER_LAYER.toLowerCase(Locale.ROOT));
            if (layer == null) {
                this.logger.log(Level.SEVERE, "Failed to find render layer '" + ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.COLORIZE_LAYER_TEMPLATE)data).RENDER_LAYER.toLowerCase(Locale.ROOT) + "' for colorize render layer '" + entry.getKey() + "'");
                continue;
            }
            renderLayer = new RenderLayerColorize(entry.getKey(), layer, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.COLORIZE_LAYER_TEMPLATE)data).RED, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.COLORIZE_LAYER_TEMPLATE)data).GREEN, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.COLORIZE_LAYER_TEMPLATE)data).BLUE, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.COLORIZE_LAYER_TEMPLATE)data).ALPHA);
            renderLayerTemplates.put(entry.getKey().toLowerCase(Locale.ROOT), (RenderLayer)renderLayer);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.CHANCE_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CHANCE_LAYER_TEMPLATE)entry.getValue();
            layer = (RenderLayer)renderLayerTemplates.get(((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CHANCE_LAYER_TEMPLATE)data).RENDER_LAYER.toLowerCase(Locale.ROOT));
            if (layer == null) {
                this.logger.log(Level.SEVERE, "Failed to find render layer '" + ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CHANCE_LAYER_TEMPLATE)data).RENDER_LAYER.toLowerCase(Locale.ROOT) + "' for chance render layer '" + entry.getKey() + "'");
                continue;
            }
            renderLayer = new RenderLayerChance(entry.getKey(), layer, ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CHANCE_LAYER_TEMPLATE)data).CHANCE);
            renderLayerTemplates.put(entry.getKey().toLowerCase(Locale.ROOT), (RenderLayer)renderLayer);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.RANDOM_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.RANDOM_LAYER_TEMPLATE)entry.getValue();
            renderLayers = new ArrayList<RenderLayer>();
            for (String layer2 : ((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.RANDOM_LAYER_TEMPLATE)data).LAYERS) {
                RenderLayer found = (RenderLayer)renderLayerTemplates.get(layer2.toLowerCase(Locale.ROOT));
                if (found == null) {
                    this.logger.log(Level.SEVERE, "Failed to find render layer '" + layer2 + "' for random render layer '" + entry.getKey() + "'");
                    continue;
                }
                renderLayers.add(found);
            }
            renderLayer = new RenderLayerRandom(entry.getKey(), renderLayers);
            renderLayerTemplates.put(entry.getKey().toLowerCase(Locale.ROOT), (RenderLayer)renderLayer);
        }
        for (Map.Entry<String, Object> entry : CaptchaSettings.IMP.CAPTCHA.RENDER_LAYER_TEMPLATES.GROUPS_LAYER_TEMPLATES.entrySet()) {
            data = (CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.GROUPS_LAYER_TEMPLATE)entry.getValue();
            renderLayers = this.loadGroupedLayers(((CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.GROUPS_LAYER_TEMPLATE)data).LAYERS, renderLayerTemplates, executor);
            renderLayer = new RenderLayerGroups(entry.getKey(), renderLayers);
            renderLayerTemplates.put(entry.getKey().toLowerCase(Locale.ROOT), (RenderLayer)renderLayer);
        }
        return renderLayerTemplates;
    }

    private void checkAndAddTemplate(Map<String, RenderLayer> templates, String name, RenderLayer template) {
        if (templates.get(name = name.toLowerCase(Locale.ROOT)) != null) {
            this.logger.log(Level.SEVERE, "Failed to add render layer template: A template with '" + name + "' name already exists!");
            return;
        }
        templates.put(name, template);
    }

    public List<ResizedGif> loadGifs(FilePaths paths, int minRows, int maxRows, int minColumns, int maxColumns) {
        List<Object> files = new ArrayList();
        if (paths != null) {
            files = paths.calculateExistsFiles(this.logger, "gifs");
        }
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        int threads = CaptchaSettings.IMP.CAPTCHA.THREADS_FOR_GENERATION;
        if (threads < 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        ForkJoinPool executor = new ForkJoinPool(threads, new CustomFJPThreadFactory("GifLoaderAndResizer", 1), null, false);
        ArrayList<GifResizeTask> tasks = new ArrayList<GifResizeTask>();
        for (File file : files) {
            tasks.add(new GifResizeTask(this.logger, executor, GLOBAL_GIFS_CACHE_DIRECTORY, minRows, maxRows, minColumns, maxColumns, this.gifCacheType, this.resizeMethod, file));
        }
        return TasksUtils.executeSimpleTasks(executor, this.logger, tasks, (logger, dataToGenerate, perSec) -> logger.log(Level.INFO, "Async gif loader and resizer [" + dataToGenerate + "/+" + perSec + " ips]"));
    }

    public List<RenderLayer> loadGroupedLayers(List<String> configGroups, Map<String, RenderLayer> renderLayerTemplates, ForkJoinPool executor) {
        if (configGroups == null || configGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RenderLayer> groupedLayers = new ArrayList<RenderLayer>();
        for (String rawGroup : configGroups) {
            List<RenderLayer> renderLayers;
            if (rawGroup.isEmpty() || (renderLayers = this.loadRenderLayers(rawGroup, renderLayerTemplates, executor)).isEmpty()) continue;
            groupedLayers.add(new GroupedLayer(renderLayers));
        }
        return groupedLayers;
    }

    public List<RenderLayer> loadRenderLayers(String configLayers, Map<String, RenderLayer> renderLayerTemplates, ForkJoinPool executor) {
        String[] rawLayers;
        if (configLayers == null || configLayers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RenderLayer> layers = new ArrayList<RenderLayer>();
        for (String rawLayer : rawLayers = configLayers.split(">")) {
            RenderLayer renderLayer = renderLayerTemplates.get(rawLayer.toLowerCase(Locale.ROOT));
            if (renderLayer == null) {
                this.logger.log(Level.SEVERE, "Unknown render layer template name: '" + rawLayer + "'!");
                continue;
            }
            renderLayer.lazyLoad(executor);
            layers.add(renderLayer);
        }
        return layers;
    }

    public List<ResizedGif> getAllGifs() {
        ArrayList<ResizedGif> gifs = new ArrayList<ResizedGif>();
        gifs.addAll(this.animatedHandCaptchaData.getAnimatedCaptchaGif());
        gifs.addAll(this.animatedFramedCaptchaData.getAnimatedCaptchaGif());
        gifs.addAll(this.animatedFramedPuzzleData.getAnimatedCaptchaGif());
        return gifs;
    }

    public CheckingFactoriesImpl getCheckingFactories() {
        return this.checkingFactories;
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public HandCaptchaData getHandCaptchaData() {
        return this.handCaptchaData;
    }

    public AnimatedHandCaptchaData getAnimatedHandCaptchaData() {
        return this.animatedHandCaptchaData;
    }

    public FramedCaptchaData getFramedCaptchaData() {
        return this.framedCaptchaData;
    }

    public AnimatedFramedCaptchaData getAnimatedFramedCaptchaData() {
        return this.animatedFramedCaptchaData;
    }

    public FramedPuzzleData getFramedPuzzleData() {
        return this.framedPuzzleData;
    }

    public AnimatedFramedPuzzleData getAnimatedFramedPuzzleData() {
        return this.animatedFramedPuzzleData;
    }

    public PickCaptchaData getPickCaptchaData() {
        return this.pickCaptchaData;
    }

    public CombinedCaptchaFileCacheType getCaptchaFileCacheType() {
        return this.captchaFileCacheType;
    }

    public ImageCacheType getImageCacheType() {
        return this.imageCacheType;
    }

    public GifCacheType getGifCacheType() {
        return this.gifCacheType;
    }

    public FontCacheType getFontCacheType() {
        return this.fontCacheType;
    }

    public Scalr.Method getResizeMethod() {
        return this.resizeMethod;
    }

    public List<ImageDataSource> getImageDataSources() {
        return this.imageDataSources;
    }

    public Map<String, GroupedImage> getForPickCaptchaGroupedImages() {
        return this.forPickCaptchaGroupedImages;
    }
}

