/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class CacheCleanupUtils {
    public static void doCleanup(Logger logger, File cacheDataDirectory, Set<String> currentHashes, MessageSupplier messageSupplier) {
        int deletedCacheCount = 0;
        File[] cacheFiles = cacheDataDirectory.listFiles();
        if (cacheFiles != null) {
            for (File dataCacheFile : cacheFiles) {
                if (currentHashes.contains(dataCacheFile.getName())) continue;
                try (Stream<Path> pathStream = Files.walk(dataCacheFile.toPath(), new FileVisitOption[0]);){
                    pathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ++deletedCacheCount;
            }
        }
        messageSupplier.onMessage(logger, deletedCacheCount);
    }

    private CacheCleanupUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface MessageSupplier {
        public void onMessage(Logger var1, int var2);
    }
}

