/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Logger;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.GenerationStateWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapPalette;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.CaptchaGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CaptchaFileCacheType;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.api.utils.FastRandom;
import net.shieldcommunity.nullcordx.cache.CachedMapDataPacket;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.XoRoShiRo128PlusRandom;
import net.shieldcommunity.nullcordx.protocol.ProtocolMapData;
import net.shieldcommunity.nullcordx.protocol.packets.MapDataPacket;
import net.shieldcommunity.nullcordx.utils.CompressorThreadLocal;

public class HandCaptchaGenerationTask
extends CaptchaGenerationTask<CachedMapDataPacket> {
    public HandCaptchaGenerationTask(ForkJoinPool executor, Logger logger, NullCordXImpl nullCordX, GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, boolean force, CaptchaHolderImpl<CachedMapDataPacket> holder, List<Color> colors, List<RenderLayer> groupedRenderLayers, List<RenderLayer> postRenderLayers, String cacheHash, CaptchaFileCacheType<CachedMapDataPacket> cacheType) {
        super(executor, logger, nullCordX, generationStateWrapper, compressorThreadLocal, force, holder, colors, groupedRenderLayers, postRenderLayers, cacheHash, cacheType);
    }

    @Override
    public void generate(File cachedCaptchaFile) {
        XoRoShiRo128PlusRandom rnd = FastRandom.getFastRandom();
        Color randomColor = (Color)this.colors.get(((Random)rnd).nextInt(this.colors.size()));
        RenderSession renderSession = new RenderSession();
        BufferedImage image = RenderLayer.renderCurrentLayers(new BufferedImage(128, 128, 2), this.groupedRenderLayers, randomColor, rnd, renderSession);
        image = RenderLayer.renderCurrentLayers(image, this.postRenderLayers, randomColor, rnd, renderSession);
        ProtocolMapData map = MapPalette.imageToMapData(image);
        MapDataPacket packet = new MapDataPacket(0, 0, map);
        CachedMapDataPacket readyPacket = CachedMapDataPacket.create(packet, this.compressorThreadLocal);
        AbstractCaptchaAnswerGenerator answer = renderSession.getAnswer();
        this.holder.setNewCaptcha(answer, readyPacket);
        if (this.generationStateWrapper.isCancelled()) {
            return;
        }
        this.cacheType.saveCaptchaCache(answer != null ? answer.getAnswer() : null, ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED, readyPacket, cachedCaptchaFile);
    }
}

