/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.font;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.concurrent.RecursiveTask;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedGlyph;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedGlyphListData;
import net.shieldcommunity.nullcordx.api.utils.FastRandom;

class GlyphRenderTask
extends RecursiveTask<RenderedGlyphListData> {
    private final char glyph;
    private final Font font;
    private final FontRenderContext ctx;
    private final int height;
    private final boolean rotate;
    private final int rotateCount;
    private final boolean outline;

    @Override
    protected RenderedGlyphListData compute() {
        ArrayList<RenderedGlyph> randomRotations = new ArrayList<RenderedGlyph>();
        for (int i = 1; i <= this.rotateCount; ++i) {
            GlyphVector vector = this.font.createGlyphVector(this.ctx, String.valueOf(this.glyph));
            if (this.rotate) {
                vector.setGlyphTransform(0, AffineTransform.getRotateInstance((FastRandom.getFastRandom().nextDouble() - 0.5) * Math.PI / 8.0));
            }
            Point2D pos = vector.getGlyphPosition(0);
            double posX = pos.getX();
            double posY = pos.getY();
            Rectangle2D bounds = vector.getPixelBounds(null, 0.0f, this.height).getBounds2D();
            vector.setGlyphPosition(0, new Point2D.Double(posX - bounds.getX(), posY - bounds.getY()));
            int localWidth = (int)bounds.getWidth();
            int localHeight = (int)bounds.getHeight();
            BitSet glyphArray = new BitSet(localWidth * localHeight);
            Shape shape = vector.getGlyphOutline(0, -localWidth, this.height - localHeight);
            GlyphRenderTask.drawShape(shape, glyphArray, localWidth, localHeight, 0, 0);
            if (this.outline) {
                GlyphRenderTask.drawShape(new BasicStroke(1.0f).createStrokedShape(shape), glyphArray, localWidth, localHeight, 1, 1);
            }
            randomRotations.add(new RenderedGlyph(this.glyph, glyphArray, localWidth, localHeight));
        }
        return new RenderedGlyphListData(this.glyph, randomRotations);
    }

    private static void drawShape(Shape shape, BitSet array, int width, int height, int offsetX, int offsetY) {
        Rectangle2D box = shape.getBounds2D();
        double multiplierX = box.getX() / (double)width;
        double multiplierY = box.getY() / (double)height;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!shape.contains(multiplierX * (double)x, multiplierY * (double)y)) continue;
                GlyphRenderTask.setIndex(height, y, offsetY, width, x, offsetX, array);
            }
        }
    }

    private static void setIndex(int height, int y, int offsetY, int width, int x, int offsetX, BitSet array) {
        int index = (height - y - 1 + offsetY) * width + (width - x - 1 + offsetX);
        if (index >= 0 && index < array.size()) {
            array.set(index);
        }
    }

    public GlyphRenderTask(char glyph, Font font, FontRenderContext ctx, int height, boolean rotate, int rotateCount, boolean outline) {
        this.glyph = glyph;
        this.font = font;
        this.ctx = ctx;
        this.height = height;
        this.rotate = rotate;
        this.rotateCount = rotateCount;
        this.outline = outline;
    }
}

