/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.util.List;
import net.md_5.bungee.protocol.DefinedPacket;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.checking.AbstractVirtualChecking;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.FastRandom;
import net.shieldcommunity.nullcordx.cache.CachedFallData;
import net.shieldcommunity.nullcordx.cache.CachedPerVersionFallData;
import net.shieldcommunity.nullcordx.cache.FallDataManager;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.protocol.ProtocolBlockType;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerLookPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerOnGroundPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerPositionAndLookPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerPositionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.TeleportConfirmPacket;

public class FallCheck
extends AbstractVirtualChecking {
    private static final int MAX_IGNORED_TICKS = 10;
    private final long maxCheckTime;
    private final int minHeightReset;
    private final ByteBufPacket spawnPacket;
    private final CachedPerVersionFallData cachedPerVersionFallData;
    private long addTime = 0L;
    private double y = 0.0;
    private boolean onGround = false;
    private double lastY = 0.0;
    private int ticks = 1;
    private int commonTicks = 0;
    private int ignoredTicks = 0;
    private boolean platformExists = false;
    private boolean abilityToIgnoreFail = true;
    private long packetDelay = System.currentTimeMillis();
    private long packetDelayOld = System.currentTimeMillis();
    private CachedFallData cachedFallData = null;
    private final ByteBufPacket tempCachedBlockPlacePacket;
    private final ByteBufPacket tempCachedBlockRemovePacket;
    private boolean waitOnGroundThenStartCheck = false;
    private Runnable waitOnGroundOnHit = null;

    public FallCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, long maxCheckTime, int minHeightReset, ByteBufPacket spawnPacket, CachedPerVersionFallData cachedPerVersionFallData, ByteBufPacket tempCachedBlockPlacePacket, ByteBufPacket tempCachedBlockRemovePacket) {
        super(checkingFactory, connector, nullCordX);
        this.maxCheckTime = maxCheckTime;
        this.minHeightReset = minHeightReset;
        this.spawnPacket = spawnPacket;
        this.cachedPerVersionFallData = cachedPerVersionFallData;
        this.tempCachedBlockPlacePacket = tempCachedBlockPlacePacket;
        this.tempCachedBlockRemovePacket = tempCachedBlockRemovePacket;
    }

    @Override
    public String getName() {
        return "Fall";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedGameModeSurvival());
        this.connector.sendCachedPacket(this.tempCachedBlockPlacePacket);
        this.resetPosition(false);
        this.connector.allowFalling(flush);
        this.waitOnGroundThenStartCheck = true;
    }

    private void checkAndStartDelayedCheck() {
        if (this.connector.getWaitingTeleport() == null && this.onGround && this.waitOnGroundThenStartCheck) {
            this.startDelayedCheck();
        }
    }

    protected void startDelayedCheck() {
        this.waitOnGroundThenStartCheck = false;
        this.addTime = System.currentTimeMillis();
        this.connector.sendCachedPacket(this.tempCachedBlockRemovePacket);
        this.resetPosition(false);
        this.connector.allowFalling();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageFallChecking(), true);
    }

    private void checkAndContinueCheck() {
        if (this.onGround && this.waitOnGroundOnHit != null) {
            this.waitOnGroundOnHit.run();
            this.waitOnGroundOnHit = null;
        }
    }

    @Override
    public void onRemoved() {
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedGameModeDefault());
        this.resetData();
    }

    @Override
    public void onScheduledTask() {
        this.connector.sendCachedPacketWithDelay(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageFallChecking(), AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
    }

    @Override
    public void handle(PlayerLookPacket playerLookPacket) {
        this.packetDelayOld = this.packetDelay;
        this.packetDelay = System.currentTimeMillis();
        this.onGround = playerLookPacket.isOnGround();
        this.checkAndStartDelayedCheck();
        this.checkAndContinueCheck();
    }

    @Override
    public void handle(PlayerOnGroundPacket playerOnGroundPacket) throws Exception {
        this.packetDelayOld = this.packetDelay;
        this.packetDelay = System.currentTimeMillis();
        this.onGround = playerOnGroundPacket.isOnGround();
        this.checkAndStartDelayedCheck();
        this.checkAndContinueCheck();
        this.sendDebug(playerOnGroundPacket);
    }

    @Override
    public void handle(PlayerPositionPacket playerPositionPacket) throws Exception {
        this.packetDelayOld = this.packetDelay;
        this.packetDelay = System.currentTimeMillis();
        this.lastY = this.y;
        this.y = playerPositionPacket.getY();
        this.onGround = playerPositionPacket.isOnGround();
        this.checkAndStartDelayedCheck();
        this.checkAndContinueCheck();
        this.handlePlayerMove(playerPositionPacket);
    }

    @Override
    public void handle(PlayerPositionAndLookPacket playerPositionAndLookPacket) throws Exception {
        this.packetDelayOld = this.packetDelay;
        this.packetDelay = System.currentTimeMillis();
        if (this.connector.getProtocolVersion() == 47 && this.connector.getWaitingTeleport() != null) {
            this.resetData();
        }
        this.lastY = this.y;
        this.y = playerPositionAndLookPacket.getY();
        this.onGround = playerPositionAndLookPacket.isOnGround();
        this.checkAndStartDelayedCheck();
        this.checkAndContinueCheck();
        this.handlePlayerMove(playerPositionAndLookPacket);
    }

    @Override
    public void handle(TeleportConfirmPacket teleportConfirmPacket) throws Exception {
        this.packetDelayOld = this.packetDelay;
        this.packetDelay = System.currentTimeMillis();
        this.sendDebug(teleportConfirmPacket);
        this.resetData();
    }

    private void handlePlayerMove(DefinedPacket packet) {
        double currentSpeed;
        this.sendDebug(packet);
        if (this.waitOnGroundThenStartCheck || this.waitOnGroundOnHit != null) {
            return;
        }
        if (this.lastY == Double.MIN_VALUE) {
            return;
        }
        if (this.connector.getWaitingTeleport() != null) {
            return;
        }
        if (this.cachedFallData == null) {
            List<CachedFallData> data = this.cachedPerVersionFallData.getFallDataByProtocol(this.connector.getProtocolVersion());
            if (data == null) {
                this.complete(KickType.FAILED_FALLING, "Mapping for protocol " + this.connector.getProtocolVersion() + " is not found!");
                return;
            }
            this.cachedFallData = data.get(FastRandom.getFastRandom().nextInt(data.size()));
        }
        if (this.ignoredTicks > 10) {
            this.complete(KickType.FAILED_FALLING, "Too many ignored positions in fall check");
            return;
        }
        int currentHitTick = this.cachedFallData.getHitTick();
        int currentHitTickHalf = this.cachedFallData.getHitTickHalf();
        if (this.ticks == currentHitTickHalf && !this.platformExists) {
            ByteBufPacket solidBlocks = this.cachedFallData.getSolidBlocks();
            if (solidBlocks != null) {
                this.connector.sendCachedPacket(solidBlocks, true);
            }
            this.platformExists = true;
        }
        if (this.cachedFallData.getBlockType().getHeight() > 0.0) {
            if (this.ticks > currentHitTick) {
                this.complete(KickType.FAILED_FALLING, "Failed block hit in fall check");
                return;
            }
            if (this.ticks == currentHitTick && this.y == (double)this.cachedFallData.getPlatformY() + this.cachedFallData.getBlockOffset()) {
                if (this.onGround) {
                    this.resetPosition(true);
                } else {
                    this.waitOnGroundOnHit = () -> this.resetPosition(true);
                }
                this.abilityToIgnoreFail = true;
                return;
            }
        }
        if ((currentSpeed = FallDataManager.normalizeSpeedDouble(this.lastY - this.y)) == 0.0) {
            ++this.ignoredTicks;
            return;
        }
        if (this.y < (double)this.minHeightReset) {
            this.resetPosition(true);
            this.abilityToIgnoreFail = true;
            return;
        }
        if (currentSpeed != FallDataManager.getCachedTickSpeed(this.ticks)) {
            if (this.abilityToIgnoreFail) {
                this.abilityToIgnoreFail = false;
                ++this.ignoredTicks;
                this.resetPosition(true);
                return;
            }
            this.complete(KickType.FAILED_FALLING, "Failed position in fall check");
            return;
        }
        if ((long)this.commonTicks >= this.maxCheckTime) {
            long shouldFallTime = this.maxCheckTime * 50L - 500L;
            if (System.currentTimeMillis() - this.addTime < shouldFallTime) {
                this.complete(KickType.FAILED_FALLING, "Too fast fall check completed");
                return;
            }
            this.complete();
            return;
        }
        ++this.ticks;
        ++this.commonTicks;
    }

    public void resetPosition(boolean flush) {
        this.connector.sendCachedPacket(this.spawnPacket, flush);
        this.connector.awaitTeleportConfirm();
    }

    private void resetData() {
        this.connector.resetTeleportConfirm();
        this.ticks = 1;
        this.y = Double.MIN_VALUE;
        this.lastY = Double.MIN_VALUE;
        this.ignoredTicks = 0;
        this.onGround = false;
        if (this.cachedFallData != null) {
            ByteBufPacket packet = this.cachedFallData.getEmptyBlocks();
            if (packet != null) {
                this.connector.sendCachedPacket(packet, true);
            }
            this.cachedFallData = null;
        }
        this.platformExists = false;
    }

    private void sendDebug(DefinedPacket packet) {
        if (!this.nullCordX.canSendDebugLog()) {
            return;
        }
        ProtocolBlockType blockType = ProtocolBlockType.AIR;
        int currentHitTick = 0;
        int platformY = 0;
        if (this.cachedFallData != null) {
            blockType = this.cachedFallData.getBlockType();
            currentHitTick = this.cachedFallData.getHitTick();
            platformY = this.cachedFallData.getPlatformY();
        }
        long delay = this.packetDelay - this.packetDelayOld;
        this.nullCordX.sendDebugLog("PL " + this.connector.getName() + ". SPD: " + FallDataManager.normalizeSpeedDouble(this.lastY - this.y) + "/" + FallDataManager.getCachedTickSpeed(this.ticks) + ". LY: " + this.lastY + ". Y: " + this.y + ". TS: " + this.ticks + ". CT: " + this.commonTicks + ". IT: " + this.ignoredTicks + ". OG: " + this.onGround + ". WOGTSC: " + this.waitOnGroundThenStartCheck + ". WOGOH: " + (this.waitOnGroundOnHit != null) + ". TW: " + (this.connector.getWaitingTeleport() != null) + ". CH: " + currentHitTick + ". PY: " + platformY + ". BLCK: " + blockType.name() + ". PE: " + this.platformExists + ". ATIF: " + this.abilityToIgnoreFail + ". PT: " + packet.getClass().getSimpleName() + ". DY: " + delay + "ms");
    }

    public void setAddTime(long addTime) {
        this.addTime = addTime;
    }
}

