/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientChat;
import net.md_5.bungee.protocol.packet.ClientCommand;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AbstractBoundingChecking;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.api.cache.CaptchaHolder;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.cache.CachedArrayPackets;
import net.shieldcommunity.nullcordx.cache.CachedMessagesByLanguage;
import net.shieldcommunity.nullcordx.config.AntibotSettings;

public class HandCaptchaCheck
extends AbstractBoundingChecking {
    protected int maxAttempts;
    protected int maxSolves;
    protected boolean newCaptchaOnFail;
    protected final String answerPrefix;
    protected final CachedMessagesByLanguage<CachedArrayPackets> messagesAttemptsByLanguage;
    protected CaptchaAnswerGenerator captchaAnswerGenerator;

    public HandCaptchaCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding axisAlignedBounding, int maxAttempts, int maxSolves, boolean newCaptchaOnFail, String answerPrefix, CachedMessagesByLanguage<CachedArrayPackets> messagesAttemptsByLanguage) {
        super(checkingFactory, connector, nullCordX, axisAlignedBounding);
        this.maxAttempts = maxAttempts;
        this.maxSolves = maxSolves;
        this.newCaptchaOnFail = newCaptchaOnFail;
        if (answerPrefix == null) {
            answerPrefix = "";
        }
        this.answerPrefix = answerPrefix;
        this.messagesAttemptsByLanguage = messagesAttemptsByLanguage;
    }

    @Override
    public String getName() {
        return "HandCaptcha";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.disableFalling();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSynchronizePlayerPositionHandCaptcha());
        this.connector.awaitTeleportConfirm();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingHandCaptcha());
        this.sendCaptcha(flush);
    }

    @Override
    public void onRemoved() {
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSetSlotReset(), true);
    }

    @Override
    public void onScheduledTask() {
        this.connector.sendCachedPacketWithDelay(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingHandCaptcha(), AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
    }

    @Override
    public void handle(Chat chat) throws Exception {
        String message = chat.getMessage();
        if (!message.isEmpty() && this.answerPrefix.isEmpty() && message.charAt(0) == '/') {
            message = message.substring(1);
        }
        this.handleChat(message);
    }

    @Override
    public void handle(ClientChat chat) throws Exception {
        this.handleChat(chat.getMessage());
    }

    @Override
    public void handle(ClientCommand command) throws Exception {
        this.handleChat((this.answerPrefix.isEmpty() ? "" : "/") + command.getCommand());
    }

    @Override
    public void teleportToDefaultLocation(boolean flush) {
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSynchronizePlayerPositionHandCaptcha(), flush);
    }

    public void sendCaptcha(boolean flush) {
        CaptchaHolder<? extends ByteBufPacket> holder = this.nullCordX.getCachedCaptchaManager().getCachedHandCaptchaPackets().randomCaptcha();
        if (holder == null) {
            this.complete(KickType.FAILED_CAPTCHA, this.getName() + " was not generated");
            return;
        }
        this.captchaAnswerGenerator = holder.getAnswer();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSetSlotMap());
        this.connector.sendCachedPacket(holder.getCaptcha(), flush);
    }

    private void handleChat(String message) {
        if (this.nullCordX.canSendDebugLog()) {
            this.nullCordX.sendDebugLog("Received from player " + this.connector.getName() + " chat message '" + message + "'");
        }
        this.onMessageReceived(message);
    }

    public Boolean isCorrectMessage(String message) {
        if (this.captchaAnswerGenerator == null) {
            return null;
        }
        String textAnswer = this.captchaAnswerGenerator.getAnswer();
        if (textAnswer == null) {
            return null;
        }
        return message.equalsIgnoreCase(this.answerPrefix + textAnswer);
    }

    public void onMessageReceived(String message) {
        Boolean correct = this.isCorrectMessage(message);
        if (correct == null) {
            return;
        }
        this.onCaptchaComplete(correct);
    }

    public void onCaptchaComplete(boolean completed) {
        if (completed) {
            if (--this.maxSolves == 0) {
                this.complete();
                return;
            }
            this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingMoreCaptcha());
            this.sendCaptcha(true);
        } else if (--this.maxAttempts != 0) {
            ByteBufPacket packet = this.messagesAttemptsByLanguage.getCachedMessages(this.connector.getLanguageType()).getByIndex(this.maxAttempts);
            if (packet != null) {
                this.connector.sendCachedPacket(packet);
            }
            if (this.newCaptchaOnFail) {
                this.sendCaptcha(true);
            } else {
                this.connector.getChannel().getHandle().flush();
            }
        } else {
            this.complete(KickType.FAILED_CAPTCHA, "Failed captcha check");
        }
    }
}

