/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks.answer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.GlyphsBounds;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedFont;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedGlyph;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapCanvasConstants;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;

public class NumberSpellingAnswerGenerator
extends AbstractCaptchaAnswerGenerator {
    private final Int2ObjectMap<List<String>> spellings;
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE numberSpellingAnswerLayerTemplate;
    private String answer;
    private List<String> readySpellings;
    public static final int MIN_NUMBER = 100;
    public static final int MAX_NUMBER = 999;

    public NumberSpellingAnswerGenerator(PerRaCStorage<FontListData> fonts, Int2ObjectMap<List<String>> spellings, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE numberSpellingAnswerLayerTemplate) {
        super(fonts);
        this.spellings = spellings;
        this.numberSpellingAnswerLayerTemplate = numberSpellingAnswerLayerTemplate;
    }

    @Override
    public String getAnswer() {
        return this.answer;
    }

    @Override
    public void generateAnswer(Random random) {
        int randomNumber = 100 + random.nextInt(900);
        this.answer = String.valueOf(randomNumber);
        this.readySpellings = (List)this.spellings.get(randomNumber);
    }

    @Override
    public void draw(Color color, RenderedFont renderedFont, BufferedImage image, int width, int height, Random random) {
        ArrayList<String> separatedText = new ArrayList<String>();
        for (String text : this.readySpellings) {
            String[] sep = text.split(" ");
            separatedText.addAll(Arrays.asList(sep));
        }
        NumberSpellingAnswerGenerator.drawSeparatedText(image, renderedFont, color.getRGB(), this.numberSpellingAnswerLayerTemplate.FONT_SPACE * MapCanvasConstants.calculateSizeModification(width), separatedText, random);
    }

    @Override
    public NumberSpellingAnswerGenerator createCopy() {
        return new NumberSpellingAnswerGenerator(this.fonts, this.spellings, this.numberSpellingAnswerLayerTemplate);
    }

    public static void drawSeparatedText(BufferedImage image, RenderedFont font, int color, int fontSpace, List<String> texts, Random random) {
        double heightOffset;
        int width = image.getWidth();
        int height = image.getHeight();
        int[] destArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        double currentHeightOffset = heightOffset = (double)height / (double)(texts.size() + 1);
        for (String text : texts) {
            GlyphsBounds glyphsBounds = font.createGlyphsBounds(text, fontSpace, random);
            double bw = glyphsBounds.getWidth();
            double cmw = (double)width / 2.0;
            double cbw = bw / 2.0;
            int offsetX = (int)(cmw - cbw);
            for (RenderedGlyph glyph : glyphsBounds.getGlyphs()) {
                BitSet data = glyph.getData();
                int localWidth = glyph.getWidth();
                int localHeight = glyph.getHeight();
                int cHeight = localHeight / 2;
                int y = (int)currentHeightOffset - cHeight;
                for (int i = 0; i < localWidth; ++i) {
                    for (int j = 0; j < localHeight; ++j) {
                        int localX;
                        int localY;
                        int index;
                        if (!data.get(j * localWidth + i) || (index = (localY = j + y) * width + (localX = i + offsetX)) < 0 || index >= destArray.length) continue;
                        destArray[index] = color;
                    }
                }
                offsetX += fontSpace + localWidth;
            }
            currentHeightOffset += heightOffset;
        }
    }

    public String toString() {
        return "NumberSpellingAnswerGenerator(spellings=" + this.spellings + ", answer=" + this.getAnswer() + ", readySpellings=" + this.readySpellings + ")";
    }
}

