/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.api.checking;

import net.shieldcommunity.nullcordx.api.checking.AntiBotCheckResult;

public enum AntiBotCheckResultType implements AntiBotCheckResult
{
    ALWAYS_DENY(true, "Force check enabled and player rejoined."),
    ALWAYS_ALLOW(false, "Force check enabled and player already pass check."),
    FIRST_JOIN(true, "The player joined for the first time or his cache was expired"),
    ALLOWED_DUE_TO_MODE(false, "The player does not require verification until a bot attack is detected"),
    CHANGED_IP(true, "The player who was in the cache changed the ip address"),
    WHITELISTED(false, "The player is whitelisted"),
    IGNORED_IP(false, "Ip address is ignored"),
    NONE(false, "The player cached and does not need any check at the moment"),
    DISABLED(false, "Check is disabled by configuration");

    private final boolean needCheck;
    private final String message;

    private AntiBotCheckResultType(boolean needCheck, String message) {
        this.needCheck = needCheck;
        this.message = message;
    }

    @Override
    public boolean isNeedCheck() {
        return this.needCheck;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "AntiBotCheckResultType." + this.name() + "(needCheck=" + this.isNeedCheck() + ", message=" + this.getMessage() + ")";
    }
}

