/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CachedItemFrameRotationData;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemFrameRotationType;

public class CachedItemFrameRotationDataImpl
implements CachedItemFrameRotationData {
    private final Map<ProtocolItemFrameRotationType, Map<Integer, ByteBufPacket>> data = new EnumMap<ProtocolItemFrameRotationType, Map<Integer, ByteBufPacket>>(ProtocolItemFrameRotationType.class);

    public CachedItemFrameRotationDataImpl() {
        for (ProtocolItemFrameRotationType type : ProtocolItemFrameRotationType.values()) {
            this.data.put(type, new LinkedHashMap());
        }
    }

    @Override
    public void add(ProtocolItemFrameRotationType type, int entityId, ByteBufPacket data) {
        this.data.get((Object)type).put(entityId, data);
    }

    @Override
    public ByteBufPacket getRotationByTypeAndEntityId(ProtocolItemFrameRotationType type, int entityId) {
        return this.data.get((Object)type).get(entityId);
    }

    @Override
    public Collection<ByteBufPacket> getRotationsByType(ProtocolItemFrameRotationType type) {
        return this.data.get((Object)type).values();
    }

    @Override
    public void release() {
        for (Map<Integer, ByteBufPacket> packets : this.data.values()) {
            for (ByteBufPacket packet : packets.values()) {
                packet.release();
            }
        }
    }

    public String toString() {
        return "CachedItemFrameRotationDataImpl(data=" + this.data + ")";
    }
}

