/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.FinishConfiguration;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.Title;
import net.shieldcommunity.nullcordx.LanguageManagerImpl;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.GroupedImage;
import net.shieldcommunity.nullcordx.api.CachedPacketManager;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CachedCaptchaMessages;
import net.shieldcommunity.nullcordx.api.config.messages.LanguageType;
import net.shieldcommunity.nullcordx.api.config.messages.MessagesSettings;
import net.shieldcommunity.nullcordx.api.utils.FastRandom;
import net.shieldcommunity.nullcordx.cache.CachedArrayPackets;
import net.shieldcommunity.nullcordx.cache.CachedCaptchaMessagesImpl;
import net.shieldcommunity.nullcordx.cache.CachedMessagePacket;
import net.shieldcommunity.nullcordx.cache.CachedMessagesImpl;
import net.shieldcommunity.nullcordx.cache.CachedModernAndLegacyPacket;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.cache.CachedPlayerInfo;
import net.shieldcommunity.nullcordx.cache.EmptyCachedPacket;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.Component;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.XoRoShiRo128PlusRandom;
import net.shieldcommunity.nullcordx.protocol.ProtocolEffectType;
import net.shieldcommunity.nullcordx.protocol.ProtocolGameEventChangeGameMode;
import net.shieldcommunity.nullcordx.protocol.ProtocolGameEventReason;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemType;
import net.shieldcommunity.nullcordx.protocol.ProtocolPosition;
import net.shieldcommunity.nullcordx.protocol.ProtocolRelativePositionType;
import net.shieldcommunity.nullcordx.protocol.SlotData;
import net.shieldcommunity.nullcordx.protocol.packets.DefaultSpawnPositionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.EmptyChunkPacket;
import net.shieldcommunity.nullcordx.protocol.packets.EntityEffectPacket;
import net.shieldcommunity.nullcordx.protocol.packets.GameEventPacket;
import net.shieldcommunity.nullcordx.protocol.packets.LoginPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PingTransactionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerAbilitiesPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerInfoPacket;
import net.shieldcommunity.nullcordx.protocol.packets.RegistryDataPacket;
import net.shieldcommunity.nullcordx.protocol.packets.RemoveEntityEffectPacket;
import net.shieldcommunity.nullcordx.protocol.packets.SetCenterChunkPacket;
import net.shieldcommunity.nullcordx.protocol.packets.SetExperiencePacket;
import net.shieldcommunity.nullcordx.protocol.packets.SetSlotPacket;
import net.shieldcommunity.nullcordx.protocol.packets.SynchronizePlayerPositionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.TimeUpdatePacket;
import net.shieldcommunity.nullcordx.protocol.packets.UniversalChatPacket;
import net.shieldcommunity.nullcordx.utils.IOUtils;
import net.shieldcommunity.nullcordx.utils.IdUtils;

@Singleton
public class CachedPacketManagerImpl
extends ManagerComponent
implements CachedPacketManager {
    private final LanguageManagerImpl languageManager;
    private final CheckingFactoriesImpl checkingFactories;
    private ByteBufPacket cachedSetCompression = new EmptyCachedPacket();
    private ByteBufPacket cachedJoin = new EmptyCachedPacket();
    private ByteBufPacket cachedDefaultSpawnPosition = new EmptyCachedPacket();
    private List<ByteBufPacket> cachedEmptyChunks = new ArrayList<ByteBufPacket>();
    private ByteBufPacket cachedSetCenterChunk = new EmptyCachedPacket();
    private ByteBufPacket cachedTimeUpdate = new EmptyCachedPacket();
    private ByteBufPacket cachedPlayerAbilitiesFlying = new EmptyCachedPacket();
    private ByteBufPacket cachedPlayerAbilitiesDefault = new EmptyCachedPacket();
    private ByteBufPacket cachedLevitateZero = new EmptyCachedPacket();
    private ByteBufPacket cachedRemoveEffectLevitate = new EmptyCachedPacket();
    private ByteBufPacket cachedSynchronizePlayerPositionHandCaptcha = new EmptyCachedPacket();
    private ByteBufPacket cachedSetSlotMap = new EmptyCachedPacket();
    private ByteBufPacket cachedSetSlotReset = new EmptyCachedPacket();
    private ByteBufPacket cachedGameModeDefault = new EmptyCachedPacket();
    private ByteBufPacket cachedGameModeSurvival = new EmptyCachedPacket();
    private ByteBufPacket cachedStartWaitingChunks = new EmptyCachedPacket();
    private CachedPlayerInfo cachedPlayerInfo = new CachedPlayerInfo(new EmptyCachedPacket(), "NullCordX", UUID.randomUUID());
    private CachedArrayPackets cachedExperience = null;
    private ByteBufPacket cachedKeepAlive = new EmptyCachedPacket();
    private ByteBufPacket cachedPingTransaction = new EmptyCachedPacket();
    private ByteBufPacket cachedSynchronizePlayerPosition = new EmptyCachedPacket();
    private ByteBufPacket cachedSynchronizePlayerPositionCentered = new EmptyCachedPacket();
    private final Map<Protocol, ByteBufPacket> cachedPluginMessage = new EnumMap<Protocol, ByteBufPacket>(Protocol.class);
    private ByteBufPacket cachedRegistryData = new EmptyCachedPacket();
    private ByteBufPacket cachedFinishConfiguration = new EmptyCachedPacket();
    private Map<LanguageType, CachedMessagesImpl> cachedMessages;
    private final List<Runnable> postTasks = new ArrayList<Runnable>();

    @Inject
    public CachedPacketManagerImpl(NullCordXLogger logger, NullCordXImpl nullCordX, LanguageManagerImpl languageManager, CheckingFactoriesImpl checkingFactories) {
        super(logger, nullCordX, "CachedPacketManager");
        this.languageManager = languageManager;
        this.checkingFactories = checkingFactories;
        EnumMap<Protocol, Map<KickType, ByteBufPacket>> kickMessages = new EnumMap<Protocol, Map<KickType, ByteBufPacket>>(Protocol.class);
        EnumMap<LanguageType, CachedMessagesImpl> cachedMessages = new EnumMap<LanguageType, CachedMessagesImpl>(LanguageType.class);
        cachedMessages.put(languageManager.getDefaultLanguage(), new CachedMessagesImpl(kickMessages, new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), new EmptyCachedPacket(), null));
        this.cachedMessages = cachedMessages;
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        this.cachedSetCompression = CachedPacket.create((DefinedPacket)new SetCompression(BungeeCord.getInstance().config.getCompressionThreshold()), Protocol.LOGIN, -1);
        XoRoShiRo128PlusRandom random = FastRandom.getFastRandom();
        ProtocolGameEventChangeGameMode gameEventChangeGameMode = ProtocolGameEventChangeGameMode.getGameModeByValue(AntibotSettings.IMP.ANTIBOT.DIMENSION.GAME_MODE);
        if (gameEventChangeGameMode == null) {
            gameEventChangeGameMode = ProtocolGameEventChangeGameMode.SURVIVAL;
        }
        this.cachedJoin = CachedPacket.create(new LoginPacket(this.checkingFactories.getClientId(), this.nullCordX.getUsedDimensionType(), AntibotSettings.IMP.ANTIBOT.DIMENSION.HARDCORE_MODE, gameEventChangeGameMode, ((Random)random).nextLong()), Protocol.FILTER);
        AntibotSettings.ANTIBOT.DIMENSION.LOCATION location = AntibotSettings.IMP.ANTIBOT.DIMENSION.LOCATION;
        this.cachedDefaultSpawnPosition = CachedPacket.create(new DefaultSpawnPositionPacket(new ProtocolPosition((int)location.X, (int)location.Y, (int)location.Z), 0.0f), Protocol.FILTER);
        int chunkXOffset = (int)location.X >> 4;
        int chunkZOffset = (int)location.Z >> 4;
        int chunkEdgeSize = AntibotSettings.IMP.ANTIBOT.DIMENSION.CHUNK_EDGE_SIZE;
        ArrayList<CachedPacket> cachedEmptyChunks = new ArrayList<CachedPacket>();
        for (int chunkX = chunkXOffset - chunkEdgeSize; chunkX <= chunkXOffset + chunkEdgeSize; ++chunkX) {
            for (int chunkZ = chunkZOffset - chunkEdgeSize; chunkZ <= chunkZOffset + chunkEdgeSize; ++chunkZ) {
                cachedEmptyChunks.add(CachedPacket.create(new EmptyChunkPacket(chunkX, chunkZ), Protocol.FILTER));
            }
        }
        this.cachedEmptyChunks = Collections.unmodifiableList(cachedEmptyChunks);
        this.cachedSetCenterChunk = CachedPacket.create(new SetCenterChunkPacket(chunkXOffset, chunkZOffset), Protocol.FILTER);
        this.cachedTimeUpdate = CachedPacket.create(new TimeUpdatePacket(1L, AntibotSettings.IMP.ANTIBOT.DIMENSION.TIME), Protocol.FILTER);
        this.cachedPlayerAbilitiesFlying = CachedPacket.create(new PlayerAbilitiesPacket(true, true, true, false, 0.05f, 0.1f), Protocol.FILTER);
        this.cachedPlayerAbilitiesDefault = CachedPacket.create(new PlayerAbilitiesPacket(true, false, false, false, 0.05f, 0.1f), Protocol.FILTER);
        this.cachedLevitateZero = CachedPacket.create(new EntityEffectPacket(this.checkingFactories.getClientId(), ProtocolEffectType.LEVITATE, -1, Integer.MAX_VALUE, false, false, false), Protocol.FILTER);
        this.cachedRemoveEffectLevitate = CachedPacket.create(new RemoveEntityEffectPacket(this.checkingFactories.getClientId(), ProtocolEffectType.LEVITATE), Protocol.FILTER);
        this.cachedSynchronizePlayerPositionHandCaptcha = CachedPacket.create(new SynchronizePlayerPositionPacket(location.X, location.Y, location.Z, 90.0f, 38.0f, this.checkingFactories.getWaitingTeleportId(), new ProtocolRelativePositionType[0]), Protocol.FILTER);
        this.cachedSetSlotMap = CachedPacket.create(new SetSlotPacket(0, AntibotSettings.IMP.ANTIBOT.DIMENSION.CAPTCHA_SLOT, new SlotData(ProtocolItemType.FILLED_MAP, 1, 0)), Protocol.FILTER);
        this.cachedSetSlotReset = CachedPacket.create(new SetSlotPacket(0, AntibotSettings.IMP.ANTIBOT.DIMENSION.CAPTCHA_SLOT, new SlotData(null, 0, 0)), Protocol.FILTER);
        this.cachedGameModeDefault = CachedPacket.create(new GameEventPacket(ProtocolGameEventReason.CHANGE_GAMEMODE, gameEventChangeGameMode), Protocol.FILTER);
        this.cachedGameModeSurvival = CachedPacket.create(new GameEventPacket(ProtocolGameEventReason.CHANGE_GAMEMODE, ProtocolGameEventChangeGameMode.SURVIVAL), Protocol.FILTER);
        this.cachedStartWaitingChunks = CachedPacket.create(new GameEventPacket(ProtocolGameEventReason.START_WAITING_FOR_LEVEL_CHUNKS, null), Protocol.FILTER);
        String userName = AntibotSettings.IMP.ANTIBOT.DIMENSION.PLAYER_LIST.NAME;
        UUID uuid = IdUtils.usernameToOfflineUUID(userName);
        this.cachedPlayerInfo = new CachedPlayerInfo(CachedPacket.create(new PlayerInfoPacket(userName, uuid, AntibotSettings.IMP.ANTIBOT.DIMENSION.PLAYER_LIST.LATENCY), Protocol.FILTER), userName, uuid);
        if (AntibotSettings.IMP.ANTIBOT.DIMENSION.SEND_EXPERIENCE_BY_TIMEOUT) {
            int maxCheckTime = Math.max(AntibotSettings.IMP.ANTIBOT.MODES.JAVA.TIME_OUT, AntibotSettings.IMP.ANTIBOT.MODES.BEDROCK.TIME_OUT);
            int experienceMaxCount = maxCheckTime / 1000;
            ByteBufPacket[] experiencePackets = new ByteBufPacket[experienceMaxCount + 1];
            for (int i = 0; i <= experienceMaxCount; ++i) {
                float experienceBar = i > 0 ? 1.0f / ((float)experienceMaxCount / (float)i) : 0.0f;
                experiencePackets[i] = CachedPacket.create(new SetExperiencePacket(experienceBar, i, 0), Protocol.FILTER);
            }
            this.cachedExperience = new CachedArrayPackets(experiencePackets);
        }
        this.cachedKeepAlive = CachedPacket.create(new KeepAlive(this.checkingFactories.getKeepAliveId()), Protocol.GAME);
        this.cachedPingTransaction = CachedPacket.create(new PingTransactionPacket(this.checkingFactories.getPingTransactionId()), Protocol.FILTER);
        this.cachedSynchronizePlayerPosition = CachedPacket.create(new SynchronizePlayerPositionPacket(location.X, location.Y, location.Z, 90.0f, 0.0f, this.checkingFactories.getWaitingTeleportId(), new ProtocolRelativePositionType[0]), Protocol.FILTER);
        this.cachedSynchronizePlayerPositionCentered = CachedPacket.create(new SynchronizePlayerPositionPacket(location.X, location.Y, location.Z + 0.5, 90.0f, 0.0f, this.checkingFactories.getWaitingTeleportId(), new ProtocolRelativePositionType[0]), Protocol.FILTER);
        this.cachedPluginMessage.put(Protocol.GAME, CachedPacket.create(CachedPacketManagerImpl.createPluginMessage(), Protocol.GAME));
        this.cachedPluginMessage.put(Protocol.CONFIGURATION_FILTER, CachedPacket.create(CachedPacketManagerImpl.createPluginMessage(), Protocol.CONFIGURATION_FILTER));
        this.cachedRegistryData = CachedPacket.create(new RegistryDataPacket(this.nullCordX.getUsedDimensionType()), Protocol.CONFIGURATION_FILTER);
        this.cachedFinishConfiguration = CachedPacket.create(new FinishConfiguration(), Protocol.CONFIGURATION_FILTER);
        EnumMap<LanguageType, CachedMessagesImpl> messages = new EnumMap<LanguageType, CachedMessagesImpl>(LanguageType.class);
        for (MessagesSettings messagesSettings : this.languageManager.getAllMessagesSettings()) {
            Map<Protocol, Map<KickType, ByteBufPacket>> kickMessages = this.createCachedMessages(messagesSettings, Protocol.LOGIN, Protocol.GAME, Protocol.CONFIGURATION_FILTER);
            CachedMessagesImpl cachedMessages = new CachedMessagesImpl(kickMessages, CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.FALL_CHECKING), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.EMPTY_CHECKING), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.PROXY_CHECKING), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.COUNTRY_CHECKING), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.ASN_CHECKING), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.HAND_CAPTCHA), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.ANIMATED_HAND_CAPTCHA), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.FRAMED_CAPTCHA), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.ANIMATED_FRAMED_CAPTCHA), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.FRAMED_PUZZLE), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.ANIMATED_FRAMED_PUZZLE), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.MORE_CAPTCHA), CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.COMPLETED_SUCCESSFULLY), null);
            this.postTasks.add(() -> {
                Map<String, GroupedImage> groupedImages;
                CachedCaptchaMessages oldPacket = cachedMessages.getCachedPickCaptchaMessages();
                if (oldPacket != null) {
                    oldPacket.release();
                    cachedMessages.setCachedPickCaptchaMessages(null);
                }
                if ((groupedImages = this.nullCordX.getCaptchaGenerator().getCaptchaDataSettings().getForPickCaptchaGroupedImages()) == null) {
                    return;
                }
                HashMap<String, ByteBufPacket> answerMessages = new HashMap<String, ByteBufPacket>();
                for (String answer : groupedImages.keySet()) {
                    String replacesAnswer = messagesSettings.MESSAGES.NULLCORDX.PICK_CAPTCHA_TYPES.get(answer);
                    if (replacesAnswer == null) {
                        replacesAnswer = answer;
                    }
                    answerMessages.put(answer, CachedPacketManagerImpl.createMessagePacket(messagesSettings.MESSAGES.NULLCORDX.PICK_CAPTCHA.replace("type", replacesAnswer)));
                }
                cachedMessages.setCachedPickCaptchaMessages(new CachedCaptchaMessagesImpl(answerMessages));
            });
            messages.put(messagesSettings.getType(), cachedMessages);
        }
        this.cachedMessages = messages;
    }

    private Map<Protocol, Map<KickType, ByteBufPacket>> createCachedMessages(MessagesSettings messagesSettings, Protocol ... protocols) {
        EnumMap<Protocol, Map<KickType, ByteBufPacket>> cache = new EnumMap<Protocol, Map<KickType, ByteBufPacket>>(Protocol.class);
        for (Protocol protocol : protocols) {
            EnumMap<KickType, CachedModernAndLegacyPacket<CachedPacket>> kickMessages = new EnumMap<KickType, CachedModernAndLegacyPacket<CachedPacket>>(KickType.class);
            CachedModernAndLegacyPacket<CachedPacket> failedMessage = CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.NOT_PLAYER, protocol);
            kickMessages.put(KickType.PING, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.BIG_PING, protocol));
            kickMessages.put(KickType.FAILED_CAPTCHA, failedMessage);
            kickMessages.put(KickType.FAILED_FALLING, failedMessage);
            kickMessages.put(KickType.FAILED_CHECK, failedMessage);
            kickMessages.put(KickType.TIMED_OUT, failedMessage);
            kickMessages.put(KickType.COUNTRY, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.COUNTRY, protocol));
            kickMessages.put(KickType.ASN, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.ASN, protocol));
            kickMessages.put(KickType.PROXY, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.PROXY, protocol));
            kickMessages.put(KickType.BLACKLISTED_USERNAME, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.BLACKLISTED_USERNAME, protocol));
            kickMessages.put(KickType.BLACKLISTED_BRAND, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.BLACKLISTED_BRAND, protocol));
            kickMessages.put(KickType.ALREADY_CHECKING, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.ALREADY_CHECKING, protocol));
            kickMessages.put(KickType.CHECKING_ERROR, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.CHECKING_ERROR, protocol));
            kickMessages.put(KickType.BIG_PACKET, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.BIG_PACKET, protocol));
            kickMessages.put(KickType.TO_MANY_PACKETS, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.TO_MANY_PACKETS, protocol));
            kickMessages.put(KickType.RELOADING, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.RELOADING, protocol));
            kickMessages.put(KickType.SUCCESSFULLY, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.SUCCESSFULLY, protocol));
            kickMessages.put(KickType.DIRECT_CONNECTION, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.DIRECT_CONNECTION, protocol));
            kickMessages.put(KickType.MANY_CHECKS_SAME, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.MANY_CHECKS_SAME, protocol));
            kickMessages.put(KickType.MANY_CHECKS_DIFFERENT, CachedPacketManagerImpl.createKickPacket(messagesSettings.MESSAGES.NULLCORDX.MANY_CHECKS_DIFFERENT, protocol));
            kickMessages.put(KickType.ALREADY_CONNECTED, CachedPacketManagerImpl.createKickPacket(BungeeCord.getInstance().getTranslationComponent("already_connected_proxy"), protocol));
            kickMessages.put(KickType.NAME_INVALID, CachedPacketManagerImpl.createKickPacket(BungeeCord.getInstance().getTranslationComponent("name_invalid"), protocol));
            kickMessages.put(KickType.NAME_TOO_LONG, CachedPacketManagerImpl.createKickPacket(BungeeCord.getInstance().getTranslationComponent("name_too_long"), protocol));
            kickMessages.put(KickType.PROXY_FULL, CachedPacketManagerImpl.createKickPacket(BungeeCord.getInstance().getTranslationComponent("proxy_full"), protocol));
            kickMessages.put(KickType.OUTDATED_SERVER, CachedPacketManagerImpl.createKickPacket(BungeeCord.getInstance().getTranslationComponent("outdated_server").replace("version", BungeeCord.getInstance().getGameVersion()), protocol));
            kickMessages.put(KickType.OUTDATED_CLIENT, CachedPacketManagerImpl.createKickPacket(BungeeCord.getInstance().getTranslationComponent("outdated_client").replace("version", BungeeCord.getInstance().getGameVersion()), protocol));
            cache.put(protocol, kickMessages);
        }
        return cache;
    }

    @Override
    protected void onUnload() {
        this.cachedSetCompression.release();
        this.cachedJoin.release();
        this.cachedDefaultSpawnPosition.release();
        for (ByteBufPacket packet : this.cachedEmptyChunks) {
            packet.release();
        }
        this.cachedSetCenterChunk.release();
        this.cachedTimeUpdate.release();
        this.cachedPlayerAbilitiesFlying.release();
        this.cachedPlayerAbilitiesDefault.release();
        this.cachedLevitateZero.release();
        this.cachedRemoveEffectLevitate.release();
        this.cachedSynchronizePlayerPositionHandCaptcha.release();
        this.cachedSetSlotMap.release();
        this.cachedSetSlotReset.release();
        this.cachedGameModeDefault.release();
        this.cachedGameModeSurvival.release();
        this.cachedStartWaitingChunks.release();
        this.cachedPlayerInfo.release();
        if (this.cachedExperience != null) {
            this.cachedExperience.release();
        }
        this.cachedKeepAlive.release();
        this.cachedPingTransaction.release();
        this.cachedSynchronizePlayerPosition.release();
        this.cachedSynchronizePlayerPositionCentered.release();
        for (ByteBufPacket packet : this.cachedPluginMessage.values()) {
            packet.release();
        }
        this.cachedRegistryData.release();
        this.cachedFinishConfiguration.release();
        for (CachedMessagesImpl cachedMessages : this.cachedMessages.values()) {
            cachedMessages.release();
        }
    }

    public void executePostTasks() {
        for (Runnable task : this.postTasks) {
            try {
                task.run();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to execute post task", e);
            }
        }
    }

    @Override
    public CachedMessagesImpl getCachedMessagesByLanguage(LanguageType type) {
        return this.languageManager.calculateMessageDataByType(this.cachedMessages, type);
    }

    public ByteBufPacket getCachedPluginMessageByProtocol(Protocol protocol) {
        return this.cachedPluginMessage.get((Object)protocol);
    }

    private static DefinedPacket createPluginMessage() {
        ByteBuf brand = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
        try {
            DefinedPacket.writeString("NullCordX", brand);
            PluginMessage pluginMessage = new PluginMessage("MC|Brand", brand, false);
            return pluginMessage;
        }
        finally {
            CachedPacket.releaseByteBufSafe(brand);
        }
    }

    private static CachedModernAndLegacyPacket<CachedPacket> createKickPacket(ReadyComponentMessage readyComponentMessage, Protocol protocol) {
        Component component = readyComponentMessage.getComponent();
        String jsonKickLegacy = (String)GsonComponentSerializer.colorDownsamplingGson().serialize(component);
        int compressThreshold = -1;
        List<Integer> versions = ProtocolConstants.SUPPORTED_VERSION_IDS;
        if (protocol != Protocol.LOGIN) {
            compressThreshold = BungeeCord.getInstance().config.getCompressionThreshold();
            versions = ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED;
        }
        return new CachedModernAndLegacyPacket<CachedPacket>(CachedPacket.create(new Kick(readyComponentMessage), protocol, compressThreshold, versions), CachedPacket.create(new Kick(ComponentSerializer.deserialize(jsonKickLegacy)), protocol, compressThreshold, versions));
    }

    public static CachedMessagePacket createMessagePacket(ReadyComponentMessage readyComponentMessage) {
        Component component = readyComponentMessage.getComponent();
        String jsonMessageLegacy = (String)GsonComponentSerializer.colorDownsamplingGson().serialize(component);
        String jsonPlainMessageLegacy = ComponentSerializer.toString((BaseComponent)new TextComponent(readyComponentMessage.toLegacyText()));
        byte chatType = (byte)AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.MESSAGE_TYPE;
        CachedMessagePacket.CachedActionBarLegacy cachedActionBarLegacy = null;
        if (chatType == 2) {
            Title title = new Title();
            title.setAction(Title.Action.ACTIONBAR);
            title.setText(ComponentSerializer.deserialize(jsonMessageLegacy));
            cachedActionBarLegacy = new CachedMessagePacket.CachedActionBarLegacy(CachedPacket.create(new UniversalChatPacket(ComponentSerializer.deserialize(jsonPlainMessageLegacy), chatType), Protocol.FILTER), CachedPacket.create(title, Protocol.GAME));
        }
        return new CachedMessagePacket(CachedPacket.create(new UniversalChatPacket(readyComponentMessage, chatType), Protocol.FILTER), CachedPacket.create(new UniversalChatPacket(ComponentSerializer.deserialize(jsonMessageLegacy), chatType), Protocol.FILTER), cachedActionBarLegacy);
    }

    public LanguageManagerImpl getLanguageManager() {
        return this.languageManager;
    }

    public CheckingFactoriesImpl getCheckingFactories() {
        return this.checkingFactories;
    }

    public ByteBufPacket getCachedSetCompression() {
        return this.cachedSetCompression;
    }

    public ByteBufPacket getCachedJoin() {
        return this.cachedJoin;
    }

    public ByteBufPacket getCachedDefaultSpawnPosition() {
        return this.cachedDefaultSpawnPosition;
    }

    public List<ByteBufPacket> getCachedEmptyChunks() {
        return this.cachedEmptyChunks;
    }

    public ByteBufPacket getCachedSetCenterChunk() {
        return this.cachedSetCenterChunk;
    }

    public ByteBufPacket getCachedTimeUpdate() {
        return this.cachedTimeUpdate;
    }

    public ByteBufPacket getCachedPlayerAbilitiesFlying() {
        return this.cachedPlayerAbilitiesFlying;
    }

    public ByteBufPacket getCachedPlayerAbilitiesDefault() {
        return this.cachedPlayerAbilitiesDefault;
    }

    public ByteBufPacket getCachedLevitateZero() {
        return this.cachedLevitateZero;
    }

    public ByteBufPacket getCachedRemoveEffectLevitate() {
        return this.cachedRemoveEffectLevitate;
    }

    @Override
    public ByteBufPacket getCachedSynchronizePlayerPositionHandCaptcha() {
        return this.cachedSynchronizePlayerPositionHandCaptcha;
    }

    @Override
    public ByteBufPacket getCachedSetSlotMap() {
        return this.cachedSetSlotMap;
    }

    @Override
    public ByteBufPacket getCachedSetSlotReset() {
        return this.cachedSetSlotReset;
    }

    @Override
    public ByteBufPacket getCachedGameModeDefault() {
        return this.cachedGameModeDefault;
    }

    @Override
    public ByteBufPacket getCachedGameModeSurvival() {
        return this.cachedGameModeSurvival;
    }

    public ByteBufPacket getCachedStartWaitingChunks() {
        return this.cachedStartWaitingChunks;
    }

    public CachedPlayerInfo getCachedPlayerInfo() {
        return this.cachedPlayerInfo;
    }

    public CachedArrayPackets getCachedExperience() {
        return this.cachedExperience;
    }

    public ByteBufPacket getCachedKeepAlive() {
        return this.cachedKeepAlive;
    }

    public ByteBufPacket getCachedPingTransaction() {
        return this.cachedPingTransaction;
    }

    @Override
    public ByteBufPacket getCachedSynchronizePlayerPosition() {
        return this.cachedSynchronizePlayerPosition;
    }

    @Override
    public ByteBufPacket getCachedSynchronizePlayerPositionCentered() {
        return this.cachedSynchronizePlayerPositionCentered;
    }

    public Map<Protocol, ByteBufPacket> getCachedPluginMessage() {
        return this.cachedPluginMessage;
    }

    public ByteBufPacket getCachedRegistryData() {
        return this.cachedRegistryData;
    }

    public ByteBufPacket getCachedFinishConfiguration() {
        return this.cachedFinishConfiguration;
    }

    public Map<LanguageType, CachedMessagesImpl> getCachedMessages() {
        return this.cachedMessages;
    }

    public List<Runnable> getPostTasks() {
        return this.postTasks;
    }
}

