/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import net.shieldcommunity.nullcordx.api.IChannelWrapper;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.api.cache.CaptchaHolder;

public class CaptchaHolderImpl<T extends ByteBufPacket>
implements CaptchaHolder<T> {
    private final int number;
    private CaptchaAnswerGenerator answer;
    private T captcha;
    private boolean dirty = false;
    private boolean deleted = false;
    private long lastUsed = 0L;

    @Override
    public ByteBuf getByteBufByProtocol(int protocol) {
        if (this.captcha == null) {
            return null;
        }
        return this.captcha.getByteBufByProtocol(protocol);
    }

    @Override
    public void writeAndClose(IChannelWrapper channelWrapper, int protocol, boolean onlineMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writePacket(Channel channel, int protocol, boolean onlineMode) {
        if (this.captcha == null) {
            return;
        }
        this.captcha.writePacket(channel, protocol, onlineMode);
    }

    @Override
    public void writeAndFlushPacket(Channel channel, int protocol, boolean onlineMode) {
        if (this.captcha == null) {
            return;
        }
        this.captcha.writeAndFlushPacket(channel, protocol, onlineMode);
    }

    @Override
    public void release() {
        if (this.captcha == null) {
            return;
        }
        this.captcha.release();
    }

    @Override
    public boolean isForceCopyOnOnlineMode() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.captcha == null || this.dirty;
    }

    public boolean isActuallyDirty() {
        return this.dirty;
    }

    public void setNewCaptcha(CaptchaAnswerGenerator answer, T packet) {
        this.answer = answer;
        T oldPacket = this.captcha;
        this.captcha = packet;
        if (oldPacket != null) {
            oldPacket.release();
        }
        this.dirty = false;
        this.deleted = false;
    }

    public CaptchaHolderImpl(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public CaptchaAnswerGenerator getAnswer() {
        return this.answer;
    }

    @Override
    public T getCaptcha() {
        return this.captcha;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }
}

