/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.chat.modern;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Locale;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.shieldcommunity.nullcordx.chat.modern.CustomSelfSerializable;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.Component;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.minimessage.MiniMessage;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public class ReadyComponentMessage
extends BaseComponent
implements CustomSelfSerializable {
    private static final GsonComponentSerializer SERIALIZER = GsonComponentSerializer.gson();
    private static final LegacyComponentSerializer LEGACY_SECTION_SERIALIZER = LegacyComponentSerializer.legacySection();
    private static final LegacyComponentSerializer LEGACY_HEX_SERIALIZER = LegacyComponentSerializer.builder().character('&').hexColors().build();
    private static final PlainTextComponentSerializer PLAIN_TEXT_SERIALIZER = PlainTextComponentSerializer.plainText();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final transient String originalText;
    private final transient String originalReplaced;
    private Component component = null;
    private String legacy = null;

    public ReadyComponentMessage(String originalText) {
        this(originalText, originalText);
    }

    public ReadyComponentMessage(String originalText, String originalReplaced) {
        this.originalText = originalText;
        this.originalReplaced = originalReplaced;
    }

    public ReadyComponentMessage(String originalText, String originalReplaced, Component component) {
        this(originalText, originalReplaced);
        this.component = component;
    }

    public ReadyComponentMessage(Component component) {
        this("", "");
        this.component = component;
    }

    public Component getComponent() {
        Component component;
        if (this.component != null) {
            return this.component;
        }
        this.component = component = ReadyComponentMessage.parseComponent(this.originalReplaced);
        return component;
    }

    public ReadyComponentMessage replace(String what, String with) {
        return this.doReplace("{" + what.toLowerCase(Locale.ROOT) + "}", with).doReplace("{" + what.toUpperCase(Locale.ROOT) + "}", with);
    }

    private ReadyComponentMessage doReplace(String what, String with) {
        return new ReadyComponentMessage(this.originalText, this.originalReplaced, this.getComponent().replaceText(builder -> builder.matchLiteral(what).replacement(with)));
    }

    public ReadyComponentMessage replace(String what, Component with) {
        return this.doReplace("{" + what.toLowerCase(Locale.ROOT) + "}", with).doReplace("{" + what.toUpperCase(Locale.ROOT) + "}", with);
    }

    private ReadyComponentMessage doReplace(String what, Component with) {
        return new ReadyComponentMessage(this.originalText, this.originalReplaced, this.getComponent().replaceText(builder -> builder.matchLiteral(what).replacement(with)));
    }

    public ReadyComponentMessage replace(String what, BaseComponent with) {
        return this.doReplace("{" + what.toLowerCase(Locale.ROOT) + "}", with).doReplace("{" + what.toUpperCase(Locale.ROOT) + "}", with);
    }

    private ReadyComponentMessage doReplace(String what, BaseComponent with) {
        Component serializedReplacement = SERIALIZER.deserializeFromTree(ComponentSerializer.toJson(with));
        return this.doReplace(what, serializedReplacement);
    }

    @Override
    public String toLegacyText() {
        if (this.legacy == null) {
            this.legacy = LEGACY_SECTION_SERIALIZER.serialize(this.getComponent());
        }
        return this.legacy;
    }

    @Override
    public String toPlainText() {
        return PLAIN_TEXT_SERIALIZER.serialize(this.getComponent());
    }

    @Override
    public BaseComponent duplicate() {
        return this;
    }

    @Override
    public void write(JsonWriter out) throws IOException {
        SERIALIZER.serializer().getAdapter(Component.class).write(out, this.getComponent());
    }

    public static Component parseComponent(String text) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        if (text.indexOf(167) != -1) {
            text = text.replace('\u00a7', '&');
        }
        if (text.indexOf(38) == -1) {
            return MINI_MESSAGE.deserialize(text);
        }
        return MINI_MESSAGE.deserialize(((String)MINI_MESSAGE.serialize(LEGACY_HEX_SERIALIZER.deserialize(text))).replace("\\<", "<").replace("\\>", ">"));
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public String getOriginalReplaced() {
        return this.originalReplaced;
    }

    public String getLegacy() {
        return this.legacy;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadyComponentMessage)) {
            return false;
        }
        ReadyComponentMessage other = (ReadyComponentMessage)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReadyComponentMessage;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    public String toString() {
        return "ReadyComponentMessage(originalText=" + this.getOriginalText() + ", originalReplaced=" + this.getOriginalReplaced() + ", component=" + this.getComponent() + ", legacy=" + this.getLegacy() + ")";
    }
}

