/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.ConnectionThrottle;
import net.md_5.bungee.api.CommandSender;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.api.config.messages.MessagesSettings;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;
import net.shieldcommunity.nullcordx.commands.proxy.console.ConsoleBanListPageCommand;

public class ConsoleBanListCommand
extends CommandNodeBungee {
    public ConsoleBanListCommand(CommandNodeBungee root) {
        super(root, "banlist");
        this.addNode(new ConsoleBanListPageCommand(root));
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_BAN_LIST_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 0) {
            this.sendCurrentHelp(sender);
            return;
        }
        ConsoleBanListCommand.sendBanListList(sender, 1, this.getMessagesSettings(sender));
    }

    public static void sendBanListList(CommandSender sender, int page, MessagesSettings messagesSettings) {
        BungeeCord bungeeCord = BungeeCord.getInstance();
        NullCordXImpl nullCordX = bungeeCord.getNullCordX();
        HashSet<InetAddress> set = new HashSet<InetAddress>();
        ConnectionThrottle throttle = bungeeCord.getConnectionThrottle();
        if (throttle != null) {
            set.addAll(throttle.getAllInetAddress());
        }
        set.addAll(nullCordX.getBlacklistManager().getAllInetAddress());
        ArrayList<String> addresses = new ArrayList<String>();
        for (InetAddress inetAddress : set) {
            addresses.add(inetAddress.getHostAddress());
        }
        ConsoleBanListCommand.sendPageInfo(sender, addresses, page, 20, messagesSettings);
    }
}

