/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.conf.YamlConfig;
import net.md_5.bungee.util.CaseInsensitiveMap;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.config.bungee.BungeeCordSettings;

public class CustomYamlConfig
extends YamlConfig {
    private static final Pattern RANGE_MATCH = Pattern.compile("(.+)\\[(\\d+)-(\\d+)\\]");

    @Override
    public void load() {
        BungeeCordSettings.IMP.reload();
    }

    @Override
    public int getInt(String path, int def) {
        return switch (path.toLowerCase(Locale.ROOT)) {
            case "timeout" -> BungeeCordSettings.IMP.TIMEOUT;
            case "remote_ping_cache" -> BungeeCordSettings.IMP.REMOTE_PING_CACHE;
            case "player_limit" -> BungeeCordSettings.IMP.PLAYER_LIMIT;
            case "server_connect_timeout" -> BungeeCordSettings.IMP.SERVER_CONNECT_TIMEOUT;
            case "remote_ping_timeout" -> BungeeCordSettings.IMP.REMOTE_PING_TIMEOUT;
            case "connection_throttle" -> BungeeCordSettings.IMP.CONNECTION_THROTTLE;
            case "connection_throttle_limit" -> BungeeCordSettings.IMP.CONNECTION_THROTTLE_LIMIT;
            case "network_compression_threshold" -> BungeeCordSettings.IMP.NETWORK_COMPRESSION_THRESHOLD;
            default -> def;
        };
    }

    @Override
    public String getString(String path, String def) {
        switch (path.toLowerCase(Locale.ROOT)) {
            case "stats": {
                return BungeeCordSettings.IMP.STATS;
            }
        }
        return def;
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return switch (path.toLowerCase(Locale.ROOT)) {
            case "online_mode" -> BungeeCordSettings.IMP.ONLINE_MODE;
            case "log_commands" -> BungeeCordSettings.IMP.LOG_COMMANDS;
            case "log_pings" -> BungeeCordSettings.IMP.LOG_PINGS;
            case "ip_forward" -> BungeeCordSettings.IMP.IP_FORWARD;
            case "prevent_proxy_connections" -> BungeeCordSettings.IMP.PREVENT_PROXY_CONNECTIONS;
            case "enforce_secure_profile" -> BungeeCordSettings.IMP.ENFORCE_SECURE_PROFILE;
            case "forge_support" -> BungeeCordSettings.IMP.FORGE_SUPPORT;
            case "reject_transfers" -> BungeeCordSettings.IMP.REJECT_TRANSFERS;
            default -> def;
        };
    }

    @Override
    public Map<String, ServerInfo> getServers() {
        HashMap<String, ServerInfo> ret = new HashMap<String, ServerInfo>();
        for (Map.Entry<String, BungeeCordSettings.SERVER> entry : BungeeCordSettings.IMP.SERVERS.entrySet()) {
            ServerInfo info;
            String name = entry.getKey();
            BungeeCordSettings.SERVER server = entry.getValue();
            String addr = server.ADDRESS;
            String motd = server.MOTD.toLegacyText();
            boolean restricted = server.RESTRICTED;
            SocketAddress address = Util.getAddr(addr);
            Matcher matcher = RANGE_MATCH.matcher(name);
            if (matcher.find()) {
                if (!(address instanceof InetSocketAddress)) {
                    BungeeCord.getInstance().getLogger().warning("Could not use range for servers " + name);
                    info = ProxyServer.getInstance().constructServerInfo(name, address, motd, restricted);
                    ret.put(name, info);
                    continue;
                }
                name = matcher.group(1);
                int lower = Integer.parseInt(matcher.group(2));
                int upper = Integer.parseInt(matcher.group(3));
                BungeeCord.getInstance().getLogger().log(Level.INFO, "Use range [" + lower + ".." + upper + "] for server " + name);
                int port = ((InetSocketAddress)address).getPort();
                for (int i = lower; i <= upper; ++i) {
                    InetSocketAddress next = new InetSocketAddress(((InetSocketAddress)address).getHostName(), port);
                    ServerInfo info2 = BungeeCord.getInstance().constructServerInfo(name + i, next, motd, false);
                    ret.put(info2.getName(), info2);
                    ++port;
                }
                continue;
            }
            info = ProxyServer.getInstance().constructServerInfo(name, address, motd, restricted);
            ret.put(name, info);
        }
        return ret;
    }

    @Override
    public Collection<ListenerInfo> getListeners() {
        HashSet<ListenerInfo> ret = new HashSet<ListenerInfo>();
        for (BungeeCordSettings.LISTENER val : BungeeCordSettings.IMP.LISTENERS) {
            ReadyComponentMessage motd = val.MOTD;
            int maxPlayers = val.MAX_PLAYERS;
            boolean forceDefault = val.FORCE_DEFAULT_SERVER;
            String host = val.HOST;
            int tabListSize = val.TAB_SIZE;
            SocketAddress address = Util.getAddr(host);
            CaseInsensitiveMap<String> forced = new CaseInsensitiveMap<String>(val.FORCED_HOSTS);
            String tabListName = val.TAB_LIST;
            YamlConfig.DefaultTabList value = YamlConfig.DefaultTabList.valueOf(tabListName.toUpperCase(Locale.ROOT));
            boolean setLocalAddress = val.BIND_LOCAL_ADDRESS;
            boolean pingPassthrough = val.PING_PASSTHROUGH;
            boolean query = val.QUERY_ENABLED;
            int queryPort = val.QUERY_PORT;
            boolean proxyProtocol = val.PROXY_PROTOCOL;
            ArrayList<String> serverPriority = new ArrayList<String>(val.PRIORITIES);
            ListenerInfo info = new ListenerInfo(address, motd.toLegacyText(), maxPlayers, tabListSize, serverPriority, forceDefault, forced, value.toString(), setLocalAddress, pingPassthrough, queryPort, query, proxyProtocol);
            ret.add(info);
        }
        return ret;
    }

    @Override
    public Collection<String> getGroups(String player) {
        Map<String, List<String>> raw = BungeeCordSettings.IMP.GROUPS;
        List<String> groups = raw.get(player);
        HashSet<String> ret = groups == null ? new HashSet<String>() : new HashSet<String>(groups);
        ret.add("default");
        return ret;
    }

    @Override
    public Collection<?> getList(String path, Collection<?> def) {
        if (path.equalsIgnoreCase("disabled_commands")) {
            return BungeeCordSettings.IMP.DISABLED_COMMANDS;
        }
        return def;
    }

    @Override
    public Collection<String> getPermissions(String group) {
        Collection permissions = BungeeCordSettings.IMP.PERMISSIONS.get(group);
        return permissions == null ? Collections.emptyList() : permissions;
    }
}

