/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilePaths {
    private final List<String> originalList;
    private final List<File> files;

    public FilePaths(List<String> originalList) {
        this.originalList = originalList;
        ArrayList<File> files = new ArrayList<File>();
        if (this.originalList != null && !this.originalList.isEmpty()) {
            for (String filePath : this.originalList) {
                if (filePath.isEmpty()) continue;
                File file = new File("NullCordX", filePath);
                if (file.isDirectory()) {
                    File[] potentialFiles = file.listFiles();
                    if (potentialFiles == null) continue;
                    for (File imageFile : potentialFiles) {
                        if (imageFile.isDirectory()) continue;
                        files.add(imageFile);
                    }
                    continue;
                }
                files.add(file);
            }
        }
        this.files = files;
    }

    public List<File> calculateExistsFiles(Logger logger, String name) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : this.files) {
            if (!file.exists()) {
                logger.log(Level.WARNING, "Failed to find file '" + file.toPath() + "' for " + name);
                continue;
            }
            files.add(file);
        }
        return files;
    }

    public List<String> getOriginalList() {
        return this.originalList;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilePaths)) {
            return false;
        }
        FilePaths other = (FilePaths)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$originalList = this.getOriginalList();
        List<String> other$originalList = other.getOriginalList();
        if (this$originalList == null ? other$originalList != null : !((Object)this$originalList).equals(other$originalList)) {
            return false;
        }
        List<File> this$files = this.getFiles();
        List<File> other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilePaths;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $originalList = this.getOriginalList();
        result = result * 59 + ($originalList == null ? 43 : ((Object)$originalList).hashCode());
        List<File> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        return result;
    }

    public String toString() {
        return "FilePaths(originalList=" + this.getOriginalList() + ", files=" + this.getFiles() + ")";
    }
}

