/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class FrameSizes {
    private final List<String> originalList;
    private final List<Frame> frames;
    private final int minRow;
    private final int maxRow;
    private final int minColumn;
    private final int maxColumn;

    public FrameSizes(List<String> originalList) {
        this.originalList = originalList;
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (String frameText : originalList) {
            String[] delimited = frameText.split("x");
            if (delimited.length != 2) continue;
            int row = FrameSizes.parseInt(delimited[0]);
            int column = FrameSizes.parseInt(delimited[1]);
            frames.add(new Frame(row, column));
        }
        if (frames.isEmpty()) {
            frames.add(new Frame(1, 1));
        }
        this.minRow = FrameSizes.findMin(frames, true);
        this.maxRow = FrameSizes.findMax(frames, true);
        this.minColumn = FrameSizes.findMin(frames, false);
        this.maxColumn = FrameSizes.findMax(frames, false);
        this.frames = frames;
    }

    public Frame getRandomFrame(Random random) {
        return this.frames.get(random.nextInt(this.frames.size()));
    }

    private static int parseInt(String text) {
        int value = Integer.parseInt(text);
        if (value <= 0) {
            value = 1;
        }
        return value;
    }

    private static int findMin(List<Frame> frames, boolean row) {
        int min2 = Integer.MAX_VALUE;
        for (Frame frame : frames) {
            int data = row ? frame.getRow() : frame.getColumn();
            if (data >= min2) continue;
            min2 = data;
        }
        if (min2 == Integer.MAX_VALUE) {
            min2 = 1;
        }
        return min2;
    }

    private static int findMax(List<Frame> frames, boolean row) {
        int max = 1;
        for (Frame frame : frames) {
            int data = row ? frame.getRow() : frame.getColumn();
            if (data <= max) continue;
            max = data;
        }
        return max;
    }

    public List<String> getOriginalList() {
        return this.originalList;
    }

    public List<Frame> getFrames() {
        return this.frames;
    }

    public int getMinRow() {
        return this.minRow;
    }

    public int getMaxRow() {
        return this.maxRow;
    }

    public int getMinColumn() {
        return this.minColumn;
    }

    public int getMaxColumn() {
        return this.maxColumn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrameSizes)) {
            return false;
        }
        FrameSizes other = (FrameSizes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$originalList = this.getOriginalList();
        List<String> other$originalList = other.getOriginalList();
        return !(this$originalList == null ? other$originalList != null : !((Object)this$originalList).equals(other$originalList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FrameSizes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $originalList = this.getOriginalList();
        result = result * 59 + ($originalList == null ? 43 : ((Object)$originalList).hashCode());
        return result;
    }

    public String toString() {
        return "FrameSizes(originalList=" + this.getOriginalList() + ", frames=" + this.getFrames() + ", minRow=" + this.getMinRow() + ", maxRow=" + this.getMaxRow() + ", minColumn=" + this.getMinColumn() + ", maxColumn=" + this.getMaxColumn() + ")";
    }

    public static final class Frame {
        private final int row;
        private final int column;

        public Frame(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Frame)) {
                return false;
            }
            Frame other = (Frame)o;
            if (this.getRow() != other.getRow()) {
                return false;
            }
            return this.getColumn() == other.getColumn();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRow();
            result = result * 59 + this.getColumn();
            return result;
        }

        public String toString() {
            return "FrameSizes.Frame(row=" + this.getRow() + ", column=" + this.getColumn() + ")";
        }
    }
}

