/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config.migration;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.migration.ConfigMigratorHandler;
import net.shieldcommunity.nullcordx.config.migration.MigrationData;
import net.shieldcommunity.nullcordx.config.migration.configs.DummyVersionSettings;
import net.shieldcommunity.nullcordx.config.migration.configs.antibot.AntibotConfigMigratorF1T2;
import net.shieldcommunity.nullcordx.config.migration.configs.captcha.CaptchaConfigMigratorF1T2;
import net.shieldcommunity.nullcordx.config.migration.configs.config.ConfigConfigMigratorF1T2;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.Long2ObjectMap;

public class ConfigMigration {
    private static final Map<Class<? extends SafeYamlSerializable>, MigrationData> MIGRATORS = new HashMap<Class<? extends SafeYamlSerializable>, MigrationData>();

    public static void checkAndMigrate(Logger logger, SafeYamlSerializable config) {
        Class<?> clazz = config.getClass();
        MigrationData migrationData = MIGRATORS.get(clazz);
        if (migrationData == null) {
            logger.log(Level.SEVERE, "Migration data is not found for config class " + clazz.getSimpleName());
            return;
        }
        Path path = config.getPathLocation();
        DummyVersionSettings dummyVersionSettings = new DummyVersionSettings(path);
        dummyVersionSettings.load();
        long maxVersion = migrationData.getMaxVersion();
        long currentVersion = dummyVersionSettings.CONFIG_VERSION;
        if (currentVersion <= 0L || currentVersion >= maxVersion) {
            return;
        }
        logger.log(Level.WARNING, "Old version of " + clazz.getSimpleName() + " configuration detected. Current version " + currentVersion + ". Latest version: " + maxVersion);
        Long2ObjectMap<ConfigMigratorHandler> handlers = migrationData.getMigrators();
        for (long i = currentVersion; i < maxVersion; ++i) {
            ConfigMigratorHandler handler = (ConfigMigratorHandler)handlers.get(i);
            if (handler == null) {
                logger.log(Level.SEVERE, "Migration handler for version " + i + " is not found for config class " + clazz.getSimpleName());
                continue;
            }
            logger.log(Level.WARNING, "Migrating the " + clazz.getSimpleName() + " configuration from version " + i + " to version " + (i + 1L) + "...");
            handler.migrate(path);
        }
        logger.log(Level.WARNING, "Migration completed successfully for configuration " + clazz.getSimpleName() + "!");
    }

    static {
        MIGRATORS.put(AntibotSettings.class, new MigrationData(2, new AntibotConfigMigratorF1T2()));
        MIGRATORS.put(CaptchaSettings.class, new MigrationData(2, new CaptchaConfigMigratorF1T2()));
        MIGRATORS.put(ConfigSettings.class, new MigrationData(2, new ConfigConfigMigratorF1T2()));
    }
}

