/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config.migration.configs.captcha;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.shieldcommunity.nullcordx.config.FilePaths;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.FilePathsSerializer;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CollectionType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.MapType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class CaptchaSettingsV1
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(new ReadyComponentMessageSerializer()).registerSerializer(new FilePathsSerializer()).setLogMissingFields(false).build();
    public CAPTCHA CAPTCHA = new CAPTCHA();
    public long CONFIG_VERSION = 1L;

    public CaptchaSettingsV1() {
        super(Paths.get("NullCordX/captcha/captcha.yml", new String[0]), CONFIG);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaptchaSettingsV1)) {
            return false;
        }
        CaptchaSettingsV1 other = (CaptchaSettingsV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.CONFIG_VERSION != other.CONFIG_VERSION) {
            return false;
        }
        CAPTCHA this$CAPTCHA = this.CAPTCHA;
        CAPTCHA other$CAPTCHA = other.CAPTCHA;
        return !(this$CAPTCHA == null ? other$CAPTCHA != null : !((Object)this$CAPTCHA).equals(other$CAPTCHA));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CaptchaSettingsV1;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $CONFIG_VERSION = this.CONFIG_VERSION;
        result = result * 59 + (int)($CONFIG_VERSION >>> 32 ^ $CONFIG_VERSION);
        CAPTCHA $CAPTCHA = this.CAPTCHA;
        result = result * 59 + ($CAPTCHA == null ? 43 : ((Object)$CAPTCHA).hashCode());
        return result;
    }

    @Comment(value={@CommentValue(value="Configuration for common captcha customization."), @CommentValue, @CommentValue(value="Warning! By default the captcha is allocated in direct memory, not in the one you usually specify via the '-Xmx' argument."), @CommentValue(value="Usually the size of direct memory is the same as '-Xmx', but this memory is not the same!"), @CommentValue(value="Keep this in mind when generating a large number of images."), @CommentValue(value="You can change the in-memory packets caching behavior in the config.yml configuration.")})
    public static class CAPTCHA {
        @Comment(value={@CommentValue(value="How many threads to use to generate captcha. -1 uses all available threads of the current processor.")})
        public int THREADS_FOR_GENERATION = -1;
        @NewLine
        @Comment(value={@CommentValue(value="How often the captcha should regenerate itself in minutes. -1 to disable.")})
        public int AUTO_REGENERATE_TIME = 120;
        @NewLine
        @Comment(value={@CommentValue(value="Should hide messages about automatic captcha generation?")})
        public boolean AUTO_REGENERATE_HIDE_MESSAGES = false;
        @NewLine
        @Comment(value={@CommentValue(value="What type of captcha cache to use?"), @CommentValue(value="If a cache is used, the generator will save all captcha variants to disk."), @CommentValue(value="On the next initializations, the captcha will be immediately loaded from disk to save time."), @CommentValue(value="The captcha cache will automatically be deleted when the configuration settings are changed or if the captcha has been shown to the player at least 1 time."), @CommentValue, @CommentValue(value="Available types:"), @CommentValue(value="none - The cache is not used. The captcha will not be saved to disk, which means that captcha will be initialized each time."), @CommentValue(value="bin - Cache using bin format. Such files store the captcha in its original form, just like it is stored in RAM, making it possible to quickly write and read them."), @CommentValue(value="binz - Cache using binz format. Such files store the captcha in its original form, just like in RAM, but they are compressed using the fast gzip algorithm."), @CommentValue, @CommentValue(value="Warning! When generating a large number of captchas and without using compression, the captcha can take up gigabytes of disk space.")})
        public String CAPTCHA_CACHE_TYPE = "binz";
        @NewLine
        @Comment(value={@CommentValue(value="What type of image cache to use?"), @CommentValue(value="If a cache is used, the generator will save all image variants to disk."), @CommentValue(value="On the next initializations, the images will be immediately loaded from disk to save time."), @CommentValue, @CommentValue(value="Available types:"), @CommentValue(value="none - The cache is not used. The images will not be saved to disk, which means that images of all sizes will be initialized each time."), @CommentValue(value="png - Cache using png format. Such files are usually compressed, which can affect reading and writing from disk."), @CommentValue(value="bin - Cache using bin format. Such files store the image in its original form, just like it is stored in RAM, making it possible to quickly write and read them.")})
        public String IMAGES_CACHE_TYPE = "png";
        @NewLine
        @Comment(value={@CommentValue(value="What type of gif cache to use?"), @CommentValue(value="If a cache is used, the generator will save all gif variants to disk."), @CommentValue(value="On the next initializations, the gifs will be immediately loaded from disk to save time."), @CommentValue, @CommentValue(value="Available types:"), @CommentValue(value="none - The cache is not used. The gifs will not be saved to disk, which means that gifs of all sizes and frames will be initialized each time."), @CommentValue(value="gif - Cache using gif format. The gifs will be encoded in the original gif format, which can save a lot of space, but it can take a long time to create the file."), @CommentValue(value="bin - Cache using bin format. Such files store the gif in its original form, just like it is stored in RAM, making it possible to quickly write and read them."), @CommentValue(value="binz - Cache using binz format. Such files store the gif in its original form, just like in RAM, but they are compressed using the fast gzip algorithm.")})
        public String GIFS_CACHE_TYPE = "binz";
        @NewLine
        @Comment(value={@CommentValue(value="What type of fonts cache to use?"), @CommentValue(value="If a cache is used, the generator will save all fonts variants to disk."), @CommentValue(value="On the next initializations, the fonts will be immediately loaded from disk to save time."), @CommentValue, @CommentValue(value="Available types:"), @CommentValue(value="none - The cache is not used. The fonts will not be saved to disk, which means that fonts of all sizes will be initialized each time."), @CommentValue(value="bin - Cache using bin format. Such files store the font in its original form, just like it is stored in RAM, making it possible to quickly write and read them."), @CommentValue(value="binz - Cache using binz format. Such files store the font in its original form, just like in RAM, but they are compressed using the fast gzip algorithm.")})
        public String FONTS_CACHE_TYPE = "binz";
        @NewLine
        @Comment(value={@CommentValue(value="Which image resize mode to use?"), @CommentValue, @CommentValue(value="Available modes:"), @CommentValue(value="SPEED - Used to indicate that the scaling implementation should scale as fast as possible."), @CommentValue(value="AUTOMATIC - Used to indicate that the scaling implementation should decide which method to use in order to get the best looking scaled image in the least amount of time."), @CommentValue(value="BALANCED - Used to indicate that the scaling implementation should use a scaling operation balanced between SPEED and QUALITY."), @CommentValue(value="QUALITY - Used to indicate that the scaling implementation should do everything it can to create as nice of a result as possible."), @CommentValue(value="ULTRA_QUALITY - Used to indicate that the scaling implementation should go above and beyond the work done by QUALITY to make the image look exceptionally good at the cost of more processing time.")})
        public String IMAGE_RESIZE_MODE = "QUALITY";
        public RENDER_LAYER_TEMPLATES RENDER_LAYER_TEMPLATES = new RENDER_LAYER_TEMPLATES();
        @NewLine
        @Comment(value={@CommentValue(value="Load always color palette in memory?"), @CommentValue(value="If enabled, when attempting to generate a captcha, the palette will be loaded into memory once instead of each time it is loaded into memory."), @CommentValue(value="This also means that there will always be around 64MB allocated for this palette, even when no captcha is generated.")})
        public boolean ALWAYS_LOAD_MAP_PALETTE = false;
        @NewLine
        @Comment(value={@CommentValue(value="Should the generator use a single color palette from game version 1.8?"), @CommentValue(value="This can save a lot of memory."), @CommentValue(value="The palette for version 1.8 is fully compatible with the latest versions, but contains much fewer colors."), @CommentValue(value="It is recommended to use dithering to soften the difference.")})
        public boolean USE_ONLY_1_8_PALETTE = false;
        @NewLine
        @Comment(value={@CommentValue(value="Should the generator call the garbage collector after each captcha generation?"), @CommentValue(value="You can turn this off if you experience problems with captcha regeneration periodically.")})
        public boolean CALL_GC_AFTER_GENERATION = true;
        @NewLine
        @Comment(value={@CommentValue(value="What colors to use for glyphs? Only hex allowed")})
        @CollectionType(value=ArrayList.class)
        public List<String> COLORS = Arrays.asList("#5A7E28", "#6E9A30", "#7FB238", "#435E1E", "#AEA473", "#D5C98D", "#F7E9A3", "#837B56", "#8C8C8C", "#ACACAC", "#C7C7C7", "#696969", "#B40000", "#DC0000", "#FF0000", "#870000", "#7171B4", "#8A8ADC", "#A0A0FF", "#555587", "#767676", "#909090", "#A7A7A7", "#585858", "#005800", "#006B00", "#007C00", "#004200", "#B4B4B4", "#DCDCDC", "#FFFFFF", "#878787", "#747782", "#8D919F", "#A4A8B8", "#575961", "#6B4D36", "#825E42", "#976D4D", "#503A29", "#4F4F4F", "#616161", "#707070", "#3B3B3B", "#2D2DB4", "#3737DC", "#4040FF", "#222287", "#655433", "#7B673E", "#8F7748", "#4C3F26", "#B4B2AD", "#DCD9D3", "#FFFCF5", "#878582", "#985A24", "#BA6E2C", "#D87F33", "#72431B", "#7E3698", "#9A42BA", "#B24CD8", "#5E2872", "#486C98", "#5884BA", "#6699D8", "#365172", "#A2A224", "#C6C62C", "#E5E533", "#79791B", "#5A9012", "#6EB016", "#7FCC19", "#436C0D", "#AB5A74", "#D16E8E", "#F27FA5", "#804357", "#363636", "#424242", "#4C4C4C", "#282828", "#6C6C6C", "#848484", "#999999", "#515151", "#365A6C", "#426E84", "#4C7F99", "#284351", "#5A2C7E", "#6E369A", "#7F3FB2", "#43215E", "#24367E", "#2C429A", "#334CB2", "#1B285E", "#483624", "#58422C", "#664C33", "#36281B", "#485A24", "#586E2C", "#667F33", "#36431B", "#6C2424", "#842C2C", "#993333", "#511B1B", "#121212", "#161616", "#191919", "#0D0D0D", "#B0A836", "#D8CD42", "#FAEE4D", "#847E29", "#419B96", "#4FBDB8", "#5CDBD5", "#317471", "#345AB4", "#406EDC", "#4A80FF", "#274487", "#009929", "#00BB32", "#00D93A", "#00731F", "#5B3D23", "#6F4A2A", "#815631", "#442E1A", "#4F0100", "#610200", "#700200", "#3B0100", "#947D72", "#B4998B", "#D1B1A1", "#6F5E55", "#703A19", "#89471F", "#9F5224", "#542B13", "#693D4C", "#814B5D", "#95576C", "#4F2E39", "#4F4C61", "#615D77", "#706C8A", "#3B3949", "#835E19", "#A0731F", "#BA8524", "#624613", "#495325", "#59652E", "#677535", "#373E1C", "#713637", "#8A4243", "#A04D4E", "#552929", "#281D19", "#31231E", "#392923", "#1E1613", "#5F4C45", "#745C55", "#876B62", "#473934", "#3D4141", "#4B4F4F", "#575C5C", "#2E3131", "#56343E", "#693F4C", "#7A4958", "#41272F", "#362C41", "#42354F", "#4C3E5C", "#282131", "#362319", "#422B1E", "#4C3223", "#281A13", "#363A1E", "#424724", "#4C522A", "#282B16", "#642A20", "#7B3428", "#8E3C2E", "#4B2018", "#1A100B", "#20130E", "#251610", "#140C08", "#852223", "#A3292A", "#BD3031", "#64191A", "#682C44", "#803654", "#943F61", "#4E2133", "#411214", "#4F1619", "#5C191D", "#310D0F", "#10595F", "#136D74", "#167E86", "#0C4347", "#296463", "#327B79", "#3A8E8C", "#1F4B4A", "#3D1F2C", "#4A2635", "#562C3E", "#2E1721", "#0E7F5E", "#119B73", "#14B485", "#0B5F46", "#474747", "#565656", "#646464", "#353535", "#987C68", "#BA977F", "#D8AF93", "#725D4E", "#5A766A", "#6E9081", "#7FA796", "#43584F");

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CAPTCHA)) {
                return false;
            }
            CAPTCHA other = (CAPTCHA)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.THREADS_FOR_GENERATION != other.THREADS_FOR_GENERATION) {
                return false;
            }
            if (this.AUTO_REGENERATE_TIME != other.AUTO_REGENERATE_TIME) {
                return false;
            }
            if (this.AUTO_REGENERATE_HIDE_MESSAGES != other.AUTO_REGENERATE_HIDE_MESSAGES) {
                return false;
            }
            if (this.ALWAYS_LOAD_MAP_PALETTE != other.ALWAYS_LOAD_MAP_PALETTE) {
                return false;
            }
            if (this.USE_ONLY_1_8_PALETTE != other.USE_ONLY_1_8_PALETTE) {
                return false;
            }
            if (this.CALL_GC_AFTER_GENERATION != other.CALL_GC_AFTER_GENERATION) {
                return false;
            }
            String this$CAPTCHA_CACHE_TYPE = this.CAPTCHA_CACHE_TYPE;
            String other$CAPTCHA_CACHE_TYPE = other.CAPTCHA_CACHE_TYPE;
            if (this$CAPTCHA_CACHE_TYPE == null ? other$CAPTCHA_CACHE_TYPE != null : !this$CAPTCHA_CACHE_TYPE.equals(other$CAPTCHA_CACHE_TYPE)) {
                return false;
            }
            String this$IMAGES_CACHE_TYPE = this.IMAGES_CACHE_TYPE;
            String other$IMAGES_CACHE_TYPE = other.IMAGES_CACHE_TYPE;
            if (this$IMAGES_CACHE_TYPE == null ? other$IMAGES_CACHE_TYPE != null : !this$IMAGES_CACHE_TYPE.equals(other$IMAGES_CACHE_TYPE)) {
                return false;
            }
            String this$GIFS_CACHE_TYPE = this.GIFS_CACHE_TYPE;
            String other$GIFS_CACHE_TYPE = other.GIFS_CACHE_TYPE;
            if (this$GIFS_CACHE_TYPE == null ? other$GIFS_CACHE_TYPE != null : !this$GIFS_CACHE_TYPE.equals(other$GIFS_CACHE_TYPE)) {
                return false;
            }
            String this$FONTS_CACHE_TYPE = this.FONTS_CACHE_TYPE;
            String other$FONTS_CACHE_TYPE = other.FONTS_CACHE_TYPE;
            if (this$FONTS_CACHE_TYPE == null ? other$FONTS_CACHE_TYPE != null : !this$FONTS_CACHE_TYPE.equals(other$FONTS_CACHE_TYPE)) {
                return false;
            }
            String this$IMAGE_RESIZE_MODE = this.IMAGE_RESIZE_MODE;
            String other$IMAGE_RESIZE_MODE = other.IMAGE_RESIZE_MODE;
            if (this$IMAGE_RESIZE_MODE == null ? other$IMAGE_RESIZE_MODE != null : !this$IMAGE_RESIZE_MODE.equals(other$IMAGE_RESIZE_MODE)) {
                return false;
            }
            RENDER_LAYER_TEMPLATES this$RENDER_LAYER_TEMPLATES = this.RENDER_LAYER_TEMPLATES;
            RENDER_LAYER_TEMPLATES other$RENDER_LAYER_TEMPLATES = other.RENDER_LAYER_TEMPLATES;
            if (this$RENDER_LAYER_TEMPLATES == null ? other$RENDER_LAYER_TEMPLATES != null : !((Object)this$RENDER_LAYER_TEMPLATES).equals(other$RENDER_LAYER_TEMPLATES)) {
                return false;
            }
            List<String> this$COLORS = this.COLORS;
            List<String> other$COLORS = other.COLORS;
            return !(this$COLORS == null ? other$COLORS != null : !((Object)this$COLORS).equals(other$COLORS));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CAPTCHA;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.THREADS_FOR_GENERATION;
            result = result * 59 + this.AUTO_REGENERATE_TIME;
            result = result * 59 + (this.AUTO_REGENERATE_HIDE_MESSAGES ? 79 : 97);
            result = result * 59 + (this.ALWAYS_LOAD_MAP_PALETTE ? 79 : 97);
            result = result * 59 + (this.USE_ONLY_1_8_PALETTE ? 79 : 97);
            result = result * 59 + (this.CALL_GC_AFTER_GENERATION ? 79 : 97);
            String $CAPTCHA_CACHE_TYPE = this.CAPTCHA_CACHE_TYPE;
            result = result * 59 + ($CAPTCHA_CACHE_TYPE == null ? 43 : $CAPTCHA_CACHE_TYPE.hashCode());
            String $IMAGES_CACHE_TYPE = this.IMAGES_CACHE_TYPE;
            result = result * 59 + ($IMAGES_CACHE_TYPE == null ? 43 : $IMAGES_CACHE_TYPE.hashCode());
            String $GIFS_CACHE_TYPE = this.GIFS_CACHE_TYPE;
            result = result * 59 + ($GIFS_CACHE_TYPE == null ? 43 : $GIFS_CACHE_TYPE.hashCode());
            String $FONTS_CACHE_TYPE = this.FONTS_CACHE_TYPE;
            result = result * 59 + ($FONTS_CACHE_TYPE == null ? 43 : $FONTS_CACHE_TYPE.hashCode());
            String $IMAGE_RESIZE_MODE = this.IMAGE_RESIZE_MODE;
            result = result * 59 + ($IMAGE_RESIZE_MODE == null ? 43 : $IMAGE_RESIZE_MODE.hashCode());
            RENDER_LAYER_TEMPLATES $RENDER_LAYER_TEMPLATES = this.RENDER_LAYER_TEMPLATES;
            result = result * 59 + ($RENDER_LAYER_TEMPLATES == null ? 43 : ((Object)$RENDER_LAYER_TEMPLATES).hashCode());
            List<String> $COLORS = this.COLORS;
            result = result * 59 + ($COLORS == null ? 43 : ((Object)$COLORS).hashCode());
            return result;
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for render layer templates."), @CommentValue, @CommentValue(value="Render layer templates are a convenient way to customize the parameters of each layer separately, creating different templates with different settings."), @CommentValue(value="Each template has its own type. For now, here is the list of configurable templates:"), @CommentValue, @CommentValue(value="Image - Is a simple image, usually it is in the very first layer"), @CommentValue(value="Curve - Random line, usually used to complicate the code"), @CommentValue(value="Gradient - Fills an image with a gradient (iridescent colors)"), @CommentValue(value="Ripple - Distorts images, making them completely unpredictable"), @CommentValue(value="Noise - Adds random noise (random color of pixels in a random place) to the whole image"), @CommentValue(value="Splitter - Divides the image into fragments and then shuffles them in random order"), @CommentValue(value="Rotation - Rotates the image in a random direction"), @CommentValue(value="Transparent - Adds an alpha value (transparency level) to each pixel in this image, creating a transparent effect when applied to a background."), @CommentValue(value="Mirror - Mirrors the entire image horizontally"), @CommentValue(value="Colorize - Paints the specified layer the specified color. Can be useful for cases of overlaying transparency for curve"), @CommentValue(value="Code - The code or text that is drawn on the captcha, usually this is the code that you need to enter from the image"), @CommentValue(value="Arithmetic - Same as code, but except that the user needs to solve an arithmetic example"), @CommentValue(value="Number-spelling - Same as code, but except that the user needs to answer in numbers (for example, 241 - two hundred forty one)"), @CommentValue(value="Random - Randomly selects a layer from its list for rendering. Can be useful for rendering certain layers randomly"), @CommentValue, @CommentValue(value="Layers that cannot be configured and have a constant name:"), @CommentValue, @CommentValue(value="Dithering - Mixes different colors, allows you to achieve a better transition of colors in conditions of a limited number of colors"), @CommentValue, @CommentValue(value="Each layer has its own custom name, you can add and name as many layers as you like."), @CommentValue(value="By default, the name of a configurable layer is equal to its type, however, you can change this to your liking."), @CommentValue(value="If you have any questions about how it works feel free to ask on Discord.")})
        public static class RENDER_LAYER_TEMPLATES {
            @Comment(value={@CommentValue(value="Configuration for image layer templates."), @CommentValue, @CommentValue(value="images - Paths to images files (.png, .jpg, .bmp, .wbmp file)"), @CommentValue(value="You can specify the path to the directory where all the images are located. The generator will try to load all the images."), @CommentValue(value="ignore-transparent - Whether transparent pixels should be ignored")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, IMAGE_LAYER_TEMPLATE> IMAGE_LAYER_TEMPLATES = new LinkedHashMap<String, IMAGE_LAYER_TEMPLATE>();
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for curve layer templates."), @CommentValue, @CommentValue(value="count - How many random lines need to be generated?"), @CommentValue(value="size - Random lines size in pixels")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, CURVE_LAYER_TEMPLATE> CURVE_LAYER_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for gradient layer templates."), @CommentValue, @CommentValue(value="min-colors - Minimum number of random colors for a gradient"), @CommentValue(value="max-colors - Maximum number of random colors for a gradient"), @CommentValue(value="ignore-transparent - Whether transparent pixels should be ignored")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, GRADIENT_LAYER_TEMPLATE> GRADIENT_LAYER_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for ripple layer templates."), @CommentValue, @CommentValue(value="width - How much to distort images in width?"), @CommentValue(value="height - How much to distort images in height?")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, RIPPLE_LAYER_TEMPLATE> RIPPLE_LAYER_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for noise layer templates."), @CommentValue, @CommentValue(value="percent - How often to generate noises? In percent. 1.0 - 100%, 0.0 - 0%, 0.5 - 50%")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, NOISE_LAYER_TEMPLATE> NOISE_LAYER_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for splitter layer templates."), @CommentValue, @CommentValue(value="chunk-count - Into how many fragments should the image be divided?")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, SPLITTER_LAYER_TEMPLATE> SPLITTER_LAYER_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for rotation layer templates."), @CommentValue, @CommentValue(value="framed - If enabled, should the image be fragmented and then rotate the fragments randomly?"), @CommentValue(value="framed-count - Into how many fragments should the image be divided?"), @CommentValue(value="exact - Should the image be rotated exactly 90 degrees?"), @CommentValue(value="chance - With what chance to rotate the image."), @CommentValue(value="In percent. 1.0 - 100%, 0.0 - 0%, 0.5 - 50%")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, ROTATION_LAYER_TEMPLATE> ROTATION_LAYER_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for transparent layer templates."), @CommentValue, @CommentValue(value="alpha-level - Pixel transparency level."), @CommentValue(value="The closer the value is to zero, the more transparent the pixel."), @CommentValue(value="Valid values are from 0 to 255.")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, TRANSPARENT_LAYER_TEMPLATE> TRANSPARENT_LAYER_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for mirror layer templates."), @CommentValue, @CommentValue(value="horizontal - What type of mirroring to use?"), @CommentValue(value="true - horizontal, false - vertical"), @CommentValue(value="chance - With what chance to mirror the image."), @CommentValue(value="In percent. 1.0 - 100%, 0.0 - 0%, 0.5 - 50%")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, MIRROR_LAYER_TEMPLATE> MIRROR_LAYER_TEMPLATES;
            @Comment(value={@CommentValue(value="Configuration for colorize layer templates."), @CommentValue, @CommentValue(value="render-layer - Name of the layer that should be colored."), @CommentValue(value="red - Red color. Range from 0 to 255."), @CommentValue(value="green - Green color. Range from 0 to 255."), @CommentValue(value="blue - Blue color. Range from 0 to 255."), @CommentValue(value="alpha - Alpha color (transparent). Range from 0 to 255.")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, COLORIZE_LAYER_TEMPLATE> COLORIZE_LAYER_TEMPLATES;
            @Comment(value={@CommentValue(value="Configuration for random layer templates."), @CommentValue, @CommentValue(value="layers - A list of layers that is used to select one random layer.")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, RANDOM_LAYER_TEMPLATE> RANDOM_LAYER_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for code answer layer templates."), @CommentValue, @CommentValue(value="default-font-sans-serif - Whether to use the default font SANS_SERIF?"), @CommentValue(value="default-font-serif - Whether to use the default font SERIF?"), @CommentValue(value="default-font-monospaced - Whether to use the default font MONOSPACED?"), @CommentValue(value="default-font-dialog - Whether to use the default font DIALOG?"), @CommentValue(value="default-font-dialog-input - Whether to use the default font DIALOG_INPUT?"), @CommentValue(value="custom-fonts - Paths to custom fonts (.ttf file). Disabled if empty."), @CommentValue(value="font-size - Font size in pixels."), @CommentValue(value="font-space - Distance in pixels between glyphs."), @CommentValue(value="rotate-count - How many rotated glyph variants to generate for one glyph? 0 - to disable."), @CommentValue(value="outline - Whether to use outline for glyphs?"), @CommentValue(value="glyph-random-height - Should each individual glyph be generated with a different height?"), @CommentValue(value="char-set - What characters to use to generate random code? Do not use similar characters, otherwise it will be more difficult for ordinary people to pass the captcha."), @CommentValue(value="min-length - Minimum char-set length."), @CommentValue(value="max-length - Maximum char-set length. Don't forget to change the font size, otherwise the text may not fit in the captcha.")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, CODE_ANSWER_LAYER_TEMPLATE> CODE_ANSWER_LAYER_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for arithmetic answer layer templates."), @CommentValue, @CommentValue(value="default-font-sans-serif - Whether to use the default font SANS_SERIF?"), @CommentValue(value="default-font-serif - Whether to use the default font SERIF?"), @CommentValue(value="default-font-monospaced - Whether to use the default font MONOSPACED?"), @CommentValue(value="default-font-dialog - Whether to use the default font DIALOG?"), @CommentValue(value="default-font-dialog-input - Whether to use the default font DIALOG_INPUT?"), @CommentValue(value="custom-fonts - Paths to custom fonts (.ttf file). Disabled if empty."), @CommentValue(value="font-size - Font size in pixels."), @CommentValue(value="font-space - Distance in pixels between glyphs."), @CommentValue(value="rotate-count - How many rotated glyph variants to generate for one glyph? 0 - to disable."), @CommentValue(value="outline - Whether to use outline for glyphs?"), @CommentValue(value="glyph-random-height - Should each individual glyph be generated with a different height?"), @CommentValue(value="enabled-addition - Should the generator use the addition operation?"), @CommentValue(value="addition-chars - What symbols are considered addition operators?"), @CommentValue(value="enabled-substraction - Should the generator use the substraction operation?"), @CommentValue(value="substraction-chars - What symbols are considered substraction operators?"), @CommentValue(value="enabled-multiplication - Should the generator use the multiplication operation?"), @CommentValue(value="multiplication-chars - What symbols are considered multiplication operators?"), @CommentValue(value="enabled-division - Should the generator use the division operation?"), @CommentValue(value="divisions-char - What symbols are considered division operators?"), @CommentValue(value="max-arithmetic-number - What is the maximum number to use for the arithmetic generator?"), @CommentValue(value="arithmetic-example - How exactly to display an arithmetic example?"), @CommentValue(value="Values starting with percentages are placeholders."), @CommentValue(value="%first% - First operand"), @CommentValue(value="%second% - Second operand"), @CommentValue(value="%operator% - Operator symbol")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, ARITHMETIC_ANSWER_LAYER_TEMPLATE> ARITHMETIC_ANSWER_LAYER_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for number spelling layer templates."), @CommentValue, @CommentValue(value="default-font-sans-serif - Whether to use the default font SANS_SERIF?"), @CommentValue(value="default-font-serif - Whether to use the default font SERIF?"), @CommentValue(value="default-font-monospaced - Whether to use the default font MONOSPACED?"), @CommentValue(value="default-font-dialog - Whether to use the default font DIALOG?"), @CommentValue(value="default-font-dialog-input - Whether to use the default font DIALOG_INPUT?"), @CommentValue(value="custom-fonts - Paths to custom fonts (.ttf file). Disabled if empty."), @CommentValue(value="font-size - Font size in pixels."), @CommentValue(value="font-space - Distance in pixels between glyphs."), @CommentValue(value="rotate-count - How many rotated glyph variants to generate for one glyph? 0 - to disable."), @CommentValue(value="outline - Whether to use outline for glyphs?"), @CommentValue(value="hundreds - Translation for thousand numbers."), @CommentValue(value="tenths - Translation for decimal numbers."), @CommentValue(value="units - Translation for single numbers."), @CommentValue(value="exceptions - Translation for numbers between 11 and 19.")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE> NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES;

            public RENDER_LAYER_TEMPLATES() {
                this.IMAGE_LAYER_TEMPLATES.put("image", new IMAGE_LAYER_TEMPLATE());
                this.IMAGE_LAYER_TEMPLATES.put("hand-image", new IMAGE_LAYER_TEMPLATE());
                this.IMAGE_LAYER_TEMPLATES.put("framed-image", new IMAGE_LAYER_TEMPLATE());
                this.CURVE_LAYER_TEMPLATES = new LinkedHashMap<String, CURVE_LAYER_TEMPLATE>();
                this.CURVE_LAYER_TEMPLATES.put("curve", new CURVE_LAYER_TEMPLATE());
                this.CURVE_LAYER_TEMPLATES.put("complicated-curve", new CURVE_LAYER_TEMPLATE(6, 2.0));
                this.GRADIENT_LAYER_TEMPLATES = new LinkedHashMap<String, GRADIENT_LAYER_TEMPLATE>();
                this.GRADIENT_LAYER_TEMPLATES.put("gradient", new GRADIENT_LAYER_TEMPLATE());
                this.GRADIENT_LAYER_TEMPLATES.put("hand-gradient", new GRADIENT_LAYER_TEMPLATE());
                this.GRADIENT_LAYER_TEMPLATES.put("framed-gradient", new GRADIENT_LAYER_TEMPLATE());
                this.RIPPLE_LAYER_TEMPLATES = new LinkedHashMap<String, RIPPLE_LAYER_TEMPLATE>();
                this.RIPPLE_LAYER_TEMPLATES.put("ripple", new RIPPLE_LAYER_TEMPLATE());
                this.RIPPLE_LAYER_TEMPLATES.put("ripple-less", new RIPPLE_LAYER_TEMPLATE(100.0, 50.0));
                this.NOISE_LAYER_TEMPLATES = new LinkedHashMap<String, NOISE_LAYER_TEMPLATE>();
                this.NOISE_LAYER_TEMPLATES.put("noise", new NOISE_LAYER_TEMPLATE());
                this.NOISE_LAYER_TEMPLATES.put("less-noise", new NOISE_LAYER_TEMPLATE(0.001));
                this.SPLITTER_LAYER_TEMPLATES = new LinkedHashMap<String, SPLITTER_LAYER_TEMPLATE>();
                this.SPLITTER_LAYER_TEMPLATES.put("splitter", new SPLITTER_LAYER_TEMPLATE());
                this.SPLITTER_LAYER_TEMPLATES.put("huge-splitter", new SPLITTER_LAYER_TEMPLATE(4));
                this.ROTATION_LAYER_TEMPLATES = new LinkedHashMap<String, ROTATION_LAYER_TEMPLATE>();
                this.ROTATION_LAYER_TEMPLATES.put("rotation", new ROTATION_LAYER_TEMPLATE());
                this.ROTATION_LAYER_TEMPLATES.put("rotation-chance", new ROTATION_LAYER_TEMPLATE(false, 1, true, 0.5));
                this.ROTATION_LAYER_TEMPLATES.put("rotation-framed", new ROTATION_LAYER_TEMPLATE(true, 3, true, 1.0));
                this.ROTATION_LAYER_TEMPLATES.put("rotation-free", new ROTATION_LAYER_TEMPLATE(false, 3, false, 1.0));
                this.ROTATION_LAYER_TEMPLATES.put("rotation-free-chance", new ROTATION_LAYER_TEMPLATE(false, 3, false, 0.5));
                this.TRANSPARENT_LAYER_TEMPLATES = new LinkedHashMap<String, TRANSPARENT_LAYER_TEMPLATE>();
                this.TRANSPARENT_LAYER_TEMPLATES.put("transparent", new TRANSPARENT_LAYER_TEMPLATE());
                this.TRANSPARENT_LAYER_TEMPLATES.put("almost-transparent", new TRANSPARENT_LAYER_TEMPLATE(200));
                this.MIRROR_LAYER_TEMPLATES = new LinkedHashMap<String, MIRROR_LAYER_TEMPLATE>();
                this.MIRROR_LAYER_TEMPLATES.put("mirror", new MIRROR_LAYER_TEMPLATE());
                this.COLORIZE_LAYER_TEMPLATES = new LinkedHashMap<String, COLORIZE_LAYER_TEMPLATE>();
                this.COLORIZE_LAYER_TEMPLATES.put("transparent-curve", new COLORIZE_LAYER_TEMPLATE());
                this.RANDOM_LAYER_TEMPLATES = new LinkedHashMap<String, RANDOM_LAYER_TEMPLATE>();
                this.RANDOM_LAYER_TEMPLATES.put("random-answers", new RANDOM_LAYER_TEMPLATE(Arrays.asList("code", "arithmetic", "number-spelling")));
                this.CODE_ANSWER_LAYER_TEMPLATES = new LinkedHashMap<String, CODE_ANSWER_LAYER_TEMPLATE>();
                this.CODE_ANSWER_LAYER_TEMPLATES.put("code", new CODE_ANSWER_LAYER_TEMPLATE());
                this.ARITHMETIC_ANSWER_LAYER_TEMPLATES = new LinkedHashMap<String, ARITHMETIC_ANSWER_LAYER_TEMPLATE>();
                this.ARITHMETIC_ANSWER_LAYER_TEMPLATES.put("arithmetic", new ARITHMETIC_ANSWER_LAYER_TEMPLATE());
                this.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES = new LinkedHashMap<String, NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE>();
                this.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES.put("number-spelling", new NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RENDER_LAYER_TEMPLATES)) {
                    return false;
                }
                RENDER_LAYER_TEMPLATES other = (RENDER_LAYER_TEMPLATES)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, IMAGE_LAYER_TEMPLATE> this$IMAGE_LAYER_TEMPLATES = this.IMAGE_LAYER_TEMPLATES;
                Map<String, IMAGE_LAYER_TEMPLATE> other$IMAGE_LAYER_TEMPLATES = other.IMAGE_LAYER_TEMPLATES;
                if (this$IMAGE_LAYER_TEMPLATES == null ? other$IMAGE_LAYER_TEMPLATES != null : !((Object)this$IMAGE_LAYER_TEMPLATES).equals(other$IMAGE_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, CURVE_LAYER_TEMPLATE> this$CURVE_LAYER_TEMPLATES = this.CURVE_LAYER_TEMPLATES;
                Map<String, CURVE_LAYER_TEMPLATE> other$CURVE_LAYER_TEMPLATES = other.CURVE_LAYER_TEMPLATES;
                if (this$CURVE_LAYER_TEMPLATES == null ? other$CURVE_LAYER_TEMPLATES != null : !((Object)this$CURVE_LAYER_TEMPLATES).equals(other$CURVE_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, GRADIENT_LAYER_TEMPLATE> this$GRADIENT_LAYER_TEMPLATES = this.GRADIENT_LAYER_TEMPLATES;
                Map<String, GRADIENT_LAYER_TEMPLATE> other$GRADIENT_LAYER_TEMPLATES = other.GRADIENT_LAYER_TEMPLATES;
                if (this$GRADIENT_LAYER_TEMPLATES == null ? other$GRADIENT_LAYER_TEMPLATES != null : !((Object)this$GRADIENT_LAYER_TEMPLATES).equals(other$GRADIENT_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, RIPPLE_LAYER_TEMPLATE> this$RIPPLE_LAYER_TEMPLATES = this.RIPPLE_LAYER_TEMPLATES;
                Map<String, RIPPLE_LAYER_TEMPLATE> other$RIPPLE_LAYER_TEMPLATES = other.RIPPLE_LAYER_TEMPLATES;
                if (this$RIPPLE_LAYER_TEMPLATES == null ? other$RIPPLE_LAYER_TEMPLATES != null : !((Object)this$RIPPLE_LAYER_TEMPLATES).equals(other$RIPPLE_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, NOISE_LAYER_TEMPLATE> this$NOISE_LAYER_TEMPLATES = this.NOISE_LAYER_TEMPLATES;
                Map<String, NOISE_LAYER_TEMPLATE> other$NOISE_LAYER_TEMPLATES = other.NOISE_LAYER_TEMPLATES;
                if (this$NOISE_LAYER_TEMPLATES == null ? other$NOISE_LAYER_TEMPLATES != null : !((Object)this$NOISE_LAYER_TEMPLATES).equals(other$NOISE_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, SPLITTER_LAYER_TEMPLATE> this$SPLITTER_LAYER_TEMPLATES = this.SPLITTER_LAYER_TEMPLATES;
                Map<String, SPLITTER_LAYER_TEMPLATE> other$SPLITTER_LAYER_TEMPLATES = other.SPLITTER_LAYER_TEMPLATES;
                if (this$SPLITTER_LAYER_TEMPLATES == null ? other$SPLITTER_LAYER_TEMPLATES != null : !((Object)this$SPLITTER_LAYER_TEMPLATES).equals(other$SPLITTER_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, ROTATION_LAYER_TEMPLATE> this$ROTATION_LAYER_TEMPLATES = this.ROTATION_LAYER_TEMPLATES;
                Map<String, ROTATION_LAYER_TEMPLATE> other$ROTATION_LAYER_TEMPLATES = other.ROTATION_LAYER_TEMPLATES;
                if (this$ROTATION_LAYER_TEMPLATES == null ? other$ROTATION_LAYER_TEMPLATES != null : !((Object)this$ROTATION_LAYER_TEMPLATES).equals(other$ROTATION_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, TRANSPARENT_LAYER_TEMPLATE> this$TRANSPARENT_LAYER_TEMPLATES = this.TRANSPARENT_LAYER_TEMPLATES;
                Map<String, TRANSPARENT_LAYER_TEMPLATE> other$TRANSPARENT_LAYER_TEMPLATES = other.TRANSPARENT_LAYER_TEMPLATES;
                if (this$TRANSPARENT_LAYER_TEMPLATES == null ? other$TRANSPARENT_LAYER_TEMPLATES != null : !((Object)this$TRANSPARENT_LAYER_TEMPLATES).equals(other$TRANSPARENT_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, MIRROR_LAYER_TEMPLATE> this$MIRROR_LAYER_TEMPLATES = this.MIRROR_LAYER_TEMPLATES;
                Map<String, MIRROR_LAYER_TEMPLATE> other$MIRROR_LAYER_TEMPLATES = other.MIRROR_LAYER_TEMPLATES;
                if (this$MIRROR_LAYER_TEMPLATES == null ? other$MIRROR_LAYER_TEMPLATES != null : !((Object)this$MIRROR_LAYER_TEMPLATES).equals(other$MIRROR_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, COLORIZE_LAYER_TEMPLATE> this$COLORIZE_LAYER_TEMPLATES = this.COLORIZE_LAYER_TEMPLATES;
                Map<String, COLORIZE_LAYER_TEMPLATE> other$COLORIZE_LAYER_TEMPLATES = other.COLORIZE_LAYER_TEMPLATES;
                if (this$COLORIZE_LAYER_TEMPLATES == null ? other$COLORIZE_LAYER_TEMPLATES != null : !((Object)this$COLORIZE_LAYER_TEMPLATES).equals(other$COLORIZE_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, RANDOM_LAYER_TEMPLATE> this$RANDOM_LAYER_TEMPLATES = this.RANDOM_LAYER_TEMPLATES;
                Map<String, RANDOM_LAYER_TEMPLATE> other$RANDOM_LAYER_TEMPLATES = other.RANDOM_LAYER_TEMPLATES;
                if (this$RANDOM_LAYER_TEMPLATES == null ? other$RANDOM_LAYER_TEMPLATES != null : !((Object)this$RANDOM_LAYER_TEMPLATES).equals(other$RANDOM_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, CODE_ANSWER_LAYER_TEMPLATE> this$CODE_ANSWER_LAYER_TEMPLATES = this.CODE_ANSWER_LAYER_TEMPLATES;
                Map<String, CODE_ANSWER_LAYER_TEMPLATE> other$CODE_ANSWER_LAYER_TEMPLATES = other.CODE_ANSWER_LAYER_TEMPLATES;
                if (this$CODE_ANSWER_LAYER_TEMPLATES == null ? other$CODE_ANSWER_LAYER_TEMPLATES != null : !((Object)this$CODE_ANSWER_LAYER_TEMPLATES).equals(other$CODE_ANSWER_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, ARITHMETIC_ANSWER_LAYER_TEMPLATE> this$ARITHMETIC_ANSWER_LAYER_TEMPLATES = this.ARITHMETIC_ANSWER_LAYER_TEMPLATES;
                Map<String, ARITHMETIC_ANSWER_LAYER_TEMPLATE> other$ARITHMETIC_ANSWER_LAYER_TEMPLATES = other.ARITHMETIC_ANSWER_LAYER_TEMPLATES;
                if (this$ARITHMETIC_ANSWER_LAYER_TEMPLATES == null ? other$ARITHMETIC_ANSWER_LAYER_TEMPLATES != null : !((Object)this$ARITHMETIC_ANSWER_LAYER_TEMPLATES).equals(other$ARITHMETIC_ANSWER_LAYER_TEMPLATES)) {
                    return false;
                }
                Map<String, NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE> this$NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES = this.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES;
                Map<String, NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE> other$NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES = other.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES;
                return !(this$NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES == null ? other$NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES != null : !((Object)this$NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES).equals(other$NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES));
            }

            protected boolean canEqual(Object other) {
                return other instanceof RENDER_LAYER_TEMPLATES;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, IMAGE_LAYER_TEMPLATE> $IMAGE_LAYER_TEMPLATES = this.IMAGE_LAYER_TEMPLATES;
                result = result * 59 + ($IMAGE_LAYER_TEMPLATES == null ? 43 : ((Object)$IMAGE_LAYER_TEMPLATES).hashCode());
                Map<String, CURVE_LAYER_TEMPLATE> $CURVE_LAYER_TEMPLATES = this.CURVE_LAYER_TEMPLATES;
                result = result * 59 + ($CURVE_LAYER_TEMPLATES == null ? 43 : ((Object)$CURVE_LAYER_TEMPLATES).hashCode());
                Map<String, GRADIENT_LAYER_TEMPLATE> $GRADIENT_LAYER_TEMPLATES = this.GRADIENT_LAYER_TEMPLATES;
                result = result * 59 + ($GRADIENT_LAYER_TEMPLATES == null ? 43 : ((Object)$GRADIENT_LAYER_TEMPLATES).hashCode());
                Map<String, RIPPLE_LAYER_TEMPLATE> $RIPPLE_LAYER_TEMPLATES = this.RIPPLE_LAYER_TEMPLATES;
                result = result * 59 + ($RIPPLE_LAYER_TEMPLATES == null ? 43 : ((Object)$RIPPLE_LAYER_TEMPLATES).hashCode());
                Map<String, NOISE_LAYER_TEMPLATE> $NOISE_LAYER_TEMPLATES = this.NOISE_LAYER_TEMPLATES;
                result = result * 59 + ($NOISE_LAYER_TEMPLATES == null ? 43 : ((Object)$NOISE_LAYER_TEMPLATES).hashCode());
                Map<String, SPLITTER_LAYER_TEMPLATE> $SPLITTER_LAYER_TEMPLATES = this.SPLITTER_LAYER_TEMPLATES;
                result = result * 59 + ($SPLITTER_LAYER_TEMPLATES == null ? 43 : ((Object)$SPLITTER_LAYER_TEMPLATES).hashCode());
                Map<String, ROTATION_LAYER_TEMPLATE> $ROTATION_LAYER_TEMPLATES = this.ROTATION_LAYER_TEMPLATES;
                result = result * 59 + ($ROTATION_LAYER_TEMPLATES == null ? 43 : ((Object)$ROTATION_LAYER_TEMPLATES).hashCode());
                Map<String, TRANSPARENT_LAYER_TEMPLATE> $TRANSPARENT_LAYER_TEMPLATES = this.TRANSPARENT_LAYER_TEMPLATES;
                result = result * 59 + ($TRANSPARENT_LAYER_TEMPLATES == null ? 43 : ((Object)$TRANSPARENT_LAYER_TEMPLATES).hashCode());
                Map<String, MIRROR_LAYER_TEMPLATE> $MIRROR_LAYER_TEMPLATES = this.MIRROR_LAYER_TEMPLATES;
                result = result * 59 + ($MIRROR_LAYER_TEMPLATES == null ? 43 : ((Object)$MIRROR_LAYER_TEMPLATES).hashCode());
                Map<String, COLORIZE_LAYER_TEMPLATE> $COLORIZE_LAYER_TEMPLATES = this.COLORIZE_LAYER_TEMPLATES;
                result = result * 59 + ($COLORIZE_LAYER_TEMPLATES == null ? 43 : ((Object)$COLORIZE_LAYER_TEMPLATES).hashCode());
                Map<String, RANDOM_LAYER_TEMPLATE> $RANDOM_LAYER_TEMPLATES = this.RANDOM_LAYER_TEMPLATES;
                result = result * 59 + ($RANDOM_LAYER_TEMPLATES == null ? 43 : ((Object)$RANDOM_LAYER_TEMPLATES).hashCode());
                Map<String, CODE_ANSWER_LAYER_TEMPLATE> $CODE_ANSWER_LAYER_TEMPLATES = this.CODE_ANSWER_LAYER_TEMPLATES;
                result = result * 59 + ($CODE_ANSWER_LAYER_TEMPLATES == null ? 43 : ((Object)$CODE_ANSWER_LAYER_TEMPLATES).hashCode());
                Map<String, ARITHMETIC_ANSWER_LAYER_TEMPLATE> $ARITHMETIC_ANSWER_LAYER_TEMPLATES = this.ARITHMETIC_ANSWER_LAYER_TEMPLATES;
                result = result * 59 + ($ARITHMETIC_ANSWER_LAYER_TEMPLATES == null ? 43 : ((Object)$ARITHMETIC_ANSWER_LAYER_TEMPLATES).hashCode());
                Map<String, NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE> $NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES = this.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES;
                result = result * 59 + ($NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES == null ? 43 : ((Object)$NUMBER_SPELLING_ANSWER_LAYER_TEMPLATES).hashCode());
                return result;
            }

            public static class IMAGE_LAYER_TEMPLATE {
                public FilePaths IMAGES = new FilePaths(Collections.singletonList("captcha_background.jpg"));
                public boolean IGNORE_TRANSPARENT = false;

                public IMAGE_LAYER_TEMPLATE() {
                }

                public IMAGE_LAYER_TEMPLATE(FilePaths IMAGES, boolean IGNORE_TRANSPARENT) {
                    this.IMAGES = IMAGES;
                    this.IGNORE_TRANSPARENT = IGNORE_TRANSPARENT;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof IMAGE_LAYER_TEMPLATE)) {
                        return false;
                    }
                    IMAGE_LAYER_TEMPLATE other = (IMAGE_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.IGNORE_TRANSPARENT != other.IGNORE_TRANSPARENT) {
                        return false;
                    }
                    FilePaths this$IMAGES = this.IMAGES;
                    FilePaths other$IMAGES = other.IMAGES;
                    return !(this$IMAGES == null ? other$IMAGES != null : !((Object)this$IMAGES).equals(other$IMAGES));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof IMAGE_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + (this.IGNORE_TRANSPARENT ? 79 : 97);
                    FilePaths $IMAGES = this.IMAGES;
                    result = result * 59 + ($IMAGES == null ? 43 : ((Object)$IMAGES).hashCode());
                    return result;
                }
            }

            public static class CURVE_LAYER_TEMPLATE {
                public int COUNT = 3;
                public double SIZE = 1.5;

                public CURVE_LAYER_TEMPLATE() {
                }

                public CURVE_LAYER_TEMPLATE(int COUNT, double SIZE) {
                    this.COUNT = COUNT;
                    this.SIZE = SIZE;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CURVE_LAYER_TEMPLATE)) {
                        return false;
                    }
                    CURVE_LAYER_TEMPLATE other = (CURVE_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.COUNT != other.COUNT) {
                        return false;
                    }
                    return Double.compare(this.SIZE, other.SIZE) == 0;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof CURVE_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.COUNT;
                    long $SIZE = Double.doubleToLongBits(this.SIZE);
                    result = result * 59 + (int)($SIZE >>> 32 ^ $SIZE);
                    return result;
                }
            }

            public static class GRADIENT_LAYER_TEMPLATE {
                public int MIN_COLORS = 4;
                public int MAX_COLORS = 4;
                public boolean IGNORE_TRANSPARENT = true;

                public GRADIENT_LAYER_TEMPLATE() {
                }

                public GRADIENT_LAYER_TEMPLATE(int MIN_COLORS, int MAX_COLORS, boolean IGNORE_TRANSPARENT) {
                    this.MIN_COLORS = MIN_COLORS;
                    this.MAX_COLORS = MAX_COLORS;
                    this.IGNORE_TRANSPARENT = IGNORE_TRANSPARENT;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof GRADIENT_LAYER_TEMPLATE)) {
                        return false;
                    }
                    GRADIENT_LAYER_TEMPLATE other = (GRADIENT_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.MIN_COLORS != other.MIN_COLORS) {
                        return false;
                    }
                    if (this.MAX_COLORS != other.MAX_COLORS) {
                        return false;
                    }
                    return this.IGNORE_TRANSPARENT == other.IGNORE_TRANSPARENT;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof GRADIENT_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.MIN_COLORS;
                    result = result * 59 + this.MAX_COLORS;
                    result = result * 59 + (this.IGNORE_TRANSPARENT ? 79 : 97);
                    return result;
                }
            }

            public static class RIPPLE_LAYER_TEMPLATE {
                public double WIDTH = 100.0;
                public double HEIGHT = 10.0;

                public RIPPLE_LAYER_TEMPLATE() {
                }

                public RIPPLE_LAYER_TEMPLATE(double WIDTH, double HEIGHT) {
                    this.WIDTH = WIDTH;
                    this.HEIGHT = HEIGHT;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RIPPLE_LAYER_TEMPLATE)) {
                        return false;
                    }
                    RIPPLE_LAYER_TEMPLATE other = (RIPPLE_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (Double.compare(this.WIDTH, other.WIDTH) != 0) {
                        return false;
                    }
                    return Double.compare(this.HEIGHT, other.HEIGHT) == 0;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof RIPPLE_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    long $WIDTH = Double.doubleToLongBits(this.WIDTH);
                    result = result * 59 + (int)($WIDTH >>> 32 ^ $WIDTH);
                    long $HEIGHT = Double.doubleToLongBits(this.HEIGHT);
                    result = result * 59 + (int)($HEIGHT >>> 32 ^ $HEIGHT);
                    return result;
                }
            }

            public static class NOISE_LAYER_TEMPLATE {
                public double PERCENT = 0.02;

                public NOISE_LAYER_TEMPLATE() {
                }

                public NOISE_LAYER_TEMPLATE(double PERCENT) {
                    this.PERCENT = PERCENT;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof NOISE_LAYER_TEMPLATE)) {
                        return false;
                    }
                    NOISE_LAYER_TEMPLATE other = (NOISE_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return Double.compare(this.PERCENT, other.PERCENT) == 0;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof NOISE_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    long $PERCENT = Double.doubleToLongBits(this.PERCENT);
                    result = result * 59 + (int)($PERCENT >>> 32 ^ $PERCENT);
                    return result;
                }
            }

            public static class SPLITTER_LAYER_TEMPLATE {
                public int CHUNK_COUNT = 2;

                public SPLITTER_LAYER_TEMPLATE() {
                }

                public SPLITTER_LAYER_TEMPLATE(int CHUNK_COUNT) {
                    this.CHUNK_COUNT = CHUNK_COUNT;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SPLITTER_LAYER_TEMPLATE)) {
                        return false;
                    }
                    SPLITTER_LAYER_TEMPLATE other = (SPLITTER_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.CHUNK_COUNT == other.CHUNK_COUNT;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof SPLITTER_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.CHUNK_COUNT;
                    return result;
                }
            }

            public static class ROTATION_LAYER_TEMPLATE {
                public boolean FRAMED = false;
                public int FRAMED_COUNT = 3;
                public boolean EXACT = true;
                public double CHANCE = 1.0;

                public ROTATION_LAYER_TEMPLATE() {
                }

                public ROTATION_LAYER_TEMPLATE(boolean FRAMED, int FRAMED_COUNT, boolean EXACT, double CHANCE) {
                    this.FRAMED = FRAMED;
                    this.FRAMED_COUNT = FRAMED_COUNT;
                    this.EXACT = EXACT;
                    this.CHANCE = CHANCE;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ROTATION_LAYER_TEMPLATE)) {
                        return false;
                    }
                    ROTATION_LAYER_TEMPLATE other = (ROTATION_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.FRAMED != other.FRAMED) {
                        return false;
                    }
                    if (this.FRAMED_COUNT != other.FRAMED_COUNT) {
                        return false;
                    }
                    if (this.EXACT != other.EXACT) {
                        return false;
                    }
                    return Double.compare(this.CHANCE, other.CHANCE) == 0;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ROTATION_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + (this.FRAMED ? 79 : 97);
                    result = result * 59 + this.FRAMED_COUNT;
                    result = result * 59 + (this.EXACT ? 79 : 97);
                    long $CHANCE = Double.doubleToLongBits(this.CHANCE);
                    result = result * 59 + (int)($CHANCE >>> 32 ^ $CHANCE);
                    return result;
                }
            }

            public static class TRANSPARENT_LAYER_TEMPLATE {
                public int ALPHA_LEVEL = 128;

                public TRANSPARENT_LAYER_TEMPLATE() {
                }

                public TRANSPARENT_LAYER_TEMPLATE(int ALPHA_LEVEL) {
                    this.ALPHA_LEVEL = ALPHA_LEVEL;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TRANSPARENT_LAYER_TEMPLATE)) {
                        return false;
                    }
                    TRANSPARENT_LAYER_TEMPLATE other = (TRANSPARENT_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.ALPHA_LEVEL == other.ALPHA_LEVEL;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof TRANSPARENT_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.ALPHA_LEVEL;
                    return result;
                }
            }

            public static class MIRROR_LAYER_TEMPLATE {
                public boolean HORIZONTAL = true;
                public double CHANCE = 0.5;

                public MIRROR_LAYER_TEMPLATE() {
                }

                public MIRROR_LAYER_TEMPLATE(boolean HORIZONTAL, double CHANCE) {
                    this.HORIZONTAL = HORIZONTAL;
                    this.CHANCE = CHANCE;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MIRROR_LAYER_TEMPLATE)) {
                        return false;
                    }
                    MIRROR_LAYER_TEMPLATE other = (MIRROR_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.HORIZONTAL != other.HORIZONTAL) {
                        return false;
                    }
                    return Double.compare(this.CHANCE, other.CHANCE) == 0;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof MIRROR_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + (this.HORIZONTAL ? 79 : 97);
                    long $CHANCE = Double.doubleToLongBits(this.CHANCE);
                    result = result * 59 + (int)($CHANCE >>> 32 ^ $CHANCE);
                    return result;
                }
            }

            public static class COLORIZE_LAYER_TEMPLATE {
                public String RENDER_LAYER = "complicated-curve";
                public int RED = 255;
                public int GREEN = 255;
                public int BLUE = 255;
                public int ALPHA = 0;

                public COLORIZE_LAYER_TEMPLATE() {
                }

                public COLORIZE_LAYER_TEMPLATE(String RENDER_LAYER, int RED, int GREEN, int BLUE, int ALPHA) {
                    this.RENDER_LAYER = RENDER_LAYER;
                    this.RED = RED;
                    this.GREEN = GREEN;
                    this.BLUE = BLUE;
                    this.ALPHA = ALPHA;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof COLORIZE_LAYER_TEMPLATE)) {
                        return false;
                    }
                    COLORIZE_LAYER_TEMPLATE other = (COLORIZE_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.RED != other.RED) {
                        return false;
                    }
                    if (this.GREEN != other.GREEN) {
                        return false;
                    }
                    if (this.BLUE != other.BLUE) {
                        return false;
                    }
                    if (this.ALPHA != other.ALPHA) {
                        return false;
                    }
                    String this$RENDER_LAYER = this.RENDER_LAYER;
                    String other$RENDER_LAYER = other.RENDER_LAYER;
                    return !(this$RENDER_LAYER == null ? other$RENDER_LAYER != null : !this$RENDER_LAYER.equals(other$RENDER_LAYER));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof COLORIZE_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.RED;
                    result = result * 59 + this.GREEN;
                    result = result * 59 + this.BLUE;
                    result = result * 59 + this.ALPHA;
                    String $RENDER_LAYER = this.RENDER_LAYER;
                    result = result * 59 + ($RENDER_LAYER == null ? 43 : $RENDER_LAYER.hashCode());
                    return result;
                }
            }

            public static class RANDOM_LAYER_TEMPLATE {
                @CollectionType(value=ArrayList.class)
                public List<String> LAYERS = Collections.emptyList();

                public RANDOM_LAYER_TEMPLATE() {
                }

                public RANDOM_LAYER_TEMPLATE(List<String> LAYERS) {
                    this.LAYERS = LAYERS;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RANDOM_LAYER_TEMPLATE)) {
                        return false;
                    }
                    RANDOM_LAYER_TEMPLATE other = (RANDOM_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<String> this$LAYERS = this.LAYERS;
                    List<String> other$LAYERS = other.LAYERS;
                    return !(this$LAYERS == null ? other$LAYERS != null : !((Object)this$LAYERS).equals(other$LAYERS));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof RANDOM_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<String> $LAYERS = this.LAYERS;
                    result = result * 59 + ($LAYERS == null ? 43 : ((Object)$LAYERS).hashCode());
                    return result;
                }
            }

            public static class CODE_ANSWER_LAYER_TEMPLATE {
                public DEFAULT_FONT_DATA DEFAULT_FONT_SANS_SERIF = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_SERIF = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_MONOSPACED = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG_INPUT = new DEFAULT_FONT_DATA();
                public FilePaths CUSTOM_FONTS = new FilePaths(Collections.emptyList());
                public int FONT_SIZE = 40;
                public int FONT_SPACE = 1;
                public int ROTATE_COUNT = 5;
                public boolean OUTLINE = true;
                public boolean GLYPH_RANDOM_HEIGHT = false;
                public String CHAR_SET = "1234567890abcdefABCDEF";
                public int MIN_LENGTH = 3;
                public int MAX_LENGTH = 5;

                public CODE_ANSWER_LAYER_TEMPLATE() {
                }

                public CODE_ANSWER_LAYER_TEMPLATE(DEFAULT_FONT_DATA DEFAULT_FONT_SANS_SERIF, DEFAULT_FONT_DATA DEFAULT_FONT_SERIF, DEFAULT_FONT_DATA DEFAULT_FONT_MONOSPACED, DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG, DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG_INPUT, FilePaths CUSTOM_FONTS, int FONT_SIZE, int FONT_SPACE, int ROTATE_COUNT, boolean OUTLINE, boolean GLYPH_RANDOM_HEIGHT, String CHAR_SET, int MIN_LENGTH, int MAX_LENGTH) {
                    this.DEFAULT_FONT_SANS_SERIF = DEFAULT_FONT_SANS_SERIF;
                    this.DEFAULT_FONT_SERIF = DEFAULT_FONT_SERIF;
                    this.DEFAULT_FONT_MONOSPACED = DEFAULT_FONT_MONOSPACED;
                    this.DEFAULT_FONT_DIALOG = DEFAULT_FONT_DIALOG;
                    this.DEFAULT_FONT_DIALOG_INPUT = DEFAULT_FONT_DIALOG_INPUT;
                    this.CUSTOM_FONTS = CUSTOM_FONTS;
                    this.FONT_SIZE = FONT_SIZE;
                    this.FONT_SPACE = FONT_SPACE;
                    this.ROTATE_COUNT = ROTATE_COUNT;
                    this.OUTLINE = OUTLINE;
                    this.GLYPH_RANDOM_HEIGHT = GLYPH_RANDOM_HEIGHT;
                    this.CHAR_SET = CHAR_SET;
                    this.MIN_LENGTH = MIN_LENGTH;
                    this.MAX_LENGTH = MAX_LENGTH;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CODE_ANSWER_LAYER_TEMPLATE)) {
                        return false;
                    }
                    CODE_ANSWER_LAYER_TEMPLATE other = (CODE_ANSWER_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.FONT_SIZE != other.FONT_SIZE) {
                        return false;
                    }
                    if (this.FONT_SPACE != other.FONT_SPACE) {
                        return false;
                    }
                    if (this.ROTATE_COUNT != other.ROTATE_COUNT) {
                        return false;
                    }
                    if (this.OUTLINE != other.OUTLINE) {
                        return false;
                    }
                    if (this.GLYPH_RANDOM_HEIGHT != other.GLYPH_RANDOM_HEIGHT) {
                        return false;
                    }
                    if (this.MIN_LENGTH != other.MIN_LENGTH) {
                        return false;
                    }
                    if (this.MAX_LENGTH != other.MAX_LENGTH) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_SANS_SERIF = this.DEFAULT_FONT_SANS_SERIF;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_SANS_SERIF = other.DEFAULT_FONT_SANS_SERIF;
                    if (this$DEFAULT_FONT_SANS_SERIF == null ? other$DEFAULT_FONT_SANS_SERIF != null : !((Object)this$DEFAULT_FONT_SANS_SERIF).equals(other$DEFAULT_FONT_SANS_SERIF)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_SERIF = this.DEFAULT_FONT_SERIF;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_SERIF = other.DEFAULT_FONT_SERIF;
                    if (this$DEFAULT_FONT_SERIF == null ? other$DEFAULT_FONT_SERIF != null : !((Object)this$DEFAULT_FONT_SERIF).equals(other$DEFAULT_FONT_SERIF)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_MONOSPACED = this.DEFAULT_FONT_MONOSPACED;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_MONOSPACED = other.DEFAULT_FONT_MONOSPACED;
                    if (this$DEFAULT_FONT_MONOSPACED == null ? other$DEFAULT_FONT_MONOSPACED != null : !((Object)this$DEFAULT_FONT_MONOSPACED).equals(other$DEFAULT_FONT_MONOSPACED)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_DIALOG = this.DEFAULT_FONT_DIALOG;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_DIALOG = other.DEFAULT_FONT_DIALOG;
                    if (this$DEFAULT_FONT_DIALOG == null ? other$DEFAULT_FONT_DIALOG != null : !((Object)this$DEFAULT_FONT_DIALOG).equals(other$DEFAULT_FONT_DIALOG)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_DIALOG_INPUT = this.DEFAULT_FONT_DIALOG_INPUT;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_DIALOG_INPUT = other.DEFAULT_FONT_DIALOG_INPUT;
                    if (this$DEFAULT_FONT_DIALOG_INPUT == null ? other$DEFAULT_FONT_DIALOG_INPUT != null : !((Object)this$DEFAULT_FONT_DIALOG_INPUT).equals(other$DEFAULT_FONT_DIALOG_INPUT)) {
                        return false;
                    }
                    FilePaths this$CUSTOM_FONTS = this.CUSTOM_FONTS;
                    FilePaths other$CUSTOM_FONTS = other.CUSTOM_FONTS;
                    if (this$CUSTOM_FONTS == null ? other$CUSTOM_FONTS != null : !((Object)this$CUSTOM_FONTS).equals(other$CUSTOM_FONTS)) {
                        return false;
                    }
                    String this$CHAR_SET = this.CHAR_SET;
                    String other$CHAR_SET = other.CHAR_SET;
                    return !(this$CHAR_SET == null ? other$CHAR_SET != null : !this$CHAR_SET.equals(other$CHAR_SET));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof CODE_ANSWER_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.FONT_SIZE;
                    result = result * 59 + this.FONT_SPACE;
                    result = result * 59 + this.ROTATE_COUNT;
                    result = result * 59 + (this.OUTLINE ? 79 : 97);
                    result = result * 59 + (this.GLYPH_RANDOM_HEIGHT ? 79 : 97);
                    result = result * 59 + this.MIN_LENGTH;
                    result = result * 59 + this.MAX_LENGTH;
                    DEFAULT_FONT_DATA $DEFAULT_FONT_SANS_SERIF = this.DEFAULT_FONT_SANS_SERIF;
                    result = result * 59 + ($DEFAULT_FONT_SANS_SERIF == null ? 43 : ((Object)$DEFAULT_FONT_SANS_SERIF).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_SERIF = this.DEFAULT_FONT_SERIF;
                    result = result * 59 + ($DEFAULT_FONT_SERIF == null ? 43 : ((Object)$DEFAULT_FONT_SERIF).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_MONOSPACED = this.DEFAULT_FONT_MONOSPACED;
                    result = result * 59 + ($DEFAULT_FONT_MONOSPACED == null ? 43 : ((Object)$DEFAULT_FONT_MONOSPACED).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_DIALOG = this.DEFAULT_FONT_DIALOG;
                    result = result * 59 + ($DEFAULT_FONT_DIALOG == null ? 43 : ((Object)$DEFAULT_FONT_DIALOG).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_DIALOG_INPUT = this.DEFAULT_FONT_DIALOG_INPUT;
                    result = result * 59 + ($DEFAULT_FONT_DIALOG_INPUT == null ? 43 : ((Object)$DEFAULT_FONT_DIALOG_INPUT).hashCode());
                    FilePaths $CUSTOM_FONTS = this.CUSTOM_FONTS;
                    result = result * 59 + ($CUSTOM_FONTS == null ? 43 : ((Object)$CUSTOM_FONTS).hashCode());
                    String $CHAR_SET = this.CHAR_SET;
                    result = result * 59 + ($CHAR_SET == null ? 43 : $CHAR_SET.hashCode());
                    return result;
                }
            }

            public static class ARITHMETIC_ANSWER_LAYER_TEMPLATE {
                public DEFAULT_FONT_DATA DEFAULT_FONT_SANS_SERIF = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_SERIF = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_MONOSPACED = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG_INPUT = new DEFAULT_FONT_DATA();
                public FilePaths CUSTOM_FONTS = new FilePaths(Collections.emptyList());
                public int FONT_SIZE = 40;
                public int FONT_SPACE = 1;
                public int ROTATE_COUNT = 5;
                public boolean OUTLINE = true;
                public boolean GLYPH_RANDOM_HEIGHT = false;
                public boolean ENABLED_ADDITION = true;
                public String ADDITION_CHARS = "+";
                public boolean ENABLED_SUBSTRACTION = true;
                public String SUBSTRACTION_CHARS = "-";
                public boolean ENABLED_MULTIPLICATION = false;
                public String MULTIPLICATION_CHARS = "*x\u00b7";
                public boolean ENABLED_DIVISION = false;
                public String DIVISION_CHARS = "/:";
                public int MAX_ARITHMETIC_NUMBER = 9;
                public String ARITHMETIC_EXAMPLE = "%first%%operator%%second%=?";

                public ARITHMETIC_ANSWER_LAYER_TEMPLATE() {
                }

                public ARITHMETIC_ANSWER_LAYER_TEMPLATE(DEFAULT_FONT_DATA DEFAULT_FONT_SANS_SERIF, DEFAULT_FONT_DATA DEFAULT_FONT_SERIF, DEFAULT_FONT_DATA DEFAULT_FONT_MONOSPACED, DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG, DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG_INPUT, FilePaths CUSTOM_FONTS, int FONT_SIZE, int FONT_SPACE, int ROTATE_COUNT, boolean OUTLINE, boolean GLYPH_RANDOM_HEIGHT, boolean ENABLED_ADDITION, String ADDITION_CHARS, boolean ENABLED_SUBSTRACTION, String SUBSTRACTION_CHARS, boolean ENABLED_MULTIPLICATION, String MULTIPLICATION_CHARS, boolean ENABLED_DIVISION, String DIVISION_CHARS, int MAX_ARITHMETIC_NUMBER, String ARITHMETIC_EXAMPLE) {
                    this.DEFAULT_FONT_SANS_SERIF = DEFAULT_FONT_SANS_SERIF;
                    this.DEFAULT_FONT_SERIF = DEFAULT_FONT_SERIF;
                    this.DEFAULT_FONT_MONOSPACED = DEFAULT_FONT_MONOSPACED;
                    this.DEFAULT_FONT_DIALOG = DEFAULT_FONT_DIALOG;
                    this.DEFAULT_FONT_DIALOG_INPUT = DEFAULT_FONT_DIALOG_INPUT;
                    this.CUSTOM_FONTS = CUSTOM_FONTS;
                    this.FONT_SIZE = FONT_SIZE;
                    this.FONT_SPACE = FONT_SPACE;
                    this.ROTATE_COUNT = ROTATE_COUNT;
                    this.OUTLINE = OUTLINE;
                    this.GLYPH_RANDOM_HEIGHT = GLYPH_RANDOM_HEIGHT;
                    this.ENABLED_ADDITION = ENABLED_ADDITION;
                    this.ADDITION_CHARS = ADDITION_CHARS;
                    this.ENABLED_SUBSTRACTION = ENABLED_SUBSTRACTION;
                    this.SUBSTRACTION_CHARS = SUBSTRACTION_CHARS;
                    this.ENABLED_MULTIPLICATION = ENABLED_MULTIPLICATION;
                    this.MULTIPLICATION_CHARS = MULTIPLICATION_CHARS;
                    this.ENABLED_DIVISION = ENABLED_DIVISION;
                    this.DIVISION_CHARS = DIVISION_CHARS;
                    this.MAX_ARITHMETIC_NUMBER = MAX_ARITHMETIC_NUMBER;
                    this.ARITHMETIC_EXAMPLE = ARITHMETIC_EXAMPLE;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ARITHMETIC_ANSWER_LAYER_TEMPLATE)) {
                        return false;
                    }
                    ARITHMETIC_ANSWER_LAYER_TEMPLATE other = (ARITHMETIC_ANSWER_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.FONT_SIZE != other.FONT_SIZE) {
                        return false;
                    }
                    if (this.FONT_SPACE != other.FONT_SPACE) {
                        return false;
                    }
                    if (this.ROTATE_COUNT != other.ROTATE_COUNT) {
                        return false;
                    }
                    if (this.OUTLINE != other.OUTLINE) {
                        return false;
                    }
                    if (this.GLYPH_RANDOM_HEIGHT != other.GLYPH_RANDOM_HEIGHT) {
                        return false;
                    }
                    if (this.ENABLED_ADDITION != other.ENABLED_ADDITION) {
                        return false;
                    }
                    if (this.ENABLED_SUBSTRACTION != other.ENABLED_SUBSTRACTION) {
                        return false;
                    }
                    if (this.ENABLED_MULTIPLICATION != other.ENABLED_MULTIPLICATION) {
                        return false;
                    }
                    if (this.ENABLED_DIVISION != other.ENABLED_DIVISION) {
                        return false;
                    }
                    if (this.MAX_ARITHMETIC_NUMBER != other.MAX_ARITHMETIC_NUMBER) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_SANS_SERIF = this.DEFAULT_FONT_SANS_SERIF;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_SANS_SERIF = other.DEFAULT_FONT_SANS_SERIF;
                    if (this$DEFAULT_FONT_SANS_SERIF == null ? other$DEFAULT_FONT_SANS_SERIF != null : !((Object)this$DEFAULT_FONT_SANS_SERIF).equals(other$DEFAULT_FONT_SANS_SERIF)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_SERIF = this.DEFAULT_FONT_SERIF;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_SERIF = other.DEFAULT_FONT_SERIF;
                    if (this$DEFAULT_FONT_SERIF == null ? other$DEFAULT_FONT_SERIF != null : !((Object)this$DEFAULT_FONT_SERIF).equals(other$DEFAULT_FONT_SERIF)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_MONOSPACED = this.DEFAULT_FONT_MONOSPACED;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_MONOSPACED = other.DEFAULT_FONT_MONOSPACED;
                    if (this$DEFAULT_FONT_MONOSPACED == null ? other$DEFAULT_FONT_MONOSPACED != null : !((Object)this$DEFAULT_FONT_MONOSPACED).equals(other$DEFAULT_FONT_MONOSPACED)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_DIALOG = this.DEFAULT_FONT_DIALOG;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_DIALOG = other.DEFAULT_FONT_DIALOG;
                    if (this$DEFAULT_FONT_DIALOG == null ? other$DEFAULT_FONT_DIALOG != null : !((Object)this$DEFAULT_FONT_DIALOG).equals(other$DEFAULT_FONT_DIALOG)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_DIALOG_INPUT = this.DEFAULT_FONT_DIALOG_INPUT;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_DIALOG_INPUT = other.DEFAULT_FONT_DIALOG_INPUT;
                    if (this$DEFAULT_FONT_DIALOG_INPUT == null ? other$DEFAULT_FONT_DIALOG_INPUT != null : !((Object)this$DEFAULT_FONT_DIALOG_INPUT).equals(other$DEFAULT_FONT_DIALOG_INPUT)) {
                        return false;
                    }
                    FilePaths this$CUSTOM_FONTS = this.CUSTOM_FONTS;
                    FilePaths other$CUSTOM_FONTS = other.CUSTOM_FONTS;
                    if (this$CUSTOM_FONTS == null ? other$CUSTOM_FONTS != null : !((Object)this$CUSTOM_FONTS).equals(other$CUSTOM_FONTS)) {
                        return false;
                    }
                    String this$ADDITION_CHARS = this.ADDITION_CHARS;
                    String other$ADDITION_CHARS = other.ADDITION_CHARS;
                    if (this$ADDITION_CHARS == null ? other$ADDITION_CHARS != null : !this$ADDITION_CHARS.equals(other$ADDITION_CHARS)) {
                        return false;
                    }
                    String this$SUBSTRACTION_CHARS = this.SUBSTRACTION_CHARS;
                    String other$SUBSTRACTION_CHARS = other.SUBSTRACTION_CHARS;
                    if (this$SUBSTRACTION_CHARS == null ? other$SUBSTRACTION_CHARS != null : !this$SUBSTRACTION_CHARS.equals(other$SUBSTRACTION_CHARS)) {
                        return false;
                    }
                    String this$MULTIPLICATION_CHARS = this.MULTIPLICATION_CHARS;
                    String other$MULTIPLICATION_CHARS = other.MULTIPLICATION_CHARS;
                    if (this$MULTIPLICATION_CHARS == null ? other$MULTIPLICATION_CHARS != null : !this$MULTIPLICATION_CHARS.equals(other$MULTIPLICATION_CHARS)) {
                        return false;
                    }
                    String this$DIVISION_CHARS = this.DIVISION_CHARS;
                    String other$DIVISION_CHARS = other.DIVISION_CHARS;
                    if (this$DIVISION_CHARS == null ? other$DIVISION_CHARS != null : !this$DIVISION_CHARS.equals(other$DIVISION_CHARS)) {
                        return false;
                    }
                    String this$ARITHMETIC_EXAMPLE = this.ARITHMETIC_EXAMPLE;
                    String other$ARITHMETIC_EXAMPLE = other.ARITHMETIC_EXAMPLE;
                    return !(this$ARITHMETIC_EXAMPLE == null ? other$ARITHMETIC_EXAMPLE != null : !this$ARITHMETIC_EXAMPLE.equals(other$ARITHMETIC_EXAMPLE));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ARITHMETIC_ANSWER_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.FONT_SIZE;
                    result = result * 59 + this.FONT_SPACE;
                    result = result * 59 + this.ROTATE_COUNT;
                    result = result * 59 + (this.OUTLINE ? 79 : 97);
                    result = result * 59 + (this.GLYPH_RANDOM_HEIGHT ? 79 : 97);
                    result = result * 59 + (this.ENABLED_ADDITION ? 79 : 97);
                    result = result * 59 + (this.ENABLED_SUBSTRACTION ? 79 : 97);
                    result = result * 59 + (this.ENABLED_MULTIPLICATION ? 79 : 97);
                    result = result * 59 + (this.ENABLED_DIVISION ? 79 : 97);
                    result = result * 59 + this.MAX_ARITHMETIC_NUMBER;
                    DEFAULT_FONT_DATA $DEFAULT_FONT_SANS_SERIF = this.DEFAULT_FONT_SANS_SERIF;
                    result = result * 59 + ($DEFAULT_FONT_SANS_SERIF == null ? 43 : ((Object)$DEFAULT_FONT_SANS_SERIF).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_SERIF = this.DEFAULT_FONT_SERIF;
                    result = result * 59 + ($DEFAULT_FONT_SERIF == null ? 43 : ((Object)$DEFAULT_FONT_SERIF).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_MONOSPACED = this.DEFAULT_FONT_MONOSPACED;
                    result = result * 59 + ($DEFAULT_FONT_MONOSPACED == null ? 43 : ((Object)$DEFAULT_FONT_MONOSPACED).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_DIALOG = this.DEFAULT_FONT_DIALOG;
                    result = result * 59 + ($DEFAULT_FONT_DIALOG == null ? 43 : ((Object)$DEFAULT_FONT_DIALOG).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_DIALOG_INPUT = this.DEFAULT_FONT_DIALOG_INPUT;
                    result = result * 59 + ($DEFAULT_FONT_DIALOG_INPUT == null ? 43 : ((Object)$DEFAULT_FONT_DIALOG_INPUT).hashCode());
                    FilePaths $CUSTOM_FONTS = this.CUSTOM_FONTS;
                    result = result * 59 + ($CUSTOM_FONTS == null ? 43 : ((Object)$CUSTOM_FONTS).hashCode());
                    String $ADDITION_CHARS = this.ADDITION_CHARS;
                    result = result * 59 + ($ADDITION_CHARS == null ? 43 : $ADDITION_CHARS.hashCode());
                    String $SUBSTRACTION_CHARS = this.SUBSTRACTION_CHARS;
                    result = result * 59 + ($SUBSTRACTION_CHARS == null ? 43 : $SUBSTRACTION_CHARS.hashCode());
                    String $MULTIPLICATION_CHARS = this.MULTIPLICATION_CHARS;
                    result = result * 59 + ($MULTIPLICATION_CHARS == null ? 43 : $MULTIPLICATION_CHARS.hashCode());
                    String $DIVISION_CHARS = this.DIVISION_CHARS;
                    result = result * 59 + ($DIVISION_CHARS == null ? 43 : $DIVISION_CHARS.hashCode());
                    String $ARITHMETIC_EXAMPLE = this.ARITHMETIC_EXAMPLE;
                    result = result * 59 + ($ARITHMETIC_EXAMPLE == null ? 43 : $ARITHMETIC_EXAMPLE.hashCode());
                    return result;
                }
            }

            public static class NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE {
                public DEFAULT_FONT_DATA DEFAULT_FONT_SANS_SERIF = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_SERIF = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_MONOSPACED = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG = new DEFAULT_FONT_DATA();
                public DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG_INPUT = new DEFAULT_FONT_DATA();
                public FilePaths CUSTOM_FONTS = new FilePaths(Collections.emptyList());
                public int FONT_SIZE = 35;
                public int FONT_SPACE = 1;
                public int ROTATE_COUNT = 5;
                public boolean OUTLINE = true;
                public HUNDREDS HUNDREDS = new HUNDREDS();
                public TENTHS TENTHS = new TENTHS();
                public UNITS UNITS = new UNITS();
                public EXCEPTIONS EXCEPTIONS = new EXCEPTIONS();

                public NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE() {
                }

                public NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE(DEFAULT_FONT_DATA DEFAULT_FONT_SANS_SERIF, DEFAULT_FONT_DATA DEFAULT_FONT_SERIF, DEFAULT_FONT_DATA DEFAULT_FONT_MONOSPACED, DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG, DEFAULT_FONT_DATA DEFAULT_FONT_DIALOG_INPUT, FilePaths CUSTOM_FONTS, int FONT_SIZE, int FONT_SPACE, int ROTATE_COUNT, boolean OUTLINE, HUNDREDS HUNDREDS2, TENTHS TENTHS2, UNITS UNITS2, EXCEPTIONS EXCEPTIONS2) {
                    this.DEFAULT_FONT_SANS_SERIF = DEFAULT_FONT_SANS_SERIF;
                    this.DEFAULT_FONT_SERIF = DEFAULT_FONT_SERIF;
                    this.DEFAULT_FONT_MONOSPACED = DEFAULT_FONT_MONOSPACED;
                    this.DEFAULT_FONT_DIALOG = DEFAULT_FONT_DIALOG;
                    this.DEFAULT_FONT_DIALOG_INPUT = DEFAULT_FONT_DIALOG_INPUT;
                    this.CUSTOM_FONTS = CUSTOM_FONTS;
                    this.FONT_SIZE = FONT_SIZE;
                    this.FONT_SPACE = FONT_SPACE;
                    this.ROTATE_COUNT = ROTATE_COUNT;
                    this.OUTLINE = OUTLINE;
                    this.HUNDREDS = HUNDREDS2;
                    this.TENTHS = TENTHS2;
                    this.UNITS = UNITS2;
                    this.EXCEPTIONS = EXCEPTIONS2;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE)) {
                        return false;
                    }
                    NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE other = (NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.FONT_SIZE != other.FONT_SIZE) {
                        return false;
                    }
                    if (this.FONT_SPACE != other.FONT_SPACE) {
                        return false;
                    }
                    if (this.ROTATE_COUNT != other.ROTATE_COUNT) {
                        return false;
                    }
                    if (this.OUTLINE != other.OUTLINE) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_SANS_SERIF = this.DEFAULT_FONT_SANS_SERIF;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_SANS_SERIF = other.DEFAULT_FONT_SANS_SERIF;
                    if (this$DEFAULT_FONT_SANS_SERIF == null ? other$DEFAULT_FONT_SANS_SERIF != null : !((Object)this$DEFAULT_FONT_SANS_SERIF).equals(other$DEFAULT_FONT_SANS_SERIF)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_SERIF = this.DEFAULT_FONT_SERIF;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_SERIF = other.DEFAULT_FONT_SERIF;
                    if (this$DEFAULT_FONT_SERIF == null ? other$DEFAULT_FONT_SERIF != null : !((Object)this$DEFAULT_FONT_SERIF).equals(other$DEFAULT_FONT_SERIF)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_MONOSPACED = this.DEFAULT_FONT_MONOSPACED;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_MONOSPACED = other.DEFAULT_FONT_MONOSPACED;
                    if (this$DEFAULT_FONT_MONOSPACED == null ? other$DEFAULT_FONT_MONOSPACED != null : !((Object)this$DEFAULT_FONT_MONOSPACED).equals(other$DEFAULT_FONT_MONOSPACED)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_DIALOG = this.DEFAULT_FONT_DIALOG;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_DIALOG = other.DEFAULT_FONT_DIALOG;
                    if (this$DEFAULT_FONT_DIALOG == null ? other$DEFAULT_FONT_DIALOG != null : !((Object)this$DEFAULT_FONT_DIALOG).equals(other$DEFAULT_FONT_DIALOG)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA this$DEFAULT_FONT_DIALOG_INPUT = this.DEFAULT_FONT_DIALOG_INPUT;
                    DEFAULT_FONT_DATA other$DEFAULT_FONT_DIALOG_INPUT = other.DEFAULT_FONT_DIALOG_INPUT;
                    if (this$DEFAULT_FONT_DIALOG_INPUT == null ? other$DEFAULT_FONT_DIALOG_INPUT != null : !((Object)this$DEFAULT_FONT_DIALOG_INPUT).equals(other$DEFAULT_FONT_DIALOG_INPUT)) {
                        return false;
                    }
                    FilePaths this$CUSTOM_FONTS = this.CUSTOM_FONTS;
                    FilePaths other$CUSTOM_FONTS = other.CUSTOM_FONTS;
                    if (this$CUSTOM_FONTS == null ? other$CUSTOM_FONTS != null : !((Object)this$CUSTOM_FONTS).equals(other$CUSTOM_FONTS)) {
                        return false;
                    }
                    HUNDREDS this$HUNDREDS = this.HUNDREDS;
                    HUNDREDS other$HUNDREDS = other.HUNDREDS;
                    if (this$HUNDREDS == null ? other$HUNDREDS != null : !((Object)this$HUNDREDS).equals(other$HUNDREDS)) {
                        return false;
                    }
                    TENTHS this$TENTHS = this.TENTHS;
                    TENTHS other$TENTHS = other.TENTHS;
                    if (this$TENTHS == null ? other$TENTHS != null : !((Object)this$TENTHS).equals(other$TENTHS)) {
                        return false;
                    }
                    UNITS this$UNITS = this.UNITS;
                    UNITS other$UNITS = other.UNITS;
                    if (this$UNITS == null ? other$UNITS != null : !((Object)this$UNITS).equals(other$UNITS)) {
                        return false;
                    }
                    EXCEPTIONS this$EXCEPTIONS = this.EXCEPTIONS;
                    EXCEPTIONS other$EXCEPTIONS = other.EXCEPTIONS;
                    return !(this$EXCEPTIONS == null ? other$EXCEPTIONS != null : !((Object)this$EXCEPTIONS).equals(other$EXCEPTIONS));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.FONT_SIZE;
                    result = result * 59 + this.FONT_SPACE;
                    result = result * 59 + this.ROTATE_COUNT;
                    result = result * 59 + (this.OUTLINE ? 79 : 97);
                    DEFAULT_FONT_DATA $DEFAULT_FONT_SANS_SERIF = this.DEFAULT_FONT_SANS_SERIF;
                    result = result * 59 + ($DEFAULT_FONT_SANS_SERIF == null ? 43 : ((Object)$DEFAULT_FONT_SANS_SERIF).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_SERIF = this.DEFAULT_FONT_SERIF;
                    result = result * 59 + ($DEFAULT_FONT_SERIF == null ? 43 : ((Object)$DEFAULT_FONT_SERIF).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_MONOSPACED = this.DEFAULT_FONT_MONOSPACED;
                    result = result * 59 + ($DEFAULT_FONT_MONOSPACED == null ? 43 : ((Object)$DEFAULT_FONT_MONOSPACED).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_DIALOG = this.DEFAULT_FONT_DIALOG;
                    result = result * 59 + ($DEFAULT_FONT_DIALOG == null ? 43 : ((Object)$DEFAULT_FONT_DIALOG).hashCode());
                    DEFAULT_FONT_DATA $DEFAULT_FONT_DIALOG_INPUT = this.DEFAULT_FONT_DIALOG_INPUT;
                    result = result * 59 + ($DEFAULT_FONT_DIALOG_INPUT == null ? 43 : ((Object)$DEFAULT_FONT_DIALOG_INPUT).hashCode());
                    FilePaths $CUSTOM_FONTS = this.CUSTOM_FONTS;
                    result = result * 59 + ($CUSTOM_FONTS == null ? 43 : ((Object)$CUSTOM_FONTS).hashCode());
                    HUNDREDS $HUNDREDS = this.HUNDREDS;
                    result = result * 59 + ($HUNDREDS == null ? 43 : ((Object)$HUNDREDS).hashCode());
                    TENTHS $TENTHS = this.TENTHS;
                    result = result * 59 + ($TENTHS == null ? 43 : ((Object)$TENTHS).hashCode());
                    UNITS $UNITS = this.UNITS;
                    result = result * 59 + ($UNITS == null ? 43 : ((Object)$UNITS).hashCode());
                    EXCEPTIONS $EXCEPTIONS = this.EXCEPTIONS;
                    result = result * 59 + ($EXCEPTIONS == null ? 43 : ((Object)$EXCEPTIONS).hashCode());
                    return result;
                }

                public static class HUNDREDS {
                    public String ONE = "one hundred";
                    public String TWO = "two hundred";
                    public String THERE = "three hundred";
                    public String FOUR = "four hundred";
                    public String FIVE = "five hundred";
                    public String SIX = "six hundred";
                    public String SEVEN = "seven hundred";
                    public String EIGHT = "eight hundred";
                    public String NINE = "nine hundred";

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof HUNDREDS)) {
                            return false;
                        }
                        HUNDREDS other = (HUNDREDS)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$ONE = this.ONE;
                        String other$ONE = other.ONE;
                        if (this$ONE == null ? other$ONE != null : !this$ONE.equals(other$ONE)) {
                            return false;
                        }
                        String this$TWO = this.TWO;
                        String other$TWO = other.TWO;
                        if (this$TWO == null ? other$TWO != null : !this$TWO.equals(other$TWO)) {
                            return false;
                        }
                        String this$THERE = this.THERE;
                        String other$THERE = other.THERE;
                        if (this$THERE == null ? other$THERE != null : !this$THERE.equals(other$THERE)) {
                            return false;
                        }
                        String this$FOUR = this.FOUR;
                        String other$FOUR = other.FOUR;
                        if (this$FOUR == null ? other$FOUR != null : !this$FOUR.equals(other$FOUR)) {
                            return false;
                        }
                        String this$FIVE = this.FIVE;
                        String other$FIVE = other.FIVE;
                        if (this$FIVE == null ? other$FIVE != null : !this$FIVE.equals(other$FIVE)) {
                            return false;
                        }
                        String this$SIX = this.SIX;
                        String other$SIX = other.SIX;
                        if (this$SIX == null ? other$SIX != null : !this$SIX.equals(other$SIX)) {
                            return false;
                        }
                        String this$SEVEN = this.SEVEN;
                        String other$SEVEN = other.SEVEN;
                        if (this$SEVEN == null ? other$SEVEN != null : !this$SEVEN.equals(other$SEVEN)) {
                            return false;
                        }
                        String this$EIGHT = this.EIGHT;
                        String other$EIGHT = other.EIGHT;
                        if (this$EIGHT == null ? other$EIGHT != null : !this$EIGHT.equals(other$EIGHT)) {
                            return false;
                        }
                        String this$NINE = this.NINE;
                        String other$NINE = other.NINE;
                        return !(this$NINE == null ? other$NINE != null : !this$NINE.equals(other$NINE));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof HUNDREDS;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $ONE = this.ONE;
                        result = result * 59 + ($ONE == null ? 43 : $ONE.hashCode());
                        String $TWO = this.TWO;
                        result = result * 59 + ($TWO == null ? 43 : $TWO.hashCode());
                        String $THERE = this.THERE;
                        result = result * 59 + ($THERE == null ? 43 : $THERE.hashCode());
                        String $FOUR = this.FOUR;
                        result = result * 59 + ($FOUR == null ? 43 : $FOUR.hashCode());
                        String $FIVE = this.FIVE;
                        result = result * 59 + ($FIVE == null ? 43 : $FIVE.hashCode());
                        String $SIX = this.SIX;
                        result = result * 59 + ($SIX == null ? 43 : $SIX.hashCode());
                        String $SEVEN = this.SEVEN;
                        result = result * 59 + ($SEVEN == null ? 43 : $SEVEN.hashCode());
                        String $EIGHT = this.EIGHT;
                        result = result * 59 + ($EIGHT == null ? 43 : $EIGHT.hashCode());
                        String $NINE = this.NINE;
                        result = result * 59 + ($NINE == null ? 43 : $NINE.hashCode());
                        return result;
                    }
                }

                public static class TENTHS {
                    public String ONE = "ten";
                    public String TWO = "twenty";
                    public String THERE = "thirty";
                    public String FOUR = "forty";
                    public String FIVE = "fifty";
                    public String SIX = "sixty";
                    public String SEVEN = "seventy";
                    public String EIGHT = "eighty";
                    public String NINE = "ninety";

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof TENTHS)) {
                            return false;
                        }
                        TENTHS other = (TENTHS)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$ONE = this.ONE;
                        String other$ONE = other.ONE;
                        if (this$ONE == null ? other$ONE != null : !this$ONE.equals(other$ONE)) {
                            return false;
                        }
                        String this$TWO = this.TWO;
                        String other$TWO = other.TWO;
                        if (this$TWO == null ? other$TWO != null : !this$TWO.equals(other$TWO)) {
                            return false;
                        }
                        String this$THERE = this.THERE;
                        String other$THERE = other.THERE;
                        if (this$THERE == null ? other$THERE != null : !this$THERE.equals(other$THERE)) {
                            return false;
                        }
                        String this$FOUR = this.FOUR;
                        String other$FOUR = other.FOUR;
                        if (this$FOUR == null ? other$FOUR != null : !this$FOUR.equals(other$FOUR)) {
                            return false;
                        }
                        String this$FIVE = this.FIVE;
                        String other$FIVE = other.FIVE;
                        if (this$FIVE == null ? other$FIVE != null : !this$FIVE.equals(other$FIVE)) {
                            return false;
                        }
                        String this$SIX = this.SIX;
                        String other$SIX = other.SIX;
                        if (this$SIX == null ? other$SIX != null : !this$SIX.equals(other$SIX)) {
                            return false;
                        }
                        String this$SEVEN = this.SEVEN;
                        String other$SEVEN = other.SEVEN;
                        if (this$SEVEN == null ? other$SEVEN != null : !this$SEVEN.equals(other$SEVEN)) {
                            return false;
                        }
                        String this$EIGHT = this.EIGHT;
                        String other$EIGHT = other.EIGHT;
                        if (this$EIGHT == null ? other$EIGHT != null : !this$EIGHT.equals(other$EIGHT)) {
                            return false;
                        }
                        String this$NINE = this.NINE;
                        String other$NINE = other.NINE;
                        return !(this$NINE == null ? other$NINE != null : !this$NINE.equals(other$NINE));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof TENTHS;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $ONE = this.ONE;
                        result = result * 59 + ($ONE == null ? 43 : $ONE.hashCode());
                        String $TWO = this.TWO;
                        result = result * 59 + ($TWO == null ? 43 : $TWO.hashCode());
                        String $THERE = this.THERE;
                        result = result * 59 + ($THERE == null ? 43 : $THERE.hashCode());
                        String $FOUR = this.FOUR;
                        result = result * 59 + ($FOUR == null ? 43 : $FOUR.hashCode());
                        String $FIVE = this.FIVE;
                        result = result * 59 + ($FIVE == null ? 43 : $FIVE.hashCode());
                        String $SIX = this.SIX;
                        result = result * 59 + ($SIX == null ? 43 : $SIX.hashCode());
                        String $SEVEN = this.SEVEN;
                        result = result * 59 + ($SEVEN == null ? 43 : $SEVEN.hashCode());
                        String $EIGHT = this.EIGHT;
                        result = result * 59 + ($EIGHT == null ? 43 : $EIGHT.hashCode());
                        String $NINE = this.NINE;
                        result = result * 59 + ($NINE == null ? 43 : $NINE.hashCode());
                        return result;
                    }
                }

                public static class UNITS {
                    public String ONE = "one";
                    public String TWO = "two";
                    public String THERE = "there";
                    public String FOUR = "four";
                    public String FIVE = "five";
                    public String SIX = "six";
                    public String SEVEN = "seven";
                    public String EIGHT = "eight";
                    public String NINE = "nine";

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof UNITS)) {
                            return false;
                        }
                        UNITS other = (UNITS)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$ONE = this.ONE;
                        String other$ONE = other.ONE;
                        if (this$ONE == null ? other$ONE != null : !this$ONE.equals(other$ONE)) {
                            return false;
                        }
                        String this$TWO = this.TWO;
                        String other$TWO = other.TWO;
                        if (this$TWO == null ? other$TWO != null : !this$TWO.equals(other$TWO)) {
                            return false;
                        }
                        String this$THERE = this.THERE;
                        String other$THERE = other.THERE;
                        if (this$THERE == null ? other$THERE != null : !this$THERE.equals(other$THERE)) {
                            return false;
                        }
                        String this$FOUR = this.FOUR;
                        String other$FOUR = other.FOUR;
                        if (this$FOUR == null ? other$FOUR != null : !this$FOUR.equals(other$FOUR)) {
                            return false;
                        }
                        String this$FIVE = this.FIVE;
                        String other$FIVE = other.FIVE;
                        if (this$FIVE == null ? other$FIVE != null : !this$FIVE.equals(other$FIVE)) {
                            return false;
                        }
                        String this$SIX = this.SIX;
                        String other$SIX = other.SIX;
                        if (this$SIX == null ? other$SIX != null : !this$SIX.equals(other$SIX)) {
                            return false;
                        }
                        String this$SEVEN = this.SEVEN;
                        String other$SEVEN = other.SEVEN;
                        if (this$SEVEN == null ? other$SEVEN != null : !this$SEVEN.equals(other$SEVEN)) {
                            return false;
                        }
                        String this$EIGHT = this.EIGHT;
                        String other$EIGHT = other.EIGHT;
                        if (this$EIGHT == null ? other$EIGHT != null : !this$EIGHT.equals(other$EIGHT)) {
                            return false;
                        }
                        String this$NINE = this.NINE;
                        String other$NINE = other.NINE;
                        return !(this$NINE == null ? other$NINE != null : !this$NINE.equals(other$NINE));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof UNITS;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $ONE = this.ONE;
                        result = result * 59 + ($ONE == null ? 43 : $ONE.hashCode());
                        String $TWO = this.TWO;
                        result = result * 59 + ($TWO == null ? 43 : $TWO.hashCode());
                        String $THERE = this.THERE;
                        result = result * 59 + ($THERE == null ? 43 : $THERE.hashCode());
                        String $FOUR = this.FOUR;
                        result = result * 59 + ($FOUR == null ? 43 : $FOUR.hashCode());
                        String $FIVE = this.FIVE;
                        result = result * 59 + ($FIVE == null ? 43 : $FIVE.hashCode());
                        String $SIX = this.SIX;
                        result = result * 59 + ($SIX == null ? 43 : $SIX.hashCode());
                        String $SEVEN = this.SEVEN;
                        result = result * 59 + ($SEVEN == null ? 43 : $SEVEN.hashCode());
                        String $EIGHT = this.EIGHT;
                        result = result * 59 + ($EIGHT == null ? 43 : $EIGHT.hashCode());
                        String $NINE = this.NINE;
                        result = result * 59 + ($NINE == null ? 43 : $NINE.hashCode());
                        return result;
                    }
                }

                public static class EXCEPTIONS {
                    public String ELEVEN = "eleven";
                    public String TWELVE = "twelve";
                    public String THIRTEEN = "thirteen";
                    public String FOURTEEN = "fourteen";
                    public String FIFTEEN = "fifteen";
                    public String SIXTEEN = "sixteen";
                    public String SEVENTEEN = "seventeen";
                    public String EIGHTEEN = "eighteen";
                    public String NINETEEN = "nineteen";

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof EXCEPTIONS)) {
                            return false;
                        }
                        EXCEPTIONS other = (EXCEPTIONS)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$ELEVEN = this.ELEVEN;
                        String other$ELEVEN = other.ELEVEN;
                        if (this$ELEVEN == null ? other$ELEVEN != null : !this$ELEVEN.equals(other$ELEVEN)) {
                            return false;
                        }
                        String this$TWELVE = this.TWELVE;
                        String other$TWELVE = other.TWELVE;
                        if (this$TWELVE == null ? other$TWELVE != null : !this$TWELVE.equals(other$TWELVE)) {
                            return false;
                        }
                        String this$THIRTEEN = this.THIRTEEN;
                        String other$THIRTEEN = other.THIRTEEN;
                        if (this$THIRTEEN == null ? other$THIRTEEN != null : !this$THIRTEEN.equals(other$THIRTEEN)) {
                            return false;
                        }
                        String this$FOURTEEN = this.FOURTEEN;
                        String other$FOURTEEN = other.FOURTEEN;
                        if (this$FOURTEEN == null ? other$FOURTEEN != null : !this$FOURTEEN.equals(other$FOURTEEN)) {
                            return false;
                        }
                        String this$FIFTEEN = this.FIFTEEN;
                        String other$FIFTEEN = other.FIFTEEN;
                        if (this$FIFTEEN == null ? other$FIFTEEN != null : !this$FIFTEEN.equals(other$FIFTEEN)) {
                            return false;
                        }
                        String this$SIXTEEN = this.SIXTEEN;
                        String other$SIXTEEN = other.SIXTEEN;
                        if (this$SIXTEEN == null ? other$SIXTEEN != null : !this$SIXTEEN.equals(other$SIXTEEN)) {
                            return false;
                        }
                        String this$SEVENTEEN = this.SEVENTEEN;
                        String other$SEVENTEEN = other.SEVENTEEN;
                        if (this$SEVENTEEN == null ? other$SEVENTEEN != null : !this$SEVENTEEN.equals(other$SEVENTEEN)) {
                            return false;
                        }
                        String this$EIGHTEEN = this.EIGHTEEN;
                        String other$EIGHTEEN = other.EIGHTEEN;
                        if (this$EIGHTEEN == null ? other$EIGHTEEN != null : !this$EIGHTEEN.equals(other$EIGHTEEN)) {
                            return false;
                        }
                        String this$NINETEEN = this.NINETEEN;
                        String other$NINETEEN = other.NINETEEN;
                        return !(this$NINETEEN == null ? other$NINETEEN != null : !this$NINETEEN.equals(other$NINETEEN));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof EXCEPTIONS;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $ELEVEN = this.ELEVEN;
                        result = result * 59 + ($ELEVEN == null ? 43 : $ELEVEN.hashCode());
                        String $TWELVE = this.TWELVE;
                        result = result * 59 + ($TWELVE == null ? 43 : $TWELVE.hashCode());
                        String $THIRTEEN = this.THIRTEEN;
                        result = result * 59 + ($THIRTEEN == null ? 43 : $THIRTEEN.hashCode());
                        String $FOURTEEN = this.FOURTEEN;
                        result = result * 59 + ($FOURTEEN == null ? 43 : $FOURTEEN.hashCode());
                        String $FIFTEEN = this.FIFTEEN;
                        result = result * 59 + ($FIFTEEN == null ? 43 : $FIFTEEN.hashCode());
                        String $SIXTEEN = this.SIXTEEN;
                        result = result * 59 + ($SIXTEEN == null ? 43 : $SIXTEEN.hashCode());
                        String $SEVENTEEN = this.SEVENTEEN;
                        result = result * 59 + ($SEVENTEEN == null ? 43 : $SEVENTEEN.hashCode());
                        String $EIGHTEEN = this.EIGHTEEN;
                        result = result * 59 + ($EIGHTEEN == null ? 43 : $EIGHTEEN.hashCode());
                        String $NINETEEN = this.NINETEEN;
                        result = result * 59 + ($NINETEEN == null ? 43 : $NINETEEN.hashCode());
                        return result;
                    }
                }
            }

            public static class DEFAULT_FONT_DATA {
                public boolean ENABLED = true;
                public boolean ITALIC = false;
                public boolean BOLD = false;

                public DEFAULT_FONT_DATA() {
                }

                public DEFAULT_FONT_DATA(boolean ENABLED, boolean ITALIC, boolean BOLD) {
                    this.ENABLED = ENABLED;
                    this.ITALIC = ITALIC;
                    this.BOLD = BOLD;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof DEFAULT_FONT_DATA)) {
                        return false;
                    }
                    DEFAULT_FONT_DATA other = (DEFAULT_FONT_DATA)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.ENABLED != other.ENABLED) {
                        return false;
                    }
                    if (this.ITALIC != other.ITALIC) {
                        return false;
                    }
                    return this.BOLD == other.BOLD;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof DEFAULT_FONT_DATA;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + (this.ENABLED ? 79 : 97);
                    result = result * 59 + (this.ITALIC ? 79 : 97);
                    result = result * 59 + (this.BOLD ? 79 : 97);
                    return result;
                }
            }
        }
    }
}

