/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.database;

import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;

public interface Database {
    public String getName();

    public void start() throws Exception;

    public void stop() throws Exception;

    public Connection getConnection();

    public ExecutorService getExecutor();

    default public String upsertFromValues(String key, LinkedHashMap<String, String> values) {
        StringBuilder sb = new StringBuilder("ON CONFLICT (" + key + ") DO UPDATE SET ");
        int start = 1;
        int max = values.size();
        for (String value : values.keySet()) {
            sb.append(value).append(" = EXCLUDED.").append(value);
            if (start != max) {
                sb.append(", ");
            }
            ++start;
        }
        return sb.toString();
    }

    public boolean needCloseConnection();
}

