/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.dump;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class SystemInfo {
    private final int cpuCount = Runtime.getRuntime().availableProcessors();
    private final String cpuName = SystemInfo.tryGetProcessorName();
    private final Locale systemLocale = Locale.getDefault();
    private final String systemEncoding = System.getProperty("file.encoding");

    private static String tryGetProcessorName() {
        try {
            if (new File("/proc/cpuinfo").canRead()) {
                return SystemInfo.getLinuxProcessorName();
            }
            return SystemInfo.getWindowsProcessorName();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static String getLinuxProcessorName() throws Exception {
        List<String> lines = Files.readAllLines(Paths.get("/proc/cpuinfo", new String[0]), StandardCharsets.UTF_8);
        Pattern whitespaceColonWhitespace = Pattern.compile("\\s+:\\s");
        for (String line : lines) {
            String[] splitLine = whitespaceColonWhitespace.split(line);
            if (!"model name".equals(splitLine[0]) && !"Processor".equals(splitLine[0])) continue;
            return splitLine[1];
        }
        return "unknown";
    }

    private static String getWindowsProcessorName() throws Exception {
        String cpuNameCmd = "reg query \"HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\" /v ProcessorNameString";
        String regstrToken = "REG_SZ";
        Process process = Runtime.getRuntime().exec("reg query \"HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\" /v ProcessorNameString");
        process.waitFor();
        StringBuilder sb = new StringBuilder();
        try (InputStream is = process.getInputStream();){
            while (is.available() != 0) {
                sb.append((char)is.read());
            }
        }
        String result = sb.toString();
        int p = result.indexOf("REG_SZ");
        if (p == -1) {
            return null;
        }
        return result.substring(p + "REG_SZ".length()).trim();
    }

    public int getCpuCount() {
        return this.cpuCount;
    }

    public String getCpuName() {
        return this.cpuName;
    }

    public Locale getSystemLocale() {
        return this.systemLocale;
    }

    public String getSystemEncoding() {
        return this.systemEncoding;
    }
}

