/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.forge;

import com.google.common.base.Preconditions;
import io.github.waterfallmc.waterfall.event.ModernFMLHandshakeEvent;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.forge.ForgeConstants;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginPayloadRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.shieldcommunity.nullcordx.forge.ModernForgeUpstreamBridge;

public class ModernForgeServerConnector
extends ServerConnector {
    private final Queue<LoginPayloadRequest> pendingHandshakes = new ConcurrentLinkedQueue<LoginPayloadRequest>();
    private volatile State thisState = State.PLAIN;

    public ModernForgeServerConnector(ProxyServer bungee, UserConnection user, BungeeServerInfo target) {
        super(bungee, user, target);
    }

    @Override
    public boolean shouldHandle(PacketWrapper packet) throws Exception {
        return this.user.isConnected() && (this.thisState != State.PLAIN ? packet.packet instanceof LoginPayloadRequest || packet.packet instanceof SetCompression || packet.packet instanceof LoginSuccess || packet.packet instanceof EncryptionResponse || packet.packet instanceof PluginMessage || packet.packet instanceof Kick : super.shouldHandle(packet));
    }

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        super.connected(channel);
    }

    @Override
    public void handle(LoginSuccess loginSuccess) throws Exception {
        Preconditions.checkState(this.thisState != State.PENDING, "Not expecting PENDING");
        if (this.thisState == State.ACK) {
            this.user.unsafe().sendPacket(loginSuccess);
            this.user.getCh().setProtocol(Protocol.GAME);
            this.user.getCh().endHandshake();
            this.user.getCh().getHandle().pipeline().get(HandlerBoss.class).setHandler(new UpstreamBridge(this.bungee, this.user));
            this.thisState = State.PLAIN;
        }
        super.handle(loginSuccess);
    }

    @Override
    public void handle(Login login) throws Exception {
        super.handle(login);
    }

    @Override
    public void handle(LoginPayloadRequest request) {
        switch (this.thisState) {
            case PLAIN: {
                this.user.setForgeServerHandler(this.getHandshakeHandler());
                this.user.getCh().getHandle().flush();
                this.user.getCh().write(ForgeConstants.MODERN_FML_RESET);
                this.user.getCh().setProtocol(Protocol.LOGIN);
                this.user.getCh().beginHandshake();
                this.user.getCh().getHandle().pipeline().get(HandlerBoss.class).setHandler(new ModernForgeUpstreamBridge(this.bungee, this.user, this));
                if (this.user.getServer() != null) {
                    this.user.getServer().setObsolete(true);
                    this.user.getServer().disconnect("Quiting");
                }
                this.thisState = State.PENDING;
            }
            case PENDING: {
                this.pendingHandshakes.add(request);
                break;
            }
            case ACK: {
                this.writePacket(request);
            }
        }
    }

    public void onResetAck() {
        Preconditions.checkState(this.thisState == State.PENDING, "Not expecting PENDING");
        while (!this.pendingHandshakes.isEmpty()) {
            this.writePacket(this.pendingHandshakes.poll());
        }
        this.thisState = State.ACK;
    }

    public ChannelWrapper getChannel() {
        return this.ch;
    }

    @Override
    public String toString() {
        if (this.thisState != State.PLAIN) {
            return "[" + this.user.getName() + "|" + this.user.getAddress() + "] <-> Modern FML " + this.thisState + " [" + this.target.getName() + "]";
        }
        return super.toString();
    }

    private void writePacket(LoginPayloadRequest packet) {
        ModernFMLHandshakeEvent.Request event = new ModernFMLHandshakeEvent.Request(this.user, this.target, packet);
        if (event.callEvent()) {
            this.user.unsafe().sendPacket(packet);
        } else if (event.getResponse() != null) {
            this.user.getForgeServerHandler().getCh().write(event.getResponse());
        }
    }

    public BungeeServerInfo getTarget() {
        return this.target;
    }

    public State getThisState() {
        return this.thisState;
    }

    static enum State {
        PLAIN,
        PENDING,
        ACK;

    }
}

