/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.forge;

import io.github.waterfallmc.waterfall.event.ModernFMLHandshakeEvent;
import io.netty.handler.timeout.ReadTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.shieldcommunity.nullcordx.forge.ModernForgeServerConnector;

public class ModernForgeUpstreamBridge
extends PacketHandler {
    private final ProxyServer bungee;
    private final UserConnection con;
    private final ModernForgeServerConnector server;
    private static final byte[] RESET_ACK = "lightfall:ack".getBytes(StandardCharsets.UTF_8);

    @Override
    public boolean shouldHandle(PacketWrapper packet) throws Exception {
        return packet.packet instanceof LoginPayloadResponse;
    }

    @Override
    public void handle(LoginPayloadResponse response) throws Exception {
        if (ModernForgeUpstreamBridge.isAckPacket(response)) {
            this.server.onResetAck();
        } else if (new ModernFMLHandshakeEvent.Response(this.con, this.server.getTarget(), response).callEvent()) {
            this.con.getForgeServerHandler().getCh().write(response);
        }
    }

    @Override
    public void exception(Throwable t2) throws Exception {
        if (this.server.getThisState() == ModernForgeServerConnector.State.PENDING) {
            this.con.getCh().setProtocol(Protocol.GAME);
        }
        if (t2 instanceof ReadTimeoutException) {
            this.con.disconnect("You need to install lightfall to make NullCordX work with arcligth");
        } else {
            this.con.getCh().close();
        }
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        PlayerDisconnectEvent event = new PlayerDisconnectEvent(this.con);
        this.bungee.getPluginManager().callEvent(event);
        this.con.getTabListHandler().onDisconnect();
        this.server.getChannel().close();
        BungeeCord.getInstance().removeConnection(this.con);
    }

    @Override
    public String toString() {
        return "[" + this.con.getAddress() + "|" + this.con.getName() + "] -> HS Upstream";
    }

    private static boolean isAckPacket(LoginPayloadResponse response) {
        return Arrays.equals(response.getData(), RESET_ACK);
    }

    public ModernForgeUpstreamBridge(ProxyServer bungee, UserConnection con, ModernForgeServerConnector server) {
        this.bungee = bungee;
        this.con = con;
        this.server = server;
    }
}

