/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.apache.commons.net.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;

public final class FromNetASCIIInputStream
extends PushbackInputStream {
    static final boolean _noConversionRequired;
    static final String _lineSeparator;
    static final byte[] _lineSeparatorBytes;
    private int length;

    public static boolean isConversionRequired() {
        return !_noConversionRequired;
    }

    public FromNetASCIIInputStream(InputStream input) {
        super(input, _lineSeparatorBytes.length + 1);
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
        return this.buf.length - this.pos + this.in.available();
    }

    @Override
    public int read() throws IOException {
        if (_noConversionRequired) {
            return super.read();
        }
        return this.readInt();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (_noConversionRequired) {
            return super.read(buffer, offset, length);
        }
        if (length < 1) {
            return 0;
        }
        int ch = this.available();
        this.length = Math.min(length, ch);
        if (this.length < 1) {
            this.length = 1;
        }
        if ((ch = this.readInt()) == -1) {
            return -1;
        }
        int off = offset;
        do {
            buffer[offset++] = (byte)ch;
        } while (--this.length > 0 && (ch = this.readInt()) != -1);
        return offset - off;
    }

    private int readInt() throws IOException {
        int ch = super.read();
        if (ch == 13) {
            ch = super.read();
            if (ch != 10) {
                if (ch != -1) {
                    this.unread(ch);
                }
                return 13;
            }
            this.unread(_lineSeparatorBytes);
            ch = super.read();
            --this.length;
        }
        return ch;
    }

    static {
        _lineSeparator = System.lineSeparator();
        _noConversionRequired = _lineSeparator.equals("\r\n");
        _lineSeparatorBytes = _lineSeparator.getBytes(StandardCharsets.US_ASCII);
    }
}

