/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.object;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.LoadResult;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.exceptions.SerializableReadException;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.exceptions.SerializableWriteException;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.reader.AbstractReader;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.writer.AbstractWriter;

public abstract class AbstractSerializable {
    private static final DateTimeFormatter BACKUP_DATE_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss");
    private final Path serializablePath;
    private SerializerConfig config;

    protected AbstractSerializable() {
        this(SerializerConfig.DEFAULT);
    }

    protected AbstractSerializable(SerializerConfig config) {
        this(null, config);
    }

    protected AbstractSerializable(Path serializablePath, SerializerConfig config) {
        this.serializablePath = serializablePath;
        this.config = config;
    }

    public void setConfig(SerializerConfig config) {
        this.config = config;
    }

    public SerializerConfig getConfig() {
        return this.config;
    }

    public LoadResult reload() {
        if (this.serializablePath == null) {
            throw new IllegalStateException("This AbstractSerializable was constructed without serializablePath. Either construct AbstractSerializable with serializablePath or call AbstractSerializable#reload(Path) method.");
        }
        return this.reload(this.serializablePath);
    }

    public LoadResult reload(Path path) {
        LoadResult result = this.load(path);
        switch (result) {
            case SUCCESS: {
                this.save(path);
                break;
            }
            case CONFIG_NOT_EXISTS: {
                this.save(path);
                this.load(path);
                break;
            }
            case BACKUP_PREFERRED: {
                if (this.config.isBackupOnErrors()) {
                    this.backup(path);
                }
                this.save(path);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid LoadResult.");
            }
        }
        return result;
    }

    public LoadResult load() {
        if (this.serializablePath == null) {
            throw new IllegalStateException("This AbstractSerializable was constructed without serializablePath. Either construct AbstractSerializable with serializablePath or call AbstractSerializable#load(Path) method.");
        }
        return this.load(this.serializablePath);
    }

    public LoadResult load(Path path) {
        Path absolutePath = path.toAbsolutePath();
        if (Files.exists(absolutePath, new LinkOption[0])) {
            try {
                return this.load(Files.newBufferedReader(absolutePath)) ? LoadResult.SUCCESS : LoadResult.BACKUP_PREFERRED;
            }
            catch (IOException e) {
                throw new SerializableReadException(e);
            }
        }
        return LoadResult.CONFIG_NOT_EXISTS;
    }

    public boolean load(BufferedReader reader) {
        AbstractReader abstractReader = this.getReader(reader);
        abstractReader.readSerializableObject(this, this.getClass());
        return !abstractReader.isBackupPreferred();
    }

    public void save() {
        if (this.serializablePath == null) {
            throw new IllegalStateException("This AbstractSerializable was constructed without serializablePath. Either construct AbstractSerializable with serializablePath or call AbstractSerializable#save(Path) method.");
        }
        this.save(this.serializablePath);
    }

    public void save(Path path) {
        try {
            Path absolutePath = path.toAbsolutePath();
            Path parent = absolutePath.getParent();
            if (parent == null) {
                throw new NullPointerException("Parent path is null for " + absolutePath);
            }
            Files.createDirectories(parent, new FileAttribute[0]);
            this.save(Files.newBufferedWriter(absolutePath, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new SerializableWriteException(e);
        }
    }

    public void save(BufferedWriter writer) {
        Comment[] comments = (Comment[])this.getClass().getAnnotationsByType(Comment.class);
        AbstractWriter abstractWriter = this.getWriter(writer);
        abstractWriter.writeComments(comments, Comment.At.PREPEND, true);
        abstractWriter.writeSerializableObject(this, this.getClass());
        abstractWriter.writeComments(comments, Comment.At.SAME_LINE, true);
        abstractWriter.writeComments(comments, Comment.At.APPEND, true);
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new SerializableWriteException(e);
        }
    }

    public void backup() {
        if (this.serializablePath == null) {
            throw new IllegalStateException("This AbstractSerializable was constructed without serializablePath. Either construct AbstractSerializable with serializablePath or call AbstractSerializable#backup(Path) method.");
        }
        this.save(this.serializablePath);
    }

    public void backup(Path path) {
        try {
            Path absolutePath = path.toAbsolutePath();
            Path parent = absolutePath.getParent();
            if (parent == null) {
                throw new NullPointerException("Parent path is null for " + absolutePath);
            }
            Files.copy(absolutePath, parent.resolve(absolutePath.getFileName() + "_backup_" + LocalDateTime.now().format(BACKUP_DATE_PATTERN)), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new SerializableWriteException(e);
        }
    }

    protected abstract AbstractReader getReader(BufferedReader var1);

    protected abstract AbstractWriter getWriter(BufferedWriter var1);
}

