/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.elytrium.serializer.placeholders;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.placeholders.PlaceholderReplacer;

public class Placeholders {
    private static final Map<Integer, Placeholderable<?, ?>> PLACEHOLDERS = new HashMap();

    public static <T, R> R replace(T value, Object ... values) {
        return Placeholders.replaceFor(value, value, values);
    }

    public static <H, T, P, R> R replaceFor(H holder, T value, Object ... values) {
        Placeholderable<?, ?> placeholderable = PLACEHOLDERS.get(System.identityHashCode(holder));
        if (holder instanceof Collection) {
            Collection collection = (Collection)holder;
            ArrayList result = new ArrayList(collection.size());
            for (Object entry : collection) {
                if (placeholderable == null) {
                    placeholderable = PLACEHOLDERS.get(System.identityHashCode(entry));
                }
                if (placeholderable == null) {
                    throw new IllegalStateException("Invalid input!");
                }
                result.add(((Placeholderable)placeholderable).replacer.replace(entry, ((Placeholderable)placeholderable).placeholders, values));
            }
            return (R)result;
        }
        if (placeholderable == null) {
            throw new IllegalStateException("Invalid input!");
        }
        return (R)((Placeholderable)placeholderable).replacer.replace(value, ((Placeholderable)placeholderable).placeholders, values);
    }

    public static void addPlaceholders(Object value, PlaceholderReplacer<?, ?> replacer, String ... placeholders) {
        Placeholders.addPlaceholders(value, replacer, true, placeholders);
    }

    public static void addPlaceholders(Object value, PlaceholderReplacer<?, ?> replacer, boolean wrapWithBraces, String ... placeholders) {
        Placeholders.addPlaceholders(System.identityHashCode(value), replacer, wrapWithBraces, placeholders);
    }

    public static void addPlaceholders(int hash, PlaceholderReplacer<?, ?> replacer, String ... placeholders) {
        Placeholders.addPlaceholders(hash, replacer, true, placeholders);
    }

    public static void addPlaceholders(int hash, PlaceholderReplacer<?, ?> replacer, boolean wrapWithBraces, String ... placeholders) {
        PLACEHOLDERS.put(hash, new Placeholderable(replacer, placeholders, wrapWithBraces));
    }

    public static void setPlaceholders(Object value, PlaceholderReplacer<?, ?> fallbackReplacer, String ... placeholders) {
        Placeholders.setPlaceholders(System.identityHashCode(value), fallbackReplacer, placeholders);
    }

    public static void setPlaceholders(int hash, PlaceholderReplacer<?, ?> fallbackReplacer, String ... placeholders) {
        Placeholders.setPlaceholders(hash, fallbackReplacer, true, placeholders);
    }

    public static void setPlaceholders(int hash, PlaceholderReplacer<?, ?> fallbackReplacer, boolean wrapWithBraces, String ... placeholders) {
        Placeholderable<?, ?> placeholderable = PLACEHOLDERS.get(hash);
        if (placeholderable == null) {
            if (fallbackReplacer != null) {
                Placeholders.addPlaceholders(hash, fallbackReplacer, placeholders);
            }
        } else {
            ((Placeholderable)placeholderable).setPlaceholders(placeholders, wrapWithBraces);
        }
    }

    public static void removePlaceholders(Object value) {
        Placeholders.removePlaceholders(System.identityHashCode(value));
    }

    public static void removePlaceholders(int hash) {
        PLACEHOLDERS.remove(hash);
    }

    public static boolean hasPlaceholders(Object value) {
        return Placeholders.hasPlaceholders(System.identityHashCode(value));
    }

    public static boolean hasPlaceholders(int hash) {
        return PLACEHOLDERS.containsKey(hash);
    }

    public static <P> P[] getPlaceholders(Object value) {
        return Placeholders.getPlaceholders(System.identityHashCode(value));
    }

    public static <P> P[] getPlaceholders(int hash) {
        Placeholderable<?, ?> placeholderable = PLACEHOLDERS.get(hash);
        if (placeholderable == null) {
            throw new IllegalStateException("Invalid input!");
        }
        return ((Placeholderable)placeholderable).placeholders;
    }

    public static <T> PlaceholderReplacer<T, ?> getReplacer(T value) {
        return Placeholders.getReplacer(System.identityHashCode(value));
    }

    public static <T> PlaceholderReplacer<T, ?> getReplacer(int hash) {
        Placeholderable<?, ?> placeholderable = PLACEHOLDERS.get(hash);
        if (placeholderable == null) {
            throw new IllegalStateException("Invalid input!");
        }
        return ((Placeholderable)placeholderable).replacer;
    }

    private static class Placeholderable<T, P> {
        private final PlaceholderReplacer<T, P> replacer;
        private final Class<P> placeholdersClass;
        private P[] placeholders;

        private Placeholderable(PlaceholderReplacer<T, P> replacer, String[] placeholders, boolean wrapWithBraces) {
            this.replacer = replacer;
            this.placeholdersClass = this.determinePlaceholdersClass();
            this.setPlaceholders(placeholders, wrapWithBraces);
        }

        private Class<P> determinePlaceholdersClass() {
            for (Type interfaceType : this.replacer.getClass().getGenericInterfaces()) {
                Class clazz;
                ParameterizedType type;
                if (!(interfaceType instanceof ParameterizedType) || (type = (ParameterizedType)interfaceType).getRawType() != PlaceholderReplacer.class) continue;
                Type placeholderType = type.getActualTypeArguments()[1];
                return placeholderType instanceof Class ? (clazz = (Class)placeholderType) : (Class)((ParameterizedType)placeholderType).getRawType();
            }
            throw new IllegalStateException();
        }

        private void setPlaceholders(String[] placeholders, boolean wrapWithBraces) {
            this.placeholders = (Object[])Array.newInstance(this.placeholdersClass, placeholders.length);
            for (int i = placeholders.length - 1; i >= 0; --i) {
                String placeholder = placeholders[i];
                this.placeholders[i] = this.replacer.transformPlaceholder(wrapWithBraces && (placeholder.charAt(0) != '{' || placeholder.charAt(placeholder.length() - 1) != '}') ? '{' + placeholder + '}' : placeholder);
            }
        }
    }
}

