/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.maxmind.db;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Stack;
import net.shieldcommunity.nullcordx.libs.maxmind.db.ClosedDatabaseException;
import net.shieldcommunity.nullcordx.libs.maxmind.db.DatabaseRecord;
import net.shieldcommunity.nullcordx.libs.maxmind.db.InvalidDatabaseException;
import net.shieldcommunity.nullcordx.libs.maxmind.db.NetworksIterationException;
import net.shieldcommunity.nullcordx.libs.maxmind.db.Reader;

public final class Networks<T>
implements Iterator<DatabaseRecord<T>> {
    private final Reader reader;
    private final Stack<NetworkNode> nodes;
    private NetworkNode lastNode;
    private final boolean includeAliasedNetworks;
    private final ByteBuffer buffer;
    private final Class<T> typeParameterClass;

    Networks(Reader reader, boolean includeAliasedNetworks, Class<T> typeParameterClass) throws ClosedDatabaseException {
        this(reader, includeAliasedNetworks, new NetworkNode[0], typeParameterClass);
    }

    Networks(Reader reader, boolean includeAliasedNetworks, NetworkNode[] nodes, Class<T> typeParameterClass) throws ClosedDatabaseException {
        this.reader = reader;
        this.includeAliasedNetworks = includeAliasedNetworks;
        this.buffer = reader.getBufferHolder().get();
        this.nodes = new Stack();
        this.typeParameterClass = typeParameterClass;
        for (NetworkNode node : nodes) {
            this.nodes.push(node);
        }
    }

    Networks(Reader reader, Class<T> typeParameterClass) throws ClosedDatabaseException {
        this(reader, false, typeParameterClass);
    }

    @Override
    public DatabaseRecord<T> next() {
        try {
            InetAddress ipAddr;
            T data = this.reader.resolveDataPointer(this.buffer, this.lastNode.pointer, this.typeParameterClass);
            byte[] ip = this.lastNode.ip;
            int prefixLength = this.lastNode.prefix;
            if (!this.includeAliasedNetworks && this.isInIpv4Subtree(ip)) {
                ip = Arrays.copyOfRange(ip, 12, ip.length);
                prefixLength -= 96;
            }
            if ((ipAddr = InetAddress.getByAddress(ip)) instanceof Inet4Address && ip.length > 4 && prefixLength > 96) {
                prefixLength -= 96;
            }
            return new DatabaseRecord<T>(data, ipAddr, prefixLength);
        }
        catch (IOException e) {
            throw new NetworksIterationException(e);
        }
    }

    private boolean isInIpv4Subtree(byte[] ip) {
        if (ip.length != 16) {
            return false;
        }
        for (int i = 0; i < 12; ++i) {
            if (ip[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        while (!this.nodes.isEmpty()) {
            NetworkNode node = this.nodes.pop();
            while (node.pointer != this.reader.getMetadata().getNodeCount() && (this.includeAliasedNetworks || this.reader.getIpv4Start() == 0 || node.pointer != this.reader.getIpv4Start() || this.isInIpv4Subtree(node.ip))) {
                if (node.pointer > this.reader.getMetadata().getNodeCount()) {
                    this.lastNode = node;
                    return true;
                }
                byte[] ipRight = Arrays.copyOf(node.ip, node.ip.length);
                if (ipRight.length <= node.prefix >> 3) {
                    throw new NetworksIterationException("Invalid search tree");
                }
                int n = node.prefix >> 3;
                ipRight[n] = (byte)(ipRight[n] | 1 << 7 - node.prefix % 8);
                try {
                    int rightPointer = this.reader.readNode(this.buffer, node.pointer, 1);
                    ++node.prefix;
                    this.nodes.push(new NetworkNode(ipRight, node.prefix, rightPointer));
                    node.pointer = this.reader.readNode(this.buffer, node.pointer, 0);
                }
                catch (InvalidDatabaseException e) {
                    throw new NetworksIterationException(e);
                }
            }
        }
        return false;
    }

    static class NetworkNode {
        public byte[] ip;
        public int prefix;
        public int pointer;

        NetworkNode(byte[] ip, int prefix, int pointer) {
            this.ip = ip;
            this.prefix = prefix;
            this.pointer = pointer;
        }
    }
}

