/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.postgresql.core;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import net.shieldcommunity.nullcordx.libs.checkerframework.checker.nullness.qual.Nullable;
import net.shieldcommunity.nullcordx.libs.postgresql.core.Field;
import net.shieldcommunity.nullcordx.libs.postgresql.core.Query;
import net.shieldcommunity.nullcordx.libs.postgresql.core.ResultCursor;
import net.shieldcommunity.nullcordx.libs.postgresql.core.ResultHandler;
import net.shieldcommunity.nullcordx.libs.postgresql.core.Tuple;

public class ResultHandlerDelegate
implements ResultHandler {
    private final @Nullable ResultHandler delegate;

    public ResultHandlerDelegate(@Nullable ResultHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, @Nullable ResultCursor cursor) {
        if (this.delegate != null) {
            this.delegate.handleResultRows(fromQuery, fields, tuples, cursor);
        }
    }

    @Override
    public void handleCommandStatus(String status, long updateCount, long insertOID) {
        if (this.delegate != null) {
            this.delegate.handleCommandStatus(status, updateCount, insertOID);
        }
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        if (this.delegate != null) {
            this.delegate.handleWarning(warning);
        }
    }

    @Override
    public void handleError(SQLException error) {
        if (this.delegate != null) {
            this.delegate.handleError(error);
        }
    }

    @Override
    public void handleCompletion() throws SQLException {
        if (this.delegate != null) {
            this.delegate.handleCompletion();
        }
    }

    @Override
    public void secureProgress() {
        if (this.delegate != null) {
            this.delegate.secureProgress();
        }
    }

    @Override
    public @Nullable SQLException getException() {
        if (this.delegate != null) {
            return this.delegate.getException();
        }
        return null;
    }

    @Override
    public @Nullable SQLWarning getWarning() {
        if (this.delegate != null) {
            return this.delegate.getWarning();
        }
        return null;
    }
}

