/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.postgresql.core;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import net.shieldcommunity.nullcordx.libs.checkerframework.checker.nullness.qual.Nullable;
import net.shieldcommunity.nullcordx.libs.postgresql.core.Field;
import net.shieldcommunity.nullcordx.libs.postgresql.core.Query;
import net.shieldcommunity.nullcordx.libs.postgresql.core.QueryExecutor;
import net.shieldcommunity.nullcordx.libs.postgresql.core.ResultCursor;
import net.shieldcommunity.nullcordx.libs.postgresql.core.ResultHandlerBase;
import net.shieldcommunity.nullcordx.libs.postgresql.core.Tuple;
import net.shieldcommunity.nullcordx.libs.postgresql.util.GT;
import net.shieldcommunity.nullcordx.libs.postgresql.util.PSQLException;
import net.shieldcommunity.nullcordx.libs.postgresql.util.PSQLState;

public class SetupQueryRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable Tuple run(QueryExecutor executor, String queryString, boolean wantResults) throws SQLException {
        Query query = executor.createSimpleQuery(queryString);
        SimpleResultHandler handler = new SimpleResultHandler();
        int flags = 1041;
        if (!wantResults) {
            flags |= 6;
        }
        try {
            executor.execute(query, null, handler, 0, 0, flags);
        }
        finally {
            query.close();
        }
        if (!wantResults) {
            return null;
        }
        List<Tuple> tuples = handler.getResults();
        if (tuples == null || tuples.size() != 1) {
            throw new PSQLException(GT.tr("An unexpected result was returned by a query.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return tuples.get(0);
    }

    private static class SimpleResultHandler
    extends ResultHandlerBase {
        private @Nullable List<Tuple> tuples;

        private SimpleResultHandler() {
        }

        @Nullable List<Tuple> getResults() {
            return this.tuples;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, @Nullable ResultCursor cursor) {
            this.tuples = tuples;
        }

        @Override
        public void handleWarning(SQLWarning warning) {
        }
    }
}

