/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.postgresql.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.libs.checkerframework.checker.nullness.qual.Nullable;
import net.shieldcommunity.nullcordx.libs.postgresql.util.GT;
import net.shieldcommunity.nullcordx.libs.postgresql.util.LazyCleaner;
import net.shieldcommunity.nullcordx.libs.postgresql.util.StreamWrapper;
import net.shieldcommunity.nullcordx.libs.postgresql.util.internal.Nullness;

class TempFileHolder
implements LazyCleaner.CleaningAction<IOException> {
    private static final Logger LOGGER = Logger.getLogger(StreamWrapper.class.getName());
    private @Nullable InputStream stream;
    private @Nullable Path tempFile;

    TempFileHolder(Path tempFile) {
        this.tempFile = tempFile;
    }

    public InputStream getStream() throws IOException {
        InputStream stream = this.stream;
        if (stream == null) {
            this.stream = stream = Files.newInputStream(Nullness.castNonNull(this.tempFile), new OpenOption[0]);
        }
        return stream;
    }

    @Override
    public void onClean(boolean leak) throws IOException {
        InputStream stream;
        Path tempFile;
        if (leak) {
            LOGGER.log(Level.WARNING, GT.tr("StreamWrapper leak detected StreamWrapper.close() was not called. ", new Object[0]));
        }
        if ((tempFile = this.tempFile) != null) {
            tempFile.toFile().delete();
            this.tempFile = null;
        }
        if ((stream = this.stream) != null) {
            stream.close();
            this.stream = null;
        }
    }
}

