/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.squareup.gifencoder;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.Color;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.GifMath;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.Image;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.Streams;

final class ColorTable {
    private final Map<Integer, Color> indexToColor;
    private final Map<Color, Integer> colorToIndex;

    private ColorTable(Map<Integer, Color> indexToColor, Map<Color, Integer> colorToIndex) {
        this.indexToColor = indexToColor;
        this.colorToIndex = colorToIndex;
    }

    static ColorTable fromColors(Set<Color> colors) {
        HashMap<Integer, Color> indexToColor = new HashMap<Integer, Color>();
        HashMap<Color, Integer> colorToIndex = new HashMap<Color, Integer>();
        int index = 0;
        for (Color color : colors) {
            if (colorToIndex.containsKey(color)) continue;
            indexToColor.put(index, color);
            colorToIndex.put(color, index);
            ++index;
        }
        return new ColorTable(indexToColor, colorToIndex);
    }

    int paddedSize() {
        return Math.max(GifMath.roundUpToPowerOfTwo(this.unpaddedSize()), 2);
    }

    private int unpaddedSize() {
        return this.colorToIndex.size();
    }

    void write(OutputStream outputStream) throws IOException {
        int i;
        for (i = 0; i < this.unpaddedSize(); ++i) {
            Streams.writeRgb(outputStream, this.indexToColor.get(i).getRgbInt());
        }
        for (i = this.unpaddedSize(); i < this.paddedSize(); ++i) {
            Streams.writeRgb(outputStream, 0);
        }
    }

    int[] getIndices(Image image) {
        int[] result = new int[image.getNumPixels()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.colorToIndex.get(image.getColor(i));
        }
        return result;
    }
}

