/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.squareup.gifencoder;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.GifMath;

final class LzwEncoder {
    private static final List<Integer> CLEAR_CODE = Collections.singletonList(-1);
    private static final List<Integer> END_OF_INFO = Collections.singletonList(-2);
    private static final int MAX_CODE_TABLE_SIZE = 4096;
    private final int minimumCodeSize;
    private final BitSet outputBits = new BitSet();
    private int position = 0;
    private Map<List<Integer>, Integer> codeTable;
    private int codeSize;
    private List<Integer> indexBuffer = new ArrayList<Integer>();

    LzwEncoder(int colorTableSize) {
        if (!GifMath.isPowerOfTwo(colorTableSize)) {
            throw new IllegalArgumentException("Color table size must be a power of 2");
        }
        this.minimumCodeSize = LzwEncoder.computeMinimumCodeSize(colorTableSize);
        this.resetCodeTableAndCodeSize();
    }

    int getMinimumCodeSize() {
        return this.minimumCodeSize;
    }

    private static int computeMinimumCodeSize(int colorTableSize) {
        int size = 2;
        while (colorTableSize > 1 << size) {
            ++size;
        }
        return size;
    }

    byte[] encode(int[] indices) {
        this.writeCode(this.codeTable.get(CLEAR_CODE));
        for (int index : indices) {
            this.processIndex(index);
        }
        this.writeCode(this.codeTable.get(this.indexBuffer));
        this.writeCode(this.codeTable.get(END_OF_INFO));
        return this.toBytes();
    }

    private void processIndex(int index) {
        List<Integer> extendedIndexBuffer = LzwEncoder.append(this.indexBuffer, index);
        if (this.codeTable.containsKey(extendedIndexBuffer)) {
            this.indexBuffer = extendedIndexBuffer;
        } else {
            this.writeCode(this.codeTable.get(this.indexBuffer));
            if (this.codeTable.size() == 4096) {
                this.writeCode(this.codeTable.get(CLEAR_CODE));
                this.resetCodeTableAndCodeSize();
            } else {
                this.addCodeToTable(extendedIndexBuffer);
            }
            this.indexBuffer = Collections.singletonList(index);
        }
    }

    private void writeCode(int code) {
        for (int shift = 0; shift < this.codeSize; ++shift) {
            boolean bit = (code >>> shift & 1) != 0;
            this.outputBits.set(this.position++, bit);
        }
    }

    private byte[] toBytes() {
        int bitCount = this.position;
        byte[] result = new byte[(bitCount + 7) / 8];
        for (int i = 0; i < bitCount; ++i) {
            int byteIndex = i / 8;
            int bitIndex = i % 8;
            int n = byteIndex;
            result[n] = (byte)(result[n] | (this.outputBits.get(i) ? 1 : 0) << bitIndex);
        }
        return result;
    }

    private void addCodeToTable(List<Integer> indices) {
        int newCode = this.codeTable.size();
        this.codeTable.put(indices, newCode);
        if (newCode == 1 << this.codeSize) {
            ++this.codeSize;
        }
    }

    private void resetCodeTableAndCodeSize() {
        this.codeTable = this.defaultCodeTable();
        this.codeSize = this.minimumCodeSize + 1;
    }

    private Map<List<Integer>, Integer> defaultCodeTable() {
        HashMap<List<Integer>, Integer> codeTable = new HashMap<List<Integer>, Integer>();
        int colorsInCodeTable = 1 << this.minimumCodeSize;
        for (int i = 0; i < colorsInCodeTable; ++i) {
            codeTable.put(Collections.singletonList(i), i);
        }
        codeTable.put(CLEAR_CODE, codeTable.size());
        codeTable.put(END_OF_INFO, codeTable.size());
        return codeTable;
    }

    private static <T> List<T> append(List<T> list, T value) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(value);
        return result;
    }
}

