/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.squareup.gifencoder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.ArbitraryComparator;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.Color;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.ColorQuantizer;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.HashMultiset;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.Multiset;

public final class MedianCutQuantizer
implements ColorQuantizer {
    public static final MedianCutQuantizer INSTANCE = new MedianCutQuantizer();

    private MedianCutQuantizer() {
    }

    @Override
    public Set<Color> quantize(Multiset<Color> originalColors, int maxColorCount) {
        TreeSet<Cluster> clusters = new TreeSet<Cluster>(new ClusterSpreadComparator());
        clusters.add(new Cluster(originalColors));
        while (clusters.size() < maxColorCount) {
            Cluster clusterWithLargestSpread = clusters.pollFirst();
            clusters.addAll(clusterWithLargestSpread.split());
        }
        HashSet<Color> clusterCentroids = new HashSet<Color>();
        for (Cluster cluster : clusters) {
            clusterCentroids.add(Color.getCentroid(cluster.colors));
        }
        return clusterCentroids;
    }

    static final class ColorComponentComparator
    implements Comparator<Color> {
        final int component;

        ColorComponentComparator(int component) {
            this.component = component;
        }

        @Override
        public int compare(Color a, Color b) {
            double componentDifference = a.getComponent(this.component) - b.getComponent(this.component);
            if (componentDifference == 0.0) {
                return ArbitraryComparator.INSTANCE.compare(a, b);
            }
            return (int)Math.signum(componentDifference);
        }
    }

    static final class ClusterSpreadComparator
    implements Comparator<Cluster> {
        ClusterSpreadComparator() {
        }

        @Override
        public int compare(Cluster a, Cluster b) {
            double spreadDifference = b.largestSpread - a.largestSpread;
            if (spreadDifference == 0.0) {
                return ArbitraryComparator.INSTANCE.compare(a, b);
            }
            return (int)Math.signum(spreadDifference);
        }
    }

    private static final class Cluster {
        final Multiset<Color> colors;
        double largestSpread;
        int componentWithLargestSpread;

        Cluster(Multiset<Color> colors) {
            this.colors = colors;
            this.largestSpread = -1.0;
            for (int component = 0; component < 3; ++component) {
                double componentSpread = this.getComponentSpread(component);
                if (!(componentSpread > this.largestSpread)) continue;
                this.largestSpread = componentSpread;
                this.componentWithLargestSpread = component;
            }
        }

        double getComponentSpread(int component) {
            double min2 = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (Color color : this.colors) {
                min2 = Math.min(min2, color.getComponent(component));
                max = Math.max(max, color.getComponent(component));
            }
            return max - min2;
        }

        Collection<Cluster> split() {
            ArrayList<Color> orderedColors = new ArrayList<Color>(this.colors);
            Collections.sort(orderedColors, new ColorComponentComparator(this.componentWithLargestSpread));
            int medianIndex = orderedColors.size() / 2;
            return Arrays.asList(new Cluster(new HashMultiset<Color>(orderedColors.subList(0, medianIndex))), new Cluster(new HashMultiset<Color>(orderedColors.subList(medianIndex, orderedColors.size()))));
        }
    }
}

