/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.big.util;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.big.util.StringMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.Size64;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.io.BinIO;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongBigArrays;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongBigList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongMappedBigList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.Object2LongFunction;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.ObjectBigList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.FastBufferedReader;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.LineIterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.logging.ProgressLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LongBigListSignedStringMap
extends AbstractObject2LongFunction<CharSequence>
implements StringMap<CharSequence>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected final Object2LongFunction<? extends CharSequence> function;
    protected final LongBigList signatures;

    public static long[][] sign(Iterator<? extends CharSequence> iterator, Object2LongFunction<? extends CharSequence> function) {
        return LongBigListSignedStringMap.sign(iterator, function, null);
    }

    public static long[][] sign(Iterator<? extends CharSequence> iterator, Object2LongFunction<? extends CharSequence> function, ProgressLogger pl) {
        long n = function instanceof Size64 ? ((Size64)function).size64() : (long)function.size();
        long[][] signature = LongBigArrays.newBigArray((long)n);
        if (pl != null) {
            pl.expectedUpdates = n;
            pl.start("Signing...");
        }
        for (long i = 0L; i < n; ++i) {
            CharSequence s2 = iterator.next();
            LongBigArrays.set((long[][])signature, (long)function.getLong((Object)s2), (long)LongBigListSignedStringMap.signature(s2));
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (iterator.hasNext()) {
            throw new IllegalStateException("Iterator provides more than " + n + " elements");
        }
        if (pl != null) {
            pl.done();
        }
        return signature;
    }

    public LongBigListSignedStringMap(Object2LongFunction<? extends CharSequence> function, LongBigList signatures) {
        long n;
        long l = n = function instanceof Size64 ? ((Size64)function).size64() : (long)function.size();
        if (n != signatures.size64()) {
            throw new IllegalStateException("The size of the function differs from that of the signature list: " + n + " != " + signatures.size64());
        }
        this.function = function;
        this.signatures = signatures;
        this.defaultReturnValue(-1L);
    }

    public static void sign(Iterator<? extends CharSequence> iterator, String signatureFile) throws IOException {
        LongBigListSignedStringMap.sign(iterator, signatureFile, null);
    }

    public static void sign(Iterator<? extends CharSequence> iterator, String signatureFile, ProgressLogger pl) throws IOException {
        DataOutputStream dos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(signatureFile)));
        LongBigListSignedStringMap.sign(iterator, dos, pl);
        dos.close();
    }

    public static void sign(Iterator<? extends CharSequence> iterator, DataOutput signatures, ProgressLogger pl) throws IOException {
        if (pl != null) {
            pl.start("Signing...");
        }
        while (iterator.hasNext()) {
            CharSequence s2 = iterator.next();
            signatures.writeLong(LongBigListSignedStringMap.signature(s2));
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (pl != null) {
            pl.done();
        }
    }

    public LongBigListSignedStringMap(Object2LongFunction<? extends CharSequence> function, String signatures) throws FileNotFoundException, IOException {
        long n = function instanceof Size64 ? ((Size64)function).size64() : (long)function.size();
        long signatureSize = new File(signatures).length() / 8L;
        if (n != signatureSize) {
            throw new IllegalStateException("The size of the function differs from that of the signature list: " + n + " != " + signatureSize);
        }
        this.function = function;
        this.signatures = LongMappedBigList.map((FileChannel)new FileInputStream(signatures).getChannel());
        this.defaultReturnValue(-1L);
    }

    private static long signature(CharSequence s2) {
        int l = s2.length();
        long h2 = 42L;
        int i = l;
        while (i-- != 0) {
            h2 ^= (h2 << 5) + (long)s2.charAt(i) + (h2 >>> 2);
        }
        return h2;
    }

    private boolean checkSignature(CharSequence s2, long index) {
        return index >= 0L && index < (long)this.function.size() && this.signatures.getLong(index) == LongBigListSignedStringMap.signature(s2);
    }

    public long getLong(Object o) {
        CharSequence s2 = (CharSequence)o;
        long index = this.function.getLong((Object)s2);
        return this.checkSignature(s2, index) ? index : this.defRetValue;
    }

    public Long get(Object o) {
        CharSequence s2 = (CharSequence)o;
        long index = this.function.getLong((Object)s2);
        return this.checkSignature(s2, index) ? Long.valueOf(index) : null;
    }

    public boolean containsKey(Object o) {
        CharSequence s2 = (CharSequence)o;
        return this.checkSignature(s2, this.function.getLong((Object)s2));
    }

    @Override
    @Deprecated
    public int size() {
        return this.signatures.size();
    }

    @Override
    public long size64() {
        return this.signatures.size64();
    }

    @Override
    public ObjectBigList<CharSequence> list() {
        return null;
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(LongBigListSignedStringMap.class.getName(), "Generates a 64-bit signature file by reading a newline-separated list of strings and a function built on the same list of strings.", new Parameter[]{new FlaggedOption("bufferSize", JSAP.INTSIZE_PARSER, "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read strings."), new FlaggedOption("encoding", ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("function", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename of the function to be signed, or - for writing signatures in the same order of the strings."), new UnflaggedOption("signatures", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename of the resulting signatures."), new UnflaggedOption("stringFile", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "Read strings from this file instead of standard input.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        String functionName = jsapResult.getString("function");
        String signaturesName = jsapResult.getString("signatures");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        InputStream inputStream = stringFile != null ? new FileInputStream(stringFile) : System.in;
        LineIterator iterator = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(inputStream) : inputStream, encoding), bufferSize));
        Object2LongFunction function = "-".equals(functionName) ? null : (Object2LongFunction)BinIO.loadObject((CharSequence)functionName);
        Logger logger = LoggerFactory.getLogger(LongBigListSignedStringMap.class);
        ProgressLogger pl = new ProgressLogger(logger);
        if (function != null) {
            BinIO.storeLongs((long[][])LongBigListSignedStringMap.sign((Iterator<? extends CharSequence>)iterator, (Object2LongFunction<? extends CharSequence>)function, pl), (CharSequence)signaturesName);
        } else {
            LongBigListSignedStringMap.sign((Iterator<? extends CharSequence>)iterator, signaturesName, pl);
        }
        if (stringFile != null) {
            inputStream.close();
        }
    }
}

