/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.bits.Fast;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.Size64;

public class ByteDiskQueue
implements Closeable,
Size64 {
    private static final boolean DEBUG = false;
    private final File file;
    private final boolean direct;
    private int start;
    private int end;
    private int used;
    private int hole;
    private int mask;
    private FileChannel channel;
    private long writePosition;
    private long readPosition;
    private ByteBuffer buffer;

    protected ByteDiskQueue(File file, int bufferSize, boolean direct, boolean useFileContent) throws IOException {
        this.file = file;
        this.direct = direct;
        this.channel = new RandomAccessFile(file, "rw").getChannel();
        if (useFileContent) {
            this.writePosition = this.channel.size();
        } else {
            this.channel.truncate(0L);
        }
        this.hole = this.readPosition == this.writePosition ? -1 : 0;
        this.buffer = direct ? ByteBuffer.allocateDirect(Integer.highestOneBit(bufferSize)) : ByteBuffer.allocate(Integer.highestOneBit(bufferSize));
        this.mask = this.buffer.capacity() - 1;
    }

    public static ByteDiskQueue createNew(File file, int bufferSize, boolean direct) throws IOException {
        if (file.length() != 0L) {
            throw new IOException("File " + file + " is nonempty");
        }
        return new ByteDiskQueue(file, bufferSize, direct, false);
    }

    public static ByteDiskQueue createFromFile(File file, int bufferSize, boolean direct) throws IOException {
        if (!file.exists()) {
            throw new IOException("File " + file + " does not exist");
        }
        return new ByteDiskQueue(file, bufferSize, direct, true);
    }

    private void ensureNotClosed() {
        if (this.readPosition == -1L) {
            throw new IllegalStateException();
        }
    }

    public void enqueue(byte b) throws IOException {
        this.ensureNotClosed();
        if (this.used == this.buffer.capacity()) {
            this.dumpTail();
        }
        this.buffer.put(this.end++, b);
        this.end &= this.mask;
        ++this.used;
    }

    public void enqueueInt(int x) throws IOException {
        assert (x >= 0) : x;
        switch (Fast.mostSignificantBit(x) / 7 + 1) {
            case 1: {
                this.enqueue((byte)x);
                break;
            }
            case 2: {
                this.enqueue((byte)(x >>> 7 | 0x80));
                this.enqueue((byte)(x & 0x7F));
                break;
            }
            case 3: {
                this.enqueue((byte)(x >>> 14 | 0x80));
                this.enqueue((byte)(x >>> 7 | 0x80));
                this.enqueue((byte)(x & 0x7F));
                break;
            }
            case 4: {
                this.enqueue((byte)(x >>> 21 | 0x80));
                this.enqueue((byte)(x >>> 14 | 0x80));
                this.enqueue((byte)(x >>> 7 | 0x80));
                this.enqueue((byte)(x & 0x7F));
                break;
            }
            case 5: {
                this.enqueue((byte)(x >>> 28 | 0x80));
                this.enqueue((byte)(x >>> 21 | 0x80));
                this.enqueue((byte)(x >>> 14 | 0x80));
                this.enqueue((byte)(x >>> 7 | 0x80));
                this.enqueue((byte)(x & 0x7F));
            }
        }
    }

    public void enqueue(byte[] a, int offset, int length) throws IOException {
        int toBePut;
        this.ensureNotClosed();
        do {
            if (this.used == this.buffer.capacity()) {
                this.dumpTail();
            }
            assert (this.used != this.buffer.capacity()) : this.used + " == " + this.buffer.capacity();
            toBePut = Math.min(length, this.buffer.capacity() - this.used);
            this.buffer.clear();
            this.buffer.position(this.end);
            if (this.end < this.start) {
                this.buffer.put(a, offset, toBePut);
            } else {
                int firstTransfer = Math.min(toBePut, this.buffer.capacity() - this.end);
                this.buffer.put(a, offset, firstTransfer);
                if (firstTransfer < toBePut) {
                    this.buffer.clear();
                    this.buffer.put(a, offset + firstTransfer, toBePut - firstTransfer);
                }
            }
            offset += toBePut;
            this.used += toBePut;
            this.end = this.end + toBePut & this.mask;
        } while ((length -= toBePut) != 0);
        this.buffer.clear();
    }

    public void enqueue(byte[] a) throws IOException {
        this.enqueue(a, 0, a.length);
    }

    private void dumpTail() throws IOException {
        this.resume();
        this.channel.position(this.writePosition);
        if (this.hole == -1) {
            this.hole = this.start + this.buffer.capacity() / 2 & this.mask;
        }
        this.buffer.clear();
        this.buffer.position(this.hole);
        if (this.hole < this.end) {
            this.buffer.limit(this.end);
            this.channel.write(this.buffer);
            this.used -= this.end - this.hole;
        } else {
            this.channel.write(this.buffer);
            this.used -= this.buffer.capacity() - this.hole;
            this.buffer.position(0);
            this.buffer.limit(this.end);
            this.channel.write(this.buffer);
            this.used -= this.end;
        }
        this.buffer.clear();
        this.writePosition = this.channel.position();
        this.end = this.hole;
    }

    private void loadHead() throws IOException {
        assert (this.readPosition != this.writePosition) : this.readPosition + " == " + this.writePosition;
        if (this.used > this.buffer.capacity() / 2) {
            this.dumpTail();
        }
        this.resume();
        assert (this.size64() > (long)this.used) : this.size64() + " <= " + this.used;
        int toRead = (int)Math.min(this.writePosition - this.readPosition, (long)(this.buffer.capacity() / 2));
        this.start = this.hole - toRead & this.mask;
        this.channel.position(this.readPosition);
        this.buffer.clear();
        this.buffer.position(this.start);
        if (this.start < this.hole) {
            this.buffer.limit(this.hole);
            this.channel.read(this.buffer);
        } else {
            this.channel.read(this.buffer);
            this.buffer.position(0);
            this.buffer.limit(this.hole);
            this.channel.read(this.buffer);
        }
        this.buffer.clear();
        this.used += toRead;
        this.readPosition = this.channel.position();
        if (this.readPosition == this.writePosition) {
            this.writePosition = 0L;
            this.readPosition = 0L;
            this.hole = -1;
        }
        assert (this.start != this.hole) : this.start + " == " + this.hole;
    }

    public byte dequeue() throws IOException {
        this.ensureNotClosed();
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (this.start == this.hole) {
            this.loadHead();
        }
        byte result = this.buffer.get(this.start++);
        this.start &= this.mask;
        --this.used;
        return result;
    }

    public void dequeue(byte[] a, int offset, int length) throws IOException {
        this.ensureNotClosed();
        while (length != 0) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            if (this.start == this.hole) {
                this.loadHead();
            }
            assert (this.start != this.hole) : this.start + " == " + this.hole;
            int endOfTransfer = this.hole == -1 ? this.end : this.hole;
            int toTransfer = Math.min(length, endOfTransfer == this.start ? this.used : endOfTransfer - this.start & this.mask);
            this.buffer.clear();
            this.buffer.position(this.start);
            if (this.start < endOfTransfer) {
                this.buffer.get(a, offset, toTransfer);
            } else {
                int firstTransfer = Math.min(toTransfer, this.buffer.capacity() - this.start);
                this.buffer.get(a, offset, firstTransfer);
                if (firstTransfer < toTransfer) {
                    this.buffer.clear();
                    this.buffer.get(a, offset + firstTransfer, toTransfer - firstTransfer);
                }
            }
            offset += toTransfer;
            length -= toTransfer;
            this.used -= toTransfer;
            this.start = this.start + toTransfer & this.mask;
        }
        this.buffer.clear();
    }

    public void dequeue(byte[] a) throws IOException {
        this.dequeue(a, 0, a.length);
    }

    public int dequeueInt() throws IOException {
        int x = 0;
        while (true) {
            byte b = this.dequeue();
            x |= b & 0x7F;
            if (b >= 0) {
                return x;
            }
            x <<= 7;
        }
    }

    @Override
    @Deprecated
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size64() {
        return this.writePosition - this.readPosition + (long)this.used;
    }

    public boolean isEmpty() {
        return this.size64() == 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        this.readPosition = -1L;
        this.writePosition = -1L;
        this.used = 0;
        this.file.delete();
    }

    public void freeze() throws IOException {
        this.resume();
        File freezeFile = File.createTempFile(ByteDiskQueue.class.getSimpleName() + "-", ".freeze", this.file.getParentFile());
        FileOutputStream fos = new FileOutputStream(freezeFile);
        FileChannel freezeChannel = fos.getChannel();
        this.buffer.clear();
        this.buffer.position(this.start);
        if (this.hole == -1) {
            if (this.start < this.end) {
                this.buffer.limit(this.end);
                freezeChannel.write(this.buffer);
            } else if (this.used != 0) {
                freezeChannel.write(this.buffer);
                this.buffer.position(0);
                this.buffer.limit(this.end);
                freezeChannel.write(this.buffer);
            }
        } else {
            if (this.start < this.hole) {
                this.buffer.limit(this.hole);
                freezeChannel.write(this.buffer);
            } else if (this.start != this.hole) {
                freezeChannel.write(this.buffer);
                this.buffer.position(0);
                this.buffer.limit(this.hole);
                freezeChannel.write(this.buffer);
            }
            for (long position = this.readPosition; position < this.writePosition; position += this.channel.transferTo(position, this.writePosition - position, freezeChannel)) {
            }
            this.buffer.clear();
            this.buffer.position(this.hole);
            if (this.hole < this.end) {
                this.buffer.limit(this.end);
                freezeChannel.write(this.buffer);
            } else if (this.hole != this.end) {
                freezeChannel.write(this.buffer);
                this.buffer.position(0);
                this.buffer.limit(this.end);
                freezeChannel.write(this.buffer);
            }
        }
        assert (this.size64() == freezeChannel.size()) : this.size64() + " != " + freezeChannel.size();
        fos.close();
        this.channel.close();
        this.file.delete();
        if (!freezeFile.renameTo(this.file)) {
            throw new IOException("Cannot rename freeze file " + freezeFile + " to " + this.file);
        }
        this.channel = null;
        this.readPosition = -1L;
        this.writePosition = -1L;
        this.used = 0;
    }

    public void clear() {
        this.ensureNotClosed();
        this.used = 0;
        this.end = 0;
        this.start = 0;
        this.writePosition = this.readPosition = (long)0;
        this.hole = -1;
    }

    public void trim() throws IOException {
        this.ensureNotClosed();
        this.resume();
        this.channel.truncate(this.writePosition);
    }

    public void suspend() throws IOException {
        this.ensureNotClosed();
        if (this.channel == null) {
            return;
        }
        this.channel.close();
        this.channel = null;
    }

    private void resume() throws IOException {
        this.ensureNotClosed();
        if (this.channel != null) {
            return;
        }
        this.channel = new RandomAccessFile(this.file, "rw").getChannel();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.channel != null || this.writePosition != -1L) {
                System.err.println("WARNING: This " + this.getClass().getName() + " [" + this.toString() + "] should have been closed.");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void enlargeBuffer(int newBufferSize) {
        if ((newBufferSize = Integer.highestOneBit(newBufferSize)) <= this.buffer.capacity()) {
            return;
        }
        ByteBuffer newByteBuffer = this.direct ? ByteBuffer.allocateDirect(newBufferSize) : ByteBuffer.allocate(newBufferSize);
        this.buffer.clear();
        if (this.start < this.end) {
            this.buffer.position(this.start);
            this.buffer.limit(this.end);
            newByteBuffer.put(this.buffer);
            this.end -= this.start;
            if (this.hole >= 0) {
                this.hole -= this.start;
            }
        } else if (this.used != 0) {
            this.buffer.position(this.start);
            newByteBuffer.put(this.buffer);
            this.buffer.position(0);
            this.buffer.limit(this.end);
            newByteBuffer.put(this.buffer);
            this.end += this.buffer.capacity() - this.start;
            if (this.hole >= 0) {
                this.hole = this.hole >= this.start ? (this.hole -= this.start) : (this.hole += this.buffer.capacity() - this.start);
            }
        } else {
            this.end = 0;
            if (this.hole > 0) {
                this.hole = 0;
            }
        }
        this.start = 0;
        this.buffer = newByteBuffer;
        this.mask = newBufferSize - 1;
    }
}

