/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongComparator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongIterators;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongSet;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongSortedSet;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.LongIntervals;

public final class LongInterval
extends AbstractLongSortedSet
implements LongSortedSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SINGLE_POINT = 1024;
    private static final LongInterval[] POINT_INTERVAL = new LongInterval[1024];
    public final long left;
    public final long right;

    protected LongInterval(long left, long right) {
        this.left = left;
        this.right = right;
    }

    public static LongInterval valueOf(long left, long right) {
        if (left > right) {
            throw new IllegalArgumentException("The left extreme (" + left + ") is greater than the right extreme (" + right + ")");
        }
        if (left == right) {
            return LongInterval.valueOf(left);
        }
        return new LongInterval(left, right);
    }

    public static LongInterval valueOf(long point) {
        if (point >= 0L && point < 1024L) {
            return POINT_INTERVAL[(int)point];
        }
        return new LongInterval(point, point);
    }

    public long length() {
        return this.right - this.left + 1L;
    }

    @Override
    public int size() {
        return (int)Math.min(this.length(), Integer.MAX_VALUE);
    }

    public long size64() {
        return this.length();
    }

    @Override
    public LongBidirectionalIterator iterator() {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            return LongIterators.EMPTY_ITERATOR;
        }
        return LongIterators.fromTo(this.left, this.right + 1L);
    }

    public LongBidirectionalIterator iterator(long from) {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            return LongIterators.EMPTY_ITERATOR;
        }
        LongBidirectionalIterator i = LongIterators.fromTo(this.left, this.right + 1L);
        if (from >= this.left) {
            for (long toSkip = Math.min(this.length(), from + 1L - this.left); toSkip > 0L; toSkip -= (long)i.skip((int)Math.min(0x40000000L, toSkip))) {
            }
        }
        return i;
    }

    public boolean contains(int x) {
        return (long)x >= this.left && (long)x <= this.right;
    }

    public boolean contains(LongInterval interval) {
        if (interval == LongIntervals.EMPTY_INTERVAL) {
            return true;
        }
        if (this == LongIntervals.EMPTY_INTERVAL) {
            return false;
        }
        return this.left <= interval.left && interval.right <= this.right;
    }

    public boolean contains(int x, int radius) {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            throw new IllegalArgumentException();
        }
        return (long)x >= this.left - (long)radius && (long)x <= this.right + (long)radius;
    }

    public boolean contains(int x, int leftRadius, int rightRadius) {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            throw new IllegalArgumentException();
        }
        return (long)x >= this.left - (long)leftRadius && (long)x <= this.right + (long)rightRadius;
    }

    public int compareTo(int x) {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            throw new IllegalArgumentException();
        }
        if ((long)x < this.left) {
            return -1;
        }
        if ((long)x > this.right) {
            return 1;
        }
        return 0;
    }

    public int compareTo(int x, int radius) {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            throw new IllegalArgumentException();
        }
        if ((long)x < this.left - (long)radius) {
            return -1;
        }
        if ((long)x > this.right + (long)radius) {
            return 1;
        }
        return 0;
    }

    public int compareTo(int x, int leftRadius, int rightRadius) {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            throw new IllegalArgumentException();
        }
        if ((long)x < this.left - (long)leftRadius) {
            return -1;
        }
        if ((long)x > this.right + (long)rightRadius) {
            return 1;
        }
        return 0;
    }

    public LongComparator comparator() {
        return null;
    }

    public LongSortedSet headSet(long to) {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            return this;
        }
        if (to > this.left) {
            return to > this.right ? this : LongInterval.valueOf(this.left, to - 1L);
        }
        return LongIntervals.EMPTY_INTERVAL;
    }

    public LongSortedSet tailSet(long from) {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            return this;
        }
        if (from <= this.right) {
            return from <= this.left ? this : LongInterval.valueOf(from, this.right);
        }
        return LongIntervals.EMPTY_INTERVAL;
    }

    public LongSortedSet subSet(long from, long to) {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            return this;
        }
        if (from > to) {
            throw new IllegalArgumentException("Start element (" + from + ") is larger than end element (" + to + ")");
        }
        if (to <= this.left || from > this.right || from == to) {
            return LongIntervals.EMPTY_INTERVAL;
        }
        if (from <= this.left && to > this.right) {
            return this;
        }
        return LongInterval.valueOf(Math.max(this.left, from), Math.min(this.right, to - 1L));
    }

    public long firstLong() {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            throw new NoSuchElementException();
        }
        return this.left;
    }

    public long lastLong() {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            throw new NoSuchElementException();
        }
        return this.right;
    }

    @Override
    public String toString() {
        if (this == LongIntervals.EMPTY_INTERVAL) {
            return "\u2205";
        }
        if (this.left == this.right) {
            return "[" + this.left + "]";
        }
        return "[" + this.left + ".." + this.right + "]";
    }

    @Override
    public int hashCode() {
        return (int)(this.left * 23L + this.right);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LongInterval) {
            return ((LongInterval)o).left == this.left && ((LongInterval)o).right == this.right;
        }
        if (o instanceof LongSortedSet) {
            LongSortedSet s2 = (LongSortedSet)o;
            if ((long)s2.size() != this.length()) {
                return false;
            }
            long n = this.length();
            LongBidirectionalIterator i = this.iterator();
            LongBidirectionalIterator j = s2.iterator();
            while (n-- != 0L) {
                if (i.nextLong() == j.nextLong()) continue;
                return false;
            }
            return true;
        }
        if (o instanceof LongSet) {
            LongSet s3 = (LongSet)o;
            if ((long)s3.size() != this.length()) {
                return false;
            }
            long n = this.length();
            LongBidirectionalIterator i = this.iterator();
            while (n-- != 0L) {
                if (s3.contains(i.nextLong())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        int i = 1024;
        while (i-- != 0) {
            LongInterval.POINT_INTERVAL[i] = new LongInterval(i, i);
        }
    }
}

