/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.util;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.io.BinIO;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.FastBufferedReader;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.lang.MutableString;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.logging.ProgressLogger;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.AbstractPrefixMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.Interval;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.Intervals;

public class TernaryIntervalSearchTree
extends AbstractPrefixMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Node root;
    private int size;
    private boolean modified;

    public TernaryIntervalSearchTree() {
        this.defRetValue = -1L;
    }

    public TernaryIntervalSearchTree(Collection<? extends CharSequence> c) {
        int n = c.size();
        Iterator<? extends CharSequence> i = c.iterator();
        while (n-- != 0) {
            this.add(i.next());
        }
        this.defRetValue = -1L;
    }

    @Override
    protected Interval getInterval(CharSequence s2) {
        int l = s2.length();
        Node e = this.root;
        int offset = 0;
        int wordsAtLeft = 0;
        while (e != null) {
            int i;
            char[] path = e.path;
            for (i = 0; i < path.length - 1 && offset + i < l && s2.charAt(offset + i) == path[i]; ++i) {
            }
            if (offset + i == l) {
                return Interval.valueOf(wordsAtLeft, wordsAtLeft + e.numNodes - 1);
            }
            if (i < path.length - 1) {
                return Intervals.EMPTY_INTERVAL;
            }
            char c = s2.charAt(offset += i);
            if (c < path[i]) {
                e = e.left;
                continue;
            }
            if (c > path[i]) {
                if (e.left != null) {
                    wordsAtLeft += e.left.numNodes;
                }
                if (e.middle != null) {
                    wordsAtLeft += e.middle.numNodes;
                }
                if (e.isWord) {
                    ++wordsAtLeft;
                }
                e = e.right;
                continue;
            }
            ++offset;
            if (e.left != null) {
                wordsAtLeft += e.left.numNodes;
            }
            if (offset == l) {
                return Interval.valueOf(wordsAtLeft, wordsAtLeft + (e.isWord ? 1 : 0) + (e.middle == null ? 0 : e.middle.numNodes) - 1);
            }
            if (e.isWord) {
                ++wordsAtLeft;
            }
            e = e.middle;
        }
        return Intervals.EMPTY_INTERVAL;
    }

    public Interval getApproximatedInterval(CharSequence s2) {
        int l = s2.length();
        Node e = this.root;
        int offset = 0;
        int wordsAtLeft = 0;
        while (e != null) {
            int i;
            char[] path = e.path;
            for (i = 0; i < path.length - 1 && offset + i < l && s2.charAt(offset + i) == path[i]; ++i) {
            }
            if (offset + i == l) {
                return wordsAtLeft > 0 ? Interval.valueOf(wordsAtLeft - 1, wordsAtLeft + e.numNodes - 1) : Interval.valueOf(wordsAtLeft, wordsAtLeft + e.numNodes - 1);
            }
            if (i < path.length - 1) {
                if (s2.charAt(offset + i) < path[i]) {
                    return wordsAtLeft > 0 ? Interval.valueOf(wordsAtLeft - 1) : Intervals.EMPTY_INTERVAL;
                }
                return Interval.valueOf(wordsAtLeft + e.numNodes - 1);
            }
            char c = s2.charAt(offset += i);
            if (c < path[i]) {
                e = e.left;
                continue;
            }
            if (c > path[i]) {
                if (e.left != null) {
                    wordsAtLeft += e.left.numNodes;
                }
                if (e.middle != null) {
                    wordsAtLeft += e.middle.numNodes;
                }
                if (e.isWord) {
                    ++wordsAtLeft;
                }
                e = e.right;
                continue;
            }
            ++offset;
            if (e.left != null) {
                wordsAtLeft += e.left.numNodes;
            }
            if (offset == l) {
                return Interval.valueOf(wordsAtLeft - (e.isWord ? 0 : 1), wordsAtLeft + (e.isWord ? 1 : 0) + (e.middle == null ? 0 : e.middle.numNodes) - 1);
            }
            if (e.isWord) {
                ++wordsAtLeft;
            }
            e = e.middle;
        }
        return wordsAtLeft > 0 ? Interval.valueOf(wordsAtLeft - 1) : Intervals.EMPTY_INTERVAL;
    }

    @Override
    protected MutableString getTerm(int index, MutableString s2) {
        Node e = this.root;
        while (true) {
            if (e.left != null) {
                if (index < e.left.numNodes) {
                    s2.append(e.path, 0, e.path.length - 1);
                    e = e.left;
                    continue;
                }
                index -= e.left.numNodes;
            }
            if (e.isWord) {
                if (index == 0) {
                    return s2.append(e.path).compact();
                }
                --index;
            }
            if (e.middle != null) {
                if (index < e.middle.numNodes) {
                    s2.append(e.path);
                    e = e.middle;
                    continue;
                }
                index -= e.middle.numNodes;
            }
            s2.append(e.path, 0, e.path.length - 1);
            e = e.right;
        }
    }

    protected long getIndex(CharSequence s2) {
        int l = s2.length();
        Node e = this.root;
        int offset = 0;
        int wordsAtLeft = 0;
        while (e != null) {
            int i;
            char[] path = e.path;
            for (i = 0; i < path.length - 1; ++i) {
                if (offset + i != l && s2.charAt(offset + i) == path[i]) continue;
                return -1L;
            }
            if ((offset += i) == l) {
                return -1L;
            }
            char c = s2.charAt(offset);
            if (c < e.path[i]) {
                e = e.left;
                continue;
            }
            if (c > e.path[i]) {
                if (e.left != null) {
                    wordsAtLeft += e.left.numNodes;
                }
                if (e.middle != null) {
                    wordsAtLeft += e.middle.numNodes;
                }
                if (e.isWord) {
                    ++wordsAtLeft;
                }
                e = e.right;
                continue;
            }
            ++offset;
            if (e.left != null) {
                wordsAtLeft += e.left.numNodes;
            }
            if (offset == l) {
                return e.isWord ? (long)wordsAtLeft : -1L;
            }
            if (e.isWord) {
                ++wordsAtLeft;
            }
            e = e.middle;
        }
        return -1L;
    }

    public boolean containsKey(Object o) {
        return this.getIndex((CharSequence)o) != -1L;
    }

    public long getLong(Object o) {
        CharSequence s2 = (CharSequence)o;
        long result = this.getIndex(s2);
        return result == -1L ? this.defRetValue : result;
    }

    public boolean add(CharSequence s2) {
        this.modified = false;
        this.root = this.addRec(s2, 0, s2.length(), this.root);
        return this.modified;
    }

    private Node addRec(CharSequence s2, int offset, int length, Node e) {
        char c;
        int i;
        if (e == null) {
            this.modified = true;
            ++this.size;
            return new Node(s2, offset, length, true, 1);
        }
        Node n = null;
        char[] path = e.path;
        for (i = 0; i < path.length - 1; ++i) {
            c = s2.charAt(offset + i);
            if (c < path[i]) {
                n = new Node(path, 0, i + 1, false, e.numNodes + 1);
                n.middle = e;
                e.removePathPrefix(i + 1);
                n.left = this.addRec(s2, offset + i, length - i, null);
                break;
            }
            if (c > path[i]) {
                n = new Node(path, 0, i + 1, false, e.numNodes + 1);
                n.middle = e;
                e.removePathPrefix(i + 1);
                n.right = this.addRec(s2, offset + i, length - i, null);
                break;
            }
            if (i != length - 1) continue;
            n = new Node(s2, offset, length, true, e.numNodes + 1);
            n.middle = e;
            e.removePathPrefix(length);
            ++this.size;
            this.modified = true;
            break;
        }
        if (i < path.length - 1) {
            return n;
        }
        c = s2.charAt(offset + i);
        if (c < path[i]) {
            e.left = this.addRec(s2, offset + i, length - i, e.left);
            if (this.modified) {
                ++e.numNodes;
            }
        } else if (c > path[i]) {
            e.right = this.addRec(s2, offset + i, length - i, e.right);
            if (this.modified) {
                ++e.numNodes;
            }
        } else if (i == length - 1) {
            this.modified = !e.isWord;
            if (this.modified) {
                ++e.numNodes;
                ++this.size;
            }
            e.isWord = true;
        } else {
            e.middle = this.addRec(s2, offset + i + 1, length - i - 1, e.middle);
            if (this.modified) {
                ++e.numNodes;
            }
        }
        return e;
    }

    public int size() {
        return this.size;
    }

    public static void main(String[] arg) throws IOException, JSAPException, NoSuchMethodException {
        SimpleJSAP jsap = new SimpleJSAP(TernaryIntervalSearchTree.class.getName(), "Builds a ternary interval search tree reading from standard input a newline-separated list of terms.", new Parameter[]{new FlaggedOption("bufferSize", JSAP.INTSIZE_PARSER, "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read terms."), new FlaggedOption("encoding", ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The term file encoding."), new UnflaggedOption("tree", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised tree.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        TernaryIntervalSearchTree tree = new TernaryIntervalSearchTree();
        MutableString term = new MutableString();
        ProgressLogger pl = new ProgressLogger();
        pl.itemsName = "terms";
        FastBufferedReader terms = new FastBufferedReader((Reader)new InputStreamReader(System.in, (Charset)jsapResult.getObject("encoding")), jsapResult.getInt("bufferSize"));
        pl.start("Reading terms...");
        while (terms.readLine(term) != null) {
            pl.update();
            tree.add(term);
        }
        pl.done();
        BinIO.storeObject((Object)tree, (CharSequence)jsapResult.getString("tree"));
    }

    private static final class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Node left;
        public Node middle;
        public Node right;
        public char[] path;
        public boolean isWord;
        public int numNodes;

        public Node(CharSequence s2, int offset, int length, boolean isWord, int numNodes) {
            this.path = new char[length];
            MutableString.getChars(s2, offset, offset + length, this.path, 0);
            this.isWord = isWord;
            this.numNodes = numNodes;
        }

        public Node(char[] a, int offset, int length, boolean isWord, int numNodes) {
            this.path = new char[length];
            System.arraycopy(a, offset, this.path, 0, length);
            this.isWord = isWord;
            this.numNodes = numNodes;
        }

        public void removePathPrefix(int length) {
            char[] a = new char[this.path.length - length];
            System.arraycopy(this.path, length, a, 0, a.length);
            this.path = a;
        }
    }
}

