/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.modules.reconnect;

import java.io.File;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginDescription;

public class PluginReconnect
extends Plugin {
    private final ReconnectHandler reconnectHandler;

    public PluginReconnect(ProxyServer proxyServer, ReconnectHandler reconnectHandler) {
        super(proxyServer, PluginReconnect.createDescription(), true);
        this.reconnectHandler = reconnectHandler;
    }

    @Override
    public void onEnable() {
        this.applyReconnectHandler(this.reconnectHandler);
    }

    @Override
    public void onDisable() {
        this.applyReconnectHandler(null);
        this.getLogger().info("Saving reconnect locations");
        this.reconnectHandler.save();
        this.reconnectHandler.close();
    }

    private void applyReconnectHandler(ReconnectHandler reconnectHandler) {
        for (ListenerInfo info : this.getProxy().getConfig().getListeners()) {
            if (info.isForceDefault()) continue;
            this.getProxy().setReconnectHandler(reconnectHandler);
            break;
        }
    }

    private static PluginDescription createDescription() {
        PluginDescription description = new PluginDescription();
        description.setName("module-reconnect");
        description.setDescription("Provides reconnect location functionality in locations.yml");
        description.setVersion("3.8.4");
        description.setAuthor("md_5 & shieldcommunity");
        description.setMain("net.shieldcommunity.nullcordx.modules.reconnect.PluginReconnect");
        description.setFile(new File("modules" + File.separator + "module-reconnect"));
        return description;
    }
}

