/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.FastThreadLocal;
import net.shieldcommunity.nullcordx.natives.compression.BufferAllocationPolicy;

public final class ByteBufAllocationUtils {
    public static final FastThreadLocal<byte[]> ZLIB_DEFAULT_BUFFER = new FastThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[8192];
        }
    };

    public static ByteBuf makeCorrect(ByteBufAllocator alloc, BufferAllocationPolicy bufferAllocationPolicy, ByteBuf buf) {
        if (ByteBufAllocationUtils.isCorrect(bufferAllocationPolicy, buf)) {
            return buf.retain();
        }
        ByteBuf newBuf = alloc.directBuffer(buf.readableBytes());
        newBuf.writeBytes(buf);
        return newBuf;
    }

    private static boolean isCorrect(BufferAllocationPolicy bufferAllocationPolicy, ByteBuf buf) {
        if (bufferAllocationPolicy.isNeedDirectBuffer()) {
            return buf.hasMemoryAddress();
        }
        return true;
    }

    private ByteBufAllocationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

