/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives;

import net.shieldcommunity.nullcordx.natives.NativeEnvironmentDetector;
import net.shieldcommunity.nullcordx.natives.compression.CompressorFactory;
import net.shieldcommunity.nullcordx.natives.compression.igzip.IgzipCompressorFactory;
import net.shieldcommunity.nullcordx.natives.compression.java.JavaCompressorFactory;
import net.shieldcommunity.nullcordx.natives.compression.libdeflate.LibdeflateCompressorFactory;
import net.shieldcommunity.nullcordx.natives.compression.zlib.ZlibCompressorFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CompressionType {
    JAVA{

        @Override
        public CompressorFactory createFactory() {
            return new JavaCompressorFactory("Zlib (Java)");
        }
    }
    ,
    ZLIB{

        @Override
        public CompressorFactory createFactory() {
            if (NativeEnvironmentDetector.isLinux_X86_64()) {
                return new ZlibCompressorFactory("Zlib (native linux_x86_64)", "/native-compress.so");
            }
            return JAVA.createFactory();
        }
    }
    ,
    LIBDEFLATE{

        @Override
        public CompressorFactory createFactory() {
            if (NativeEnvironmentDetector.isLinux_X86_64()) {
                return new LibdeflateCompressorFactory("Libdeflate (native linux_x86_64)", "/libdeflate_x86_64.so");
            }
            if (NativeEnvironmentDetector.isLinux_AARCH64()) {
                return new LibdeflateCompressorFactory("Libdeflate (native linux_aarch64)", "/libdeflate_aarch64.so");
            }
            return JAVA.createFactory();
        }
    }
    ,
    IGZIP{

        @Override
        public CompressorFactory createFactory() {
            if (NativeEnvironmentDetector.isLinux_X86_64()) {
                return new IgzipCompressorFactory("Igzip (native linux_x86_64)", "/igzip_x86_64.so");
            }
            if (NativeEnvironmentDetector.isLinux_AARCH64()) {
                return new IgzipCompressorFactory("Igzip (native linux_aarch64)", "/igzip_aarch64.so");
            }
            return JAVA.createFactory();
        }
    };


    public abstract CompressorFactory createFactory();
}

